/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.retry.clientserver.RetryClassLevelClientForMaxRetries;
import org.eclipse.microprofile.fault.tolerance.tck.retry.clientserver.RetryClientForMaxRetries;
import org.eclipse.microprofile.fault.tolerance.tck.retry.clientserver.RetryClientWithDelay;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RetryTest
extends Arquillian {
    @Inject
    private RetryClientForMaxRetries clientForMaxRetry;
    @Inject
    private RetryClientWithDelay clientForDelay;
    @Inject
    private RetryClassLevelClientForMaxRetries clientForClassLevelMaxRetry;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftRetry.jar")).addClasses(new Class[]{RetryClientForMaxRetries.class, RetryClientWithDelay.class, RetryClassLevelClientForMaxRetries.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftRetry.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testRetryMaxRetries() {
        try {
            this.clientForMaxRetry.serviceA();
            Assert.fail((String)"serviceA should throw a RuntimeException in testRetryMaxRetries");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.clientForMaxRetry.getRetryCountForConnectionService(), (int)6, (String)"The max number of execution should be 6");
    }

    @Test
    public void testRetryMaxDuration() {
        try {
            this.clientForMaxRetry.serviceB();
            Assert.fail((String)"serviceB should throw a RuntimeException in testRetryMaxDuration");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertTrue((this.clientForMaxRetry.getRetryCountForWritingService() < 11 ? 1 : 0) != 0, (String)"The max retry counter should be less than 11");
    }

    @Test
    public void testRetryMaxDurationSeconds() {
        try {
            this.clientForMaxRetry.serviceC();
            Assert.fail((String)"serviceC should throw a RuntimeException in testRetryMaxDuration");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertTrue((this.clientForMaxRetry.getRetryCountForWritingService() < 11 ? 1 : 0) != 0, (String)"The max retry counter should be less than 11");
    }

    @Test
    public void testRetryWithDelay() {
        try {
            this.clientForDelay.serviceA();
            Assert.fail((String)"serviceA should throw a RuntimeException in testRetryWithDelay");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertTrue((this.clientForDelay.getRetryCountForConnectionService() > 4 ? 1 : 0) != 0, (String)"The max number of execution should be greater than 4");
        Assert.assertTrue((boolean)this.clientForDelay.isDelayInRange(), (String)"The delay between each retry should be 0-800ms");
    }

    @Test
    public void testClassLevelRetryMaxRetries() {
        try {
            this.clientForClassLevelMaxRetry.serviceA();
            Assert.fail((String)"serviceA should throw a RuntimeException in testClassLevelRetryMaxRetries");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.clientForClassLevelMaxRetry.getRetryCountForConnectionService(), (int)3, (String)"The max number of execution should be 3");
    }

    @Test
    public void testClassLevelRetryMaxDuration() {
        try {
            this.clientForClassLevelMaxRetry.serviceB();
            Assert.fail((String)"serviceB should throw a RuntimeException in testClassLevelRetryMaxDuration");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        int retryCountforWritingService = this.clientForClassLevelMaxRetry.getRetryCountForWritingService();
        Assert.assertTrue((retryCountforWritingService < 11 ? 1 : 0) != 0, (String)"The max retry counter should be less than 11");
        Assert.assertTrue((retryCountforWritingService > 3 ? 1 : 0) != 0, (String)"The max retry counter should be greater than 3");
    }

    @Test
    public void testClassLevelRetryMaxDurationSeconds() {
        try {
            this.clientForClassLevelMaxRetry.serviceC();
            Assert.fail((String)"serviceC should throw a RuntimeException in testClassLevelRetryMaxDurationSeconds");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertTrue((this.clientForClassLevelMaxRetry.getRetryCountForWritingService() < 11 ? 1 : 0) != 0, (String)"The max retry counter should be less than 11");
    }
}

