/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.clientserver.CircuitBreakerClassLevelClientWithRetry;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.clientserver.CircuitBreakerClientWithRetry;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CircuitBreakerRetryTest
extends Arquillian {
    @Inject
    private CircuitBreakerClientWithRetry clientForCBWithRetry;
    @Inject
    private CircuitBreakerClassLevelClientWithRetry clientForClassLevelCBWithRetry;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftCircuitBreakerRetry.jar")).addClasses(new Class[]{CircuitBreakerClientWithRetry.class, CircuitBreakerClassLevelClientWithRetry.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftCircuitBreakerRetry.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testCircuitOpenWithMoreRetries() {
        int invokeCounter = 0;
        try {
            this.clientForCBWithRetry.serviceA();
            invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceA();
            Assert.fail((String)("serviceA should retry in testCircuitOpenWithMoreRetries on iteration " + invokeCounter));
        }
        catch (CircuitBreakerOpenException cboe) {
            invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceA();
            if (invokeCounter < 4) {
                Assert.fail((String)("serviceA should retry in testCircuitOpenWithMoreRetries on iteration " + invokeCounter));
            }
        }
        catch (Exception ex) {
            invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceA();
            Assert.fail((String)("serviceA should retry or throw a CircuitBreakerOpenException in testCircuitOpenWithMoreRetries on iteration " + invokeCounter));
        }
        invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceA();
        Assert.assertEquals((int)invokeCounter, (int)4, (String)"The number of executions should be 4");
    }

    @Test
    public void testCircuitOpenWithFewRetries() {
        int invokeCounter = 0;
        try {
            this.clientForCBWithRetry.serviceB();
            invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceB();
            Assert.fail((String)("serviceB should retry in testCircuitOpenWithFewRetries on iteration " + invokeCounter));
        }
        catch (CircuitBreakerOpenException cboe) {
            invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceB();
            Assert.fail((String)("serviceB should retry or throw a RuntimeException (not a CBOE) in testCircuitOpenWithFewRetries on iteration " + invokeCounter));
        }
        catch (RuntimeException ex) {
            invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceB();
            if (invokeCounter < 3) {
                Assert.fail((String)("serviceB should retry in testCircuitOpenWithFewRetries on iteration " + invokeCounter));
            }
        }
        catch (Exception ex) {
            invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceB();
            Assert.fail((String)("serviceB should retry or throw a RuntimeException in testCircuitOpenWithFewRetries on iteration " + invokeCounter));
        }
        invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceB();
        Assert.assertEquals((int)invokeCounter, (int)3, (String)"The number of executions should be 3");
    }

    @Test
    public void testClassLevelCircuitOpenWithMoreRetries() {
        int invokeCounter = 0;
        try {
            this.clientForClassLevelCBWithRetry.serviceA();
            invokeCounter = this.clientForClassLevelCBWithRetry.getCounterForInvokingServiceA();
            Assert.fail((String)("serviceA should retry in testClassLevelCircuitOpenWithMoreRetries on iteration " + invokeCounter));
        }
        catch (CircuitBreakerOpenException cboe) {
            invokeCounter = this.clientForClassLevelCBWithRetry.getCounterForInvokingServiceA();
            if (invokeCounter < 4) {
                Assert.fail((String)("serviceA should retry in testClassLevelCircuitOpenWithMoreRetries on iteration " + invokeCounter));
            }
        }
        catch (Exception ex) {
            invokeCounter = this.clientForClassLevelCBWithRetry.getCounterForInvokingServiceA();
            Assert.fail((String)("serviceA should retry or throw a CircuitBreakerOpenException in testClassLevelCircuitOpenWithMoreRetries on iteration " + invokeCounter));
        }
        invokeCounter = this.clientForClassLevelCBWithRetry.getCounterForInvokingServiceA();
        Assert.assertEquals((int)invokeCounter, (int)4, (String)"The number of executions should be 4");
    }

    @Test
    public void testClassLevelCircuitOpenWithFewRetries() {
        int invokeCounter = 0;
        try {
            this.clientForClassLevelCBWithRetry.serviceB();
            invokeCounter = this.clientForClassLevelCBWithRetry.getCounterForInvokingServiceB();
            Assert.fail((String)("serviceB should retry in testClassLevelCircuitOpenWithFewRetries on iteration " + invokeCounter));
        }
        catch (CircuitBreakerOpenException cboe) {
            invokeCounter = this.clientForClassLevelCBWithRetry.getCounterForInvokingServiceB();
            Assert.fail((String)("serviceB should retry or throw a RuntimeException (not a CBOE) in testClassLevelCircuitOpenWithFewRetries on iteration " + invokeCounter));
        }
        catch (RuntimeException ex) {
            invokeCounter = this.clientForClassLevelCBWithRetry.getCounterForInvokingServiceB();
            if (invokeCounter < 3) {
                Assert.fail((String)("serviceB should retry in testClassLevelCircuitOpenWithFewRetries on iteration " + invokeCounter));
            }
        }
        catch (Exception ex) {
            invokeCounter = this.clientForClassLevelCBWithRetry.getCounterForInvokingServiceB();
            Assert.fail((String)("serviceB should retry or throw a RuntimeException in testClassLevelCircuitOpenWithFewRetries on iteration " + invokeCounter));
        }
        invokeCounter = this.clientForClassLevelCBWithRetry.getCounterForInvokingServiceB();
        Assert.assertEquals((int)invokeCounter, (int)3, (String)"The number of executions should be 3");
    }

    @Test
    public void testCircuitOpenWithMultiTimeouts() {
        int invokeCounter = 0;
        try {
            this.clientForCBWithRetry.serviceC(1000L);
            invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceC();
            Assert.fail((String)("serviceC should retry in testCircuitOpenWithMultiTimeouts on iteration " + invokeCounter));
        }
        catch (CircuitBreakerOpenException cboe) {
            invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceC();
            if (invokeCounter < 4) {
                Assert.fail((String)("serviceC should retry in testCircuitOpenWithMultiTimeouts on iteration " + invokeCounter));
            }
        }
        catch (Exception ex) {
            invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceC();
            Assert.fail((String)("serviceC should retry or throw a CircuitBreakerOpenException in testCircuitOpenWithMultiTimeouts on iteration " + invokeCounter + ", caught exception: " + ex));
        }
        invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceC();
        Assert.assertEquals((int)invokeCounter, (int)4, (String)"The number of executions should be 4");
    }
}

