/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.asynctimeout.clientserver.AsyncClassLevelTimeoutClient;
import org.eclipse.microprofile.fault.tolerance.tck.asynctimeout.clientserver.AsyncTimeoutClient;
import org.eclipse.microprofile.fault.tolerance.tck.util.Connection;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AsyncTimeoutTest
extends Arquillian {
    private static final long TEST_FUTURE_THRESHOLD = 2000L;
    private static final int TEST_TIMEOUT_SERVICEA = 2000;
    private static final int TEST_TIME_UNIT = 1000;
    @Inject
    private AsyncTimeoutClient clientForAsyncTimeout;
    @Inject
    private AsyncClassLevelTimeoutClient clientForClassLevelAsyncTimeout;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftAsyncTimeout.jar")).addClasses(new Class[]{AsyncTimeoutClient.class, AsyncClassLevelTimeoutClient.class, Connection.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftAsyncTimeout.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testAsyncTimeout() {
        long start = System.currentTimeMillis();
        Future<Connection> future = null;
        try {
            future = this.clientForAsyncTimeout.serviceA();
        }
        catch (InterruptedException e1) {
            throw new AssertionError((Object)"testAsyncTimeout: unexpected InterruptedException calling serviceA");
        }
        long end = System.currentTimeMillis();
        long duration = end - start;
        if (duration > 2000L) {
            throw new AssertionError((Object)("testAsyncTimeout: Method did not return quickly enough: " + duration));
        }
        if (future.isDone()) {
            throw new AssertionError((Object)"testAsyncTimeout: Future completed too fast");
        }
        try {
            future.get(3000L, TimeUnit.MILLISECONDS);
            throw new AssertionError((Object)"testAsyncTimeout: Future not interrupted");
        }
        catch (ExecutionException e) {
            Assert.assertSame(e.getCause().getClass(), org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException.class, (String)"Should be a wrapped TimeoutException");
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)"testAsyncTimeout: unexpected InterruptedException on future.get()");
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)"testAsyncTimeout: unexpected TimeoutException on future.get()");
        }
        end = System.currentTimeMillis();
        duration = end - start;
        if (duration < 2000L) {
            throw new AssertionError((Object)("testAsyncTimeout: the service duration was less than the configured timeout - " + duration));
        }
    }

    @Test
    public void testAsyncNoTimeout() {
        long start = System.currentTimeMillis();
        Future<Connection> future = null;
        try {
            future = this.clientForAsyncTimeout.serviceB();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)"testAsyncNoTimeout: unexpected InterruptedException calling serviceB");
        }
        long end = System.currentTimeMillis();
        long duration = end - start;
        if (duration > 2000L) {
            throw new AssertionError((Object)("testAsyncNoTimeout: Method did not return quickly enough: " + duration));
        }
        if (future.isDone()) {
            throw new AssertionError((Object)"testAsyncNoTimeout: Future completed too fast");
        }
        try {
            Connection connection = future.get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception t) {
            Assert.fail((String)"serviceB should not throw an Exception in testAsyncNoTimeout");
        }
    }

    @Test
    public void testAsyncClassLevelTimeout() {
        long start = System.currentTimeMillis();
        Future<Connection> future = null;
        try {
            future = this.clientForClassLevelAsyncTimeout.serviceA();
        }
        catch (InterruptedException e1) {
            throw new AssertionError((Object)"testAsyncClassLevelTimeout: unexpected InterruptedException calling serviceA");
        }
        long end = System.currentTimeMillis();
        long duration = end - start;
        if (duration > 2000L) {
            throw new AssertionError((Object)("testAsyncClassLevelTimeout: Method did not return quickly enough: " + duration));
        }
        if (future.isDone()) {
            throw new AssertionError((Object)"testAsyncClassLevelTimeout: Future completed too fast");
        }
        start = System.currentTimeMillis();
        try {
            future.get(3000L, TimeUnit.MILLISECONDS);
            throw new AssertionError((Object)"testAsyncClassLevelTimeout: Future not interrupted");
        }
        catch (ExecutionException e) {
            Assert.assertSame(e.getCause().getClass(), org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException.class, (String)"Should be a wrapped TimeoutException");
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)"testAsyncClassLevelTimeout: unexpected InterruptedException on future.get()");
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)"testAsyncClassLevelTimeout: unexpected TimeoutException on future.get()");
        }
        end = System.currentTimeMillis();
        duration = end - start;
        if (duration < 2000L) {
            throw new AssertionError((Object)("testAsyncClassLevelTimeout: the service duration was less than the configured timeout - " + duration));
        }
    }
}

