/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.clientserver;

import java.io.Serializable;
import java.sql.Connection;
import javax.enterprise.context.RequestScoped;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;

@RequestScoped
public class CircuitBreakerClientWithRetry
implements Serializable {
    private int counterForInvokingServiceA = 0;
    private int counterForInvokingServiceB = 0;
    private int counterForInvokingServiceC = 0;

    public int getCounterForInvokingServiceA() {
        return this.counterForInvokingServiceA;
    }

    public int getCounterForInvokingServiceB() {
        return this.counterForInvokingServiceB;
    }

    public int getCounterForInvokingServiceC() {
        return this.counterForInvokingServiceC;
    }

    @CircuitBreaker(successThreshold=2, requestVolumeThreshold=4, failureRatio=0.75, delay=50000L)
    @Retry(retryOn={RuntimeException.class}, maxRetries=7)
    public Connection serviceA() {
        Connection conn = null;
        ++this.counterForInvokingServiceA;
        conn = this.connectionService();
        return conn;
    }

    @CircuitBreaker(successThreshold=2, requestVolumeThreshold=4, failureRatio=0.75, delay=50000L)
    @Retry(retryOn={RuntimeException.class}, maxRetries=2)
    public Connection serviceB() {
        Connection conn = null;
        ++this.counterForInvokingServiceB;
        conn = this.connectionService();
        return conn;
    }

    @CircuitBreaker(successThreshold=2, requestVolumeThreshold=4, failureRatio=0.75, delay=50000L)
    @Retry(retryOn={RuntimeException.class, TimeoutException.class}, maxRetries=7, maxDuration=20000L)
    @Timeout(value=500L)
    public Connection serviceC(long timeToSleep) {
        Connection conn = null;
        ++this.counterForInvokingServiceC;
        try {
            Thread.sleep(timeToSleep);
            throw new RuntimeException("Timeout did not interrupt");
        }
        catch (InterruptedException interruptedException) {
            return conn;
        }
    }

    private Connection connectionService() {
        throw new RuntimeException("Connection failed");
    }
}

