/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.Future;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadTestBackend;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Checker;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.TestData;
import org.testng.Assert;

public class Utils {
    private static long tid() {
        return Thread.currentThread().getId();
    }

    static void handleResults(int number, Future[] results) {
        try {
            boolean done = false;
            while (!done) {
                done = true;
                for (int i = 0; i < number; ++i) {
                    boolean thisDone = results[i] == null || results[i].get() == null || results[i].isDone() || results[i].get() instanceof Future && ((Future)results[i].get()).isDone();
                    done = done && thisDone;
                    Utils.log("Result for " + i + (thisDone ? " (Done)" : " (NotDone)") + " is " + (results[i].get() instanceof Future ? ((Future)results[i].get()).get() : results[i].get()));
                }
                Thread.sleep(1000L);
            }
        }
        catch (Throwable e) {
            Utils.log(e.toString());
        }
    }

    public static void loop(int iterations, BulkheadTestBackend test, int maxSimultaneousWorkers, int expectedTasksScheduled, TestData td) {
        td.setExpectedMaxSimultaneousWorkers(maxSimultaneousWorkers);
        td.setExpectedInstances(iterations);
        td.setExpectedTasksScheduled(expectedTasksScheduled);
        Future[] results = new Future[iterations];
        try {
            for (int i = 0; i < iterations; ++i) {
                Utils.log("Starting test " + i);
                results[i] = test.test(new Checker(1000, td));
            }
        }
        catch (InterruptedException e1) {
            Assert.fail((String)"Unexpected interruption", (Throwable)e1);
        }
        Utils.handleResults(iterations, results);
    }

    public static void log(String s) {
        System.out.println(Utils.tid() + " " + Utils.hms() + ": " + s);
    }

    private static String hms() {
        return DateTimeFormatter.ofPattern("HH:mm:ss:SS").format(LocalDateTime.now());
    }

    public static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Utils.log("woken" + e.getMessage());
        }
    }

    private Utils() {
    }
}

