/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.Utils;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadClassAsynchronous10Bean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadClassAsynchronous3Bean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadClassAsynchronousDefaultBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadClassAsynchronousQueueingBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadMethodAsynchronous10Bean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadMethodAsynchronous3Bean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadMethodAsynchronousDefaultBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadMethodAsynchronousQueueingBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadTestBackend;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Checker;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.TestData;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class BulkheadAsynchTest
extends Arquillian {
    @Inject
    private BulkheadClassAsynchronousDefaultBean bhBeanClassAsynchronousDefault;
    @Inject
    private BulkheadMethodAsynchronousDefaultBean bhBeanMethodAsynchronousDefault;
    @Inject
    private BulkheadClassAsynchronous3Bean bhBeanClassAsynchronous3;
    @Inject
    private BulkheadMethodAsynchronous3Bean bhBeanMethodAsynchronous3;
    @Inject
    private BulkheadClassAsynchronous10Bean bhBeanClassAsynchronous10;
    @Inject
    private BulkheadMethodAsynchronous10Bean bhBeanMethodAsynchronous10;
    @Inject
    private BulkheadClassAsynchronousQueueingBean bhBeanClassAsynchronousQueueing;
    @Inject
    private BulkheadMethodAsynchronousQueueingBean bhBeanMethodAsynchronousQueueing;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftBulkheadAsynchTest.jar")).addPackage(BulkheadClassAsynchronousDefaultBean.class.getPackage())).addClass(Utils.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftBulkheadAsynchTest.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @BeforeTest
    public void beforeTest(ITestContext testContext) {
        Utils.log("Testmethod: " + testContext.getName());
    }

    @Test
    public void testBulkheadClassAsynchronous10() {
        TestData td = new TestData(new CountDownLatch(10));
        this.loop(10, this.bhBeanClassAsynchronous10, 10, td);
        td.check();
    }

    @Test
    public void testBulkheadMethodAsynchronous10() {
        TestData td = new TestData(new CountDownLatch(10));
        this.loop(10, this.bhBeanMethodAsynchronous10, 10, td);
        td.check();
    }

    @Test
    public void testBulkheadClassAsynchronous3() {
        TestData td = new TestData(new CountDownLatch(10));
        this.loop(10, this.bhBeanClassAsynchronous3, 3, td);
        td.check();
    }

    @Test
    public void testBulkheadMethodAsynchronous3() {
        TestData td = new TestData(new CountDownLatch(10));
        this.loop(10, this.bhBeanMethodAsynchronous3, 3, td);
        td.check();
    }

    @Test
    public void testBulkheadClassAsynchronousDefault() {
        TestData td = new TestData(new CountDownLatch(10));
        this.loop(10, this.bhBeanClassAsynchronousDefault, 10, td);
        td.check();
    }

    @Test
    public void testBulkheadMethodAsynchronousDefault() {
        TestData td = new TestData(new CountDownLatch(10));
        this.loop(10, this.bhBeanMethodAsynchronousDefault, 10, td);
        td.check();
    }

    @Test
    public void testBulkheadClassAsynchronousQueueing10() {
        TestData td = new TestData(new CountDownLatch(20));
        this.loop(20, this.bhBeanClassAsynchronousQueueing, 10, 20, td);
        td.check();
    }

    @Test
    public void testBulkheadMethodAsynchronousQueueing10() {
        TestData td = new TestData(new CountDownLatch(20));
        this.loop(20, this.bhBeanMethodAsynchronousQueueing, 10, 20, td);
        td.check();
    }

    private void loop(int loops, BulkheadTestBackend test, int maxSimultaneousWorkers, TestData td) {
        td.setExpectedMaxSimultaneousWorkers(maxSimultaneousWorkers);
        td.setExpectedInstances(loops);
        td.setExpectedTasksScheduled(loops);
        Future[] results = new Future[loops];
        for (int i = 0; i < loops; ++i) {
            Utils.log("synchronous loop() starting test " + i);
            try {
                results[i] = test.test(new Checker(5000, td));
                continue;
            }
            catch (InterruptedException e1) {
                Assert.fail((String)"Unexpected interruption", (Throwable)e1);
            }
        }
        Utils.handleResults(loops, results);
    }

    private void loop(int number, BulkheadTestBackend test, int maxSimultaneousWorkers, int expectedTasksScheduled, TestData td) {
        td.setExpectedTasksScheduled(expectedTasksScheduled);
        this.loop(number, test, maxSimultaneousWorkers, td);
    }
}

