/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.clientserver.CircuitBreakerClassLevelClientWithDelay;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.clientserver.CircuitBreakerClientDefaultSuccessThreshold;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.clientserver.CircuitBreakerClientHigherSuccessThreshold;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.clientserver.CircuitBreakerClientNoDelay;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.clientserver.CircuitBreakerClientWithDelay;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CircuitBreakerTest
extends Arquillian {
    @Inject
    private CircuitBreakerClientWithDelay clientForCBWithDelay;
    @Inject
    private CircuitBreakerClassLevelClientWithDelay clientForClassLevelCBWithDelay;
    @Inject
    private CircuitBreakerClientNoDelay clientForCBNoDelay;
    @Inject
    private CircuitBreakerClientDefaultSuccessThreshold clientForCBDefaultSuccess;
    @Inject
    private CircuitBreakerClientHigherSuccessThreshold clientForCBHighSuccess;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftCircuitBreaker.jar")).addClasses(new Class[]{CircuitBreakerClientWithDelay.class, CircuitBreakerClientNoDelay.class, CircuitBreakerClassLevelClientWithDelay.class, CircuitBreakerClientDefaultSuccessThreshold.class, CircuitBreakerClientHigherSuccessThreshold.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftCircuitBreaker.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testCircuitClosedThenOpen() {
        for (int i = 0; i < 7; ++i) {
            try {
                this.clientForCBWithDelay.serviceA();
                if (i >= 4) continue;
                Assert.fail((String)("serviceA should throw an Exception in testCircuitClosedThenOpen on iteration " + i));
                continue;
            }
            catch (CircuitBreakerOpenException cboe) {
                if (i >= 4) continue;
                Assert.fail((String)("serviceA should throw a RuntimeException in testCircuitClosedThenOpen on iteration " + i));
                continue;
            }
            catch (RuntimeException cboe) {
                continue;
            }
            catch (Exception ex) {
                Assert.fail((String)("serviceA should throw a RuntimeException or CircuitBreakerOpenException in testCircuitClosedThenOpen on iteration " + i));
            }
        }
        int serviceAExecutions = this.clientForCBWithDelay.getCounterForInvokingServiceA();
        Assert.assertEquals((int)serviceAExecutions, (int)4, (String)"The number of executions should be 4");
    }

    @Test
    public void testCircuitReClose() {
        for (int i = 0; i < 7; ++i) {
            try {
                if (i == 4) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this.clientForCBNoDelay.serviceA();
                if (i >= 4) continue;
                Assert.fail((String)("serviceA should throw an Exception in testCircuitReClose on iteration " + i));
                continue;
            }
            catch (CircuitBreakerOpenException cboe) {
                Assert.fail((String)("serviceA should throw a RuntimeException in testCircuitReClose on iteration " + i));
                continue;
            }
            catch (RuntimeException cboe) {
                continue;
            }
            catch (Exception ex) {
                Assert.fail((String)("serviceA should succeed or throw a RuntimeException in testCircuitReClose on iteration " + i));
            }
        }
        int serviceAExecutions = this.clientForCBNoDelay.getCounterForInvokingServiceA();
        Assert.assertEquals((int)serviceAExecutions, (int)7, (String)"The number of executions should be 7");
    }

    @Test
    public void testCircuitDefaultSuccessThreshold() {
        for (int i = 1; i < 12; ++i) {
            try {
                this.clientForCBDefaultSuccess.serviceA();
                if (i >= 5 && (i <= 6 || i >= 12)) continue;
                Assert.fail((String)("serviceA should throw an Exception in testCircuitDefaultSuccessThreshold on iteration " + i));
                continue;
            }
            catch (CircuitBreakerOpenException cboe) {
                if (i < 5) {
                    Assert.fail((String)("serviceA should throw a RuntimeException in testCircuitDefaultSuccessThreshold on iteration " + i));
                    continue;
                }
                if (i != 5) continue;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            catch (RuntimeException cboe) {
                continue;
            }
            catch (Exception ex) {
                Assert.fail((String)("serviceA should throw a RuntimeException or CircuitBreakerOpenException in testCircuitDefaultSuccessThreshold on iteration " + i));
            }
        }
        int serviceAExecutions = this.clientForCBDefaultSuccess.getCounterForInvokingServiceA();
        Assert.assertEquals((int)serviceAExecutions, (int)9, (String)"The number of serviceA executions should be 9");
    }

    @Test
    public void testCircuitHighSuccessThreshold() {
        for (int i = 1; i < 10; ++i) {
            try {
                this.clientForCBHighSuccess.serviceA();
                if (i >= 5 && i <= 7) continue;
                Assert.fail((String)("serviceA should throw an Exception in testCircuitHighSuccessThreshold on iteration " + i));
                continue;
            }
            catch (CircuitBreakerOpenException cboe) {
                if (i < 5) {
                    Assert.fail((String)("serviceA should throw a RuntimeException in testCircuitHighSuccessThreshold on iteration " + i));
                    continue;
                }
                if (i != 5) continue;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            catch (RuntimeException cboe) {
                continue;
            }
            catch (Exception ex) {
                Assert.fail((String)("serviceA should throw a RuntimeException or CircuitBreakerOpenException in testCircuitHighSuccessThreshold on iteration " + i));
            }
        }
        int serviceAExecutions = this.clientForCBHighSuccess.getCounterForInvokingServiceA();
        Assert.assertEquals((int)serviceAExecutions, (int)7, (String)"The number of serviceA executions should be 7");
    }

    @Test
    public void testClassLevelCircuitBase() {
        for (int i = 0; i < 7; ++i) {
            try {
                this.clientForClassLevelCBWithDelay.serviceA();
                if (i >= 4) continue;
                Assert.fail((String)"serviceA should throw an Exception in testClassLevelCircuitBase");
                continue;
            }
            catch (CircuitBreakerOpenException cboe) {
                if (i >= 4) continue;
                Assert.fail((String)("serviceA should throw a RuntimeException in testClassLevelCircuitBase on iteration " + i));
                continue;
            }
            catch (RuntimeException cboe) {
                continue;
            }
            catch (Exception ex) {
                Assert.fail((String)("serviceA should throw a RuntimeException or CircuitBreakerOpenException in testClassLevelCircuitBase on iteration " + i));
            }
        }
        int serviceAExecutions = this.clientForClassLevelCBWithDelay.getCounterForInvokingService();
        Assert.assertEquals((int)serviceAExecutions, (int)4, (String)"The number of executions should be 4");
    }

    @Test
    public void testClassLevelCircuitOverride() {
        for (int i = 0; i < 7; ++i) {
            try {
                this.clientForClassLevelCBWithDelay.serviceC();
                if (i >= 2) continue;
                Assert.fail((String)("serviceC should throw an Exception in testClassLevelCircuitOverride on iteration " + i));
                continue;
            }
            catch (CircuitBreakerOpenException cboe) {
                if (i >= 2) continue;
                Assert.fail((String)("serviceC should throw a RuntimeException in testClassLevelCircuitOverride on iteration " + i));
                continue;
            }
            catch (RuntimeException cboe) {
                continue;
            }
            catch (Exception ex) {
                Assert.fail((String)("serviceC should throw a RuntimeException or CircuitBreakerOpenException in testClassLevelCircuitOverride on iteration " + i));
            }
        }
        int serviceAExecutions = this.clientForClassLevelCBWithDelay.getCounterForInvokingService();
        Assert.assertEquals((int)serviceAExecutions, (int)2, (String)"The number of executions should be 2");
    }

    @Test
    public void testClassLevelCircuitOverrideNoDelay() {
        for (int i = 0; i < 7; ++i) {
            try {
                if (i == 4) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this.clientForClassLevelCBWithDelay.serviceD();
                if (i >= 4) continue;
                Assert.fail((String)("serviceA should throw an Exception in testClassLevelCircuitOverrideNoDelay on iteration " + i));
                continue;
            }
            catch (CircuitBreakerOpenException cboe) {
                Assert.fail((String)("serviceD should throw a RuntimeException in testClassLevelCircuitOverrideNoDelay on iteration " + i));
                continue;
            }
            catch (RuntimeException cboe) {
                continue;
            }
            catch (Exception ex) {
                Assert.fail((String)("serviceD should succeed or throw a RuntimeException in testClassLevelCircuitOverrideNoDelay on iteration " + i));
            }
        }
        int serviceAExecutions = this.clientForClassLevelCBWithDelay.getCounterForInvokingService();
        Assert.assertEquals((int)serviceAExecutions, (int)7, (String)"The number of executions should be 7");
    }
}

