/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.context.tck;

import java.io.CharConversionException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Phaser;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.tck.contexts.buffer.Buffer;
import org.eclipse.microprofile.context.tck.contexts.buffer.spi.BufferContextProvider;
import org.eclipse.microprofile.context.tck.contexts.label.Label;
import org.eclipse.microprofile.context.tck.contexts.label.spi.LabelContextProvider;
import org.eclipse.microprofile.context.tck.contexts.priority.spi.ThreadPriorityContextProvider;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.ITestResult;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ManagedExecutorTest
extends Arquillian {
    private static final long MAX_WAIT_NS = TimeUnit.MINUTES.toNanos(2L);
    private ExecutorService unmanagedThreads;

    @AfterClass
    public void after() {
        this.unmanagedThreads.shutdownNow();
    }

    @AfterMethod
    public void afterMethod(Method m, ITestResult result) {
        System.out.println("<<< END " + m.getClass().getSimpleName() + '.' + m.getName() + (result.isSuccess() ? " SUCCESS" : " FAILED"));
        Throwable failure = result.getThrowable();
        if (failure != null) {
            failure.printStackTrace(System.out);
        }
    }

    @BeforeClass
    public void before() {
        this.unmanagedThreads = Executors.newFixedThreadPool(5);
    }

    @BeforeMethod
    public void beforeMethod(Method m) {
        System.out.println(">>> BEGIN " + m.getClass().getSimpleName() + '.' + m.getName());
    }

    @Deployment
    public static WebArchive createDeployment() {
        JavaArchive fakeContextProviders = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"fakeContextTypes.jar")).addPackages(true, new String[]{"org.eclipse.microprofile.context.tck.contexts.buffer"})).addPackages(true, new String[]{"org.eclipse.microprofile.context.tck.contexts.label"})).addPackage("org.eclipse.microprofile.context.tck.contexts.priority.spi")).addAsServiceProvider(ThreadContextProvider.class, new Class[]{BufferContextProvider.class, LabelContextProvider.class, ThreadPriorityContextProvider.class});
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(ManagedExecutorTest.class.getSimpleName() + ".war"))).addClass(ManagedExecutorTest.class)).addAsLibraries(new Archive[]{fakeContextProviders});
    }

    @Test
    public void builderForManagedExecutorIsProvided() {
        Assert.assertNotNull((Object)ManagedExecutor.builder(), (String)"MicroProfile Context Propagation implementation does not provide a ManagedExecutor builder.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void clearUnspecifiedContexts() throws InterruptedException, ExecutionException, TimeoutException {
        ManagedExecutor executor = ManagedExecutor.builder().propagated(new String[]{"Buffer"}).build();
        int originalPriority = Thread.currentThread().getPriority();
        try {
            int newPriority = originalPriority == 3 ? 2 : 3;
            Thread.currentThread().setPriority(newPriority);
            Buffer.set(new StringBuffer("clearUnspecifiedContexts-test-buffer-A"));
            CompletionStage future = executor.completedFuture((Object)1).thenRun(() -> {
                Assert.assertEquals((String)Buffer.get().toString(), (String)"clearUnspecifiedContexts-test-buffer-A", (String)"Context type was not propagated to contextual action.");
                Buffer.set(new StringBuffer("clearUnspecifiedContexts-test-buffer-B"));
                Assert.assertEquals((int)Thread.currentThread().getPriority(), (int)5, (String)"Context type that remained unspecified was not cleared by default.");
            });
            Assert.assertNull(future.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (String)"Non-null value returned by stage that runs Runnable.");
            Assert.assertEquals((String)Buffer.get().toString(), (String)"clearUnspecifiedContexts-test-buffer-A", (String)"Previous context (Buffer) was not restored after context was propagated for contextual action.");
        }
        finally {
            executor.shutdownNow();
            Buffer.set(null);
            Thread.currentThread().setPriority(originalPriority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void completedFutureDependentStagesRunWithContext() throws ExecutionException, InterruptedException, TimeoutException {
        ManagedExecutor executor = ManagedExecutor.builder().propagated(new String[]{"Buffer"}).cleared(new String[]{"Remaining"}).build();
        try {
            Buffer.set(new StringBuffer("completedFuture-test-buffer-A"));
            Label.set("completedFuture-test-label");
            CompletableFuture stage1a = executor.completedFuture((Object)1000L);
            Assert.assertTrue((boolean)stage1a.isDone(), (String)"Future created by completedFuture is not complete.");
            Assert.assertFalse((boolean)stage1a.isCompletedExceptionally(), (String)"Future created by completedFuture reports exceptional completion.");
            Assert.assertEquals((Object)stage1a.getNow(1234L), (Object)1000L, (String)"Future created by completedFuture has result that differs from what was specified.");
            CompletableFuture<Long> stage1b = new CompletableFuture<Long>();
            Buffer.set(new StringBuffer("completedFuture-test-buffer-B"));
            CompletionStage stage2 = stage1a.thenCombine(stage1b, (a, b) -> {
                Assert.assertEquals((Object)a, (Object)1000L, (String)"First value supplied to BiFunction was lost or altered.");
                Assert.assertEquals((Object)b, (Object)3L, (String)"Second value supplied to BiFunction was lost or altered.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"completedFuture-test-buffer-B", (String)"Context type was not propagated to contextual action.");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                return a * b;
            });
            Buffer.set(new StringBuffer("completedFuture-test-buffer-C"));
            CompletionStage stage3 = ((CompletableFuture)stage2).thenApply(i -> {
                Assert.assertEquals((Object)i, (Object)3000L, (String)"Value supplied to third stage was lost or altered.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"completedFuture-test-buffer-C", (String)"Context type was not propagated to contextual action.");
                Buffer.set(new StringBuffer("completedFuture-test-buffer-D"));
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                return i - 300L;
            });
            Buffer.set(new StringBuffer("completedFuture-test-buffer-E"));
            stage1b.complete(3L);
            Assert.assertEquals(((CompletableFuture)stage3).get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (Object)2700L, (String)"Unexpected result for stage 3.");
            Assert.assertEquals((Object)((CompletableFuture)stage2).getNow(3333L), (Object)3000L, (String)"Unexpected or missing result for stage 2.");
            Assert.assertTrue((boolean)((CompletableFuture)stage2).isDone(), (String)"Second stage did not transition to done upon completion.");
            Assert.assertTrue((boolean)((CompletableFuture)stage3).isDone(), (String)"Third stage did not transition to done upon completion.");
            Assert.assertFalse((boolean)((CompletableFuture)stage2).isCompletedExceptionally(), (String)"Second stage should not report exceptional completion.");
            Assert.assertFalse((boolean)((CompletableFuture)stage3).isCompletedExceptionally(), (String)"Third stage should not report exceptional completion.");
            Assert.assertEquals((String)Buffer.get().toString(), (String)"completedFuture-test-buffer-E", (String)"Previous context was not restored after context was cleared for managed executor tasks.");
            Assert.assertEquals((String)Label.get(), (String)"completedFuture-test-label", (String)"Previous context was not restored after context was propagated for managed executor tasks.");
        }
        finally {
            executor.shutdownNow();
            Buffer.set(null);
            Label.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void completedStageDependentStagesRunWithContext() throws InterruptedException {
        ManagedExecutor executor = ManagedExecutor.builder().propagated(new String[]{"Label"}).cleared(new String[]{"Remaining"}).build();
        try {
            Buffer.set(new StringBuffer("completedStage-test-buffer"));
            Label.set("completedStage-test-label-A");
            CompletionStage stage1 = executor.completedStage((Object)"5A");
            CompletableFuture<Integer> stage2 = new CompletableFuture<Integer>();
            Label.set("completedStage-test-label-B");
            CompletionStage<Integer> stage3 = stage1.thenCompose(s -> {
                Assert.assertEquals((String)s, (String)"5A", (String)"Value supplied to compose function was lost or altered.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Assert.assertEquals((String)Label.get(), (String)"completedStage-test-label-B", (String)"Context type was not propagated to contextual action.");
                return stage2.thenApply(i -> i + Integer.parseInt(s, 16));
            });
            Label.set("completedStage-test-label-C");
            CompletionStage<Integer> stage4 = stage3.applyToEither(new CompletableFuture(), i -> {
                Assert.assertEquals((Object)i, (Object)99, (String)"Value supplied to function was lost or altered.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Assert.assertEquals((String)Label.get(), (String)"completedStage-test-label-C", (String)"Context type was not propagated to contextual action.");
                return i + 1;
            });
            Label.set("completedStage-test-label-D");
            CountDownLatch completed = new CountDownLatch(1);
            AtomicInteger resultRef = new AtomicInteger();
            stage4.whenComplete((result, failure) -> {
                resultRef.set((int)result);
                completed.countDown();
            });
            stage2.complete(9);
            Assert.assertTrue((boolean)completed.await(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (String)"Completion stage did not finish in a reasonable amount of time.");
            Assert.assertEquals((int)resultRef.get(), (int)100, (String)"Unexpected result for stage 4.");
            Assert.assertEquals((String)Buffer.get().toString(), (String)"completedStage-test-buffer", (String)"Previous context was not restored after context was cleared for managed executor tasks.");
            Assert.assertEquals((String)Label.get(), (String)"completedStage-test-label-D", (String)"Previous context was not restored after context was propagated for managed executor tasks.");
        }
        finally {
            executor.shutdownNow();
            Buffer.set(null);
            Label.set(null);
        }
    }

    @Test
    public void contextControlsForManagedExecutorBuilder() throws InterruptedException, ExecutionException, TimeoutException {
        ManagedExecutor executor = ManagedExecutor.builder().propagated(new String[]{"Buffer"}).cleared(new String[]{"Label"}).maxAsync(-1).maxQueued(-1).build();
        try {
            ManagedExecutor.builder().propagated(new String[]{"Buffer"}).cleared(new String[]{"Label", "Buffer"}).maxAsync(-1).maxQueued(-1).build();
            Assert.fail((String)"ManagedExecutor.Builder.build() should throw an IllegalStateException for set overlap between propagated and cleared");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            ManagedExecutor.builder().propagated(new String[]{"Buffer", "BOGUS_CONTEXT"}).cleared(new String[]{"Label"}).maxAsync(-1).maxQueued(-1).build();
            Assert.fail((String)"ManagedExecutor.Builder.build() should throw an IllegalStateException for a nonexistent thread context type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            Buffer.get().append("contextControls-test-buffer-A");
            Label.set("contextControls-test-label-A");
            Future future = executor.submit(() -> {
                Assert.assertEquals((String)Buffer.get().toString(), (String)"contextControls-test-buffer-A", (String)"Context type was not propagated to contextual action.");
                Buffer.get().append("-B");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Label.set("contextControls-test-label-B");
                return null;
            });
            Assert.assertNull(future.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (String)"Unexpected result of task.");
            Assert.assertEquals((String)Buffer.get().toString(), (String)"contextControls-test-buffer-A-B", (String)"Context type was not propagated to contextual action.");
            Assert.assertEquals((String)Label.get(), (String)"contextControls-test-label-A", (String)"Context type was not left unchanged by contextual action.");
        }
        finally {
            executor.shutdownNow();
            Buffer.set(null);
            Label.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void contextOfContextualCallableOverridesContextOfManagedExecutor() throws ExecutionException, InterruptedException, TimeoutException {
        ThreadContext bufferContext = ThreadContext.builder().propagated(new String[]{"Buffer"}).unchanged(new String[0]).cleared(new String[]{"Remaining"}).build();
        ManagedExecutor executor = ManagedExecutor.builder().propagated(new String[]{"Label"}).cleared(new String[]{"Remaining"}).build();
        try {
            Callable<String> getBuffer = () -> {
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type not cleared from thread.");
                return Buffer.get().toString();
            };
            Callable<String> getLabel = () -> {
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type not cleared from thread.");
                return Label.get();
            };
            Buffer.set(new StringBuffer("contextualCallableOverride-buffer-1"));
            Label.set("contextualCallableOverride-label-1");
            Callable precontextualizedTask1 = bufferContext.contextualCallable(getBuffer);
            Buffer.set(new StringBuffer("contextualCallableOverride-buffer-2"));
            Label.set("contextualCallableOverride-label-2");
            Callable precontextualizedTask2 = bufferContext.contextualCallable(getBuffer);
            Buffer.set(new StringBuffer("contextualCallableOverride-buffer-3"));
            Label.set("contextualCallableOverride-label-3");
            Future future = executor.submit(precontextualizedTask1);
            Assert.assertEquals((String)((String)future.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS)), (String)"contextualCallableOverride-buffer-1", (String)"Previously captured context type not found on thread.");
            List futures = executor.invokeAll(Arrays.asList(precontextualizedTask2, getLabel, precontextualizedTask1, precontextualizedTask2), MAX_WAIT_NS, TimeUnit.NANOSECONDS);
            future = (Future)futures.get(0);
            Assert.assertEquals((String)((String)future.get()), (String)"contextualCallableOverride-buffer-2", (String)"Previously captured context type not found on thread.");
            future = (Future)futures.get(1);
            Assert.assertEquals((String)((String)future.get()), (String)"contextualCallableOverride-label-3", (String)"Context type captured by managed executor not found on thread.");
            future = (Future)futures.get(2);
            Assert.assertEquals((String)((String)future.get()), (String)"contextualCallableOverride-buffer-1", (String)"Previously captured context type not found on thread.");
            future = (Future)futures.get(3);
            Assert.assertEquals((String)((String)future.get()), (String)"contextualCallableOverride-buffer-2", (String)"Previously captured context type not found on thread.");
            String result = (String)executor.invokeAny(Arrays.asList(precontextualizedTask1, precontextualizedTask1), MAX_WAIT_NS, TimeUnit.NANOSECONDS);
            Assert.assertEquals((String)result, (String)"contextualCallableOverride-buffer-1", (String)"Previously captured context type not found on thread.");
        }
        finally {
            executor.shutdownNow();
            Buffer.set(null);
            Label.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void contextOfContextualConsumerAndBiFunctionOverrideContextOfManagedExecutor() throws ExecutionException, InterruptedException, TimeoutException {
        ThreadContext labelContext = ThreadContext.builder().propagated(new String[]{"Label"}).unchanged(new String[0]).cleared(new String[]{"Remaining"}).build();
        ManagedExecutor executor = ManagedExecutor.builder().propagated(new String[]{"Buffer"}).cleared(new String[]{"Remaining"}).build();
        try {
            Buffer.set(new StringBuffer("contextualBiFunctionOverride-buffer-1"));
            Label.set("contextualBiFunctionOverride-label-1");
            BiFunction precontextualizedFunction1 = labelContext.contextualFunction((result, failure) -> {
                Assert.assertEquals((String)Label.get(), (String)"contextualBiFunctionOverride-label-1", (String)"Previously captured context type not found on thread.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type not cleared from thread.");
                return failure == null ? result : 100;
            });
            Buffer.set(new StringBuffer("contextualBiFunctionOverride-buffer-2"));
            Label.set("contextualBiFunctionOverride-label-2");
            BiFunction precontextualizedFunction2 = labelContext.contextualFunction((i, j) -> {
                Assert.assertEquals((String)Label.get(), (String)"contextualBiFunctionOverride-label-2", (String)"Previously captured context type not found on thread.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type not cleared from thread.");
                return i - j;
            });
            Buffer.set(new StringBuffer("contextualConsumerOverride-buffer-3"));
            Label.set("contextualConsumerOverride-label-3");
            Consumer precontextualizedConsumer3 = labelContext.contextualConsumer(i -> {
                Assert.assertEquals((String)Label.get(), (String)"contextualConsumerOverride-label-3", (String)"Previously captured context type not found on thread.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type not cleared from thread.");
            });
            Buffer.set(new StringBuffer("contextualConsuemrOverride-buffer-4"));
            Label.set("contextualConsumerOverride-label-4");
            Consumer precontextualizedConsumer4 = labelContext.contextualConsumer(i -> {
                Assert.assertEquals((String)Label.get(), (String)"contextualConsumerOverride-label-4", (String)"Previously captured context type not found on thread.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type not cleared from thread.");
            });
            BiFunction<Void, Void, String> normalFunction5 = (unused1, unused2) -> {
                Assert.assertEquals((String)Buffer.get().toString(), (String)"contextualConsumerAndBiFunctionOverride-buffer-5", (String)"Previously captured context type not found on thread.");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type not cleared from thread.");
                return "done";
            };
            Buffer.set(new StringBuffer("contextualConsumerAndBiFunctionOverride-buffer-5"));
            Label.set("contextualConsumerAndBiFunctionOverride-label-5");
            CompletableFuture stage0 = executor.failedFuture((Throwable)new ArrayIndexOutOfBoundsException("Expected error."));
            CompletionStage stage1 = stage0.handleAsync(precontextualizedFunction1);
            CompletionStage stage2 = executor.completedFuture((Object)200).thenCombineAsync(stage1, precontextualizedFunction2);
            CompletionStage stage3 = ((CompletableFuture)stage2).thenAccept(precontextualizedConsumer3);
            CompletionStage stage4 = ((CompletableFuture)stage2).acceptEitherAsync(stage1, precontextualizedConsumer4);
            CompletionStage stage5 = ((CompletableFuture)stage4).thenCombine(stage3, normalFunction5);
            Assert.assertEquals((String)((String)((CompletableFuture)stage5).join()), (String)"done", (String)"Unexpected result for completion stage.");
        }
        finally {
            executor.shutdownNow();
            Buffer.set(null);
            Label.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void contextOfContextualFunctionOverridesContextOfManagedExecutor() throws ExecutionException, InterruptedException, TimeoutException {
        ThreadContext labelContext = ThreadContext.builder().propagated(new String[]{"Label"}).unchanged(new String[0]).cleared(new String[]{"Remaining"}).build();
        ManagedExecutor executor = ManagedExecutor.builder().propagated(new String[]{"Buffer"}).cleared(new String[]{"Remaining"}).build();
        try {
            Buffer.set(new StringBuffer("contextualFunctionOverride-buffer-1"));
            Label.set("contextualFunctionOverride-label-1");
            Function precontextualizedFunction1 = labelContext.contextualFunction(i -> {
                Assert.assertEquals((String)Label.get(), (String)"contextualFunctionOverride-label-1", (String)"Previously captured context type not found on thread.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type not cleared from thread.");
                return i + 1;
            });
            Buffer.set(new StringBuffer("contextualFunctionOverride-buffer-2"));
            Label.set("contextualFunctionOverride-label-2");
            Function precontextualizedFunction2 = labelContext.contextualFunction(i -> {
                Assert.assertEquals((String)Label.get(), (String)"contextualFunctionOverride-label-2", (String)"Previously captured context type not found on thread.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type not cleared from thread.");
                return i + 20;
            });
            Function precontextualizedErrorHandler = labelContext.contextualFunction(failure -> {
                Assert.assertEquals((String)Label.get(), (String)"contextualFunctionOverride-label-2", (String)"Previously captured context type not found on thread.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type not cleared from thread.");
                return -1;
            });
            Buffer.set(new StringBuffer("contextualFunctionOverride-buffer-3"));
            Label.set("contextualFunctionOverride-label-3");
            Function<Integer, Integer> normalFunction = i -> {
                Assert.assertEquals((String)Buffer.get().toString(), (String)"contextualFunctionOverride-buffer-3", (String)"Previously captured context type not found on thread.");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type not cleared from thread.");
                return i + 300;
            };
            CompletableFuture stage0 = executor.newIncompleteFuture();
            CompletionStage stage1 = stage0.thenApplyAsync(precontextualizedFunction1);
            Buffer.set(new StringBuffer("contextualFunctionOverride-buffer-4"));
            Label.set("contextualFunctionOverride-label-4");
            Function precontextualizedFunction4 = labelContext.contextualFunction(arg_0 -> ManagedExecutorTest.lambda$contextOfContextualFunctionOverridesContextOfManagedExecutor$19((CompletableFuture)stage1, arg_0));
            Buffer.set(new StringBuffer("contextualFunctionOverride-buffer-3"));
            Label.set("contextualFunctionOverride-label-3");
            CompletionStage stage2 = stage0.thenComposeAsync(precontextualizedFunction4);
            CompletionStage stage3 = ((CompletableFuture)stage2).applyToEither(stage1, precontextualizedFunction2);
            CompletionStage stage4 = ((CompletableFuture)stage3).thenApply(normalFunction);
            CompletionStage stage5 = ((CompletableFuture)((CompletableFuture)stage4).thenApply(i -> i / (i - 321))).exceptionally(precontextualizedErrorHandler);
            stage0.complete(0);
            Assert.assertEquals(((CompletableFuture)stage2).join(), (Object)1, (String)"Unexpected result for completion stage.");
            Assert.assertEquals(((CompletableFuture)stage5).join(), (Object)-1, (String)"Unexpected result for completion stage.");
        }
        finally {
            executor.shutdownNow();
            Buffer.set(null);
            Label.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void contextOfContextualRunnableOverridesContextOfManagedExecutor() throws ExecutionException, InterruptedException, TimeoutException {
        ThreadContext labelContext = ThreadContext.builder().propagated(new String[]{"Label"}).unchanged(new String[0]).cleared(new String[]{"Remaining"}).build();
        ManagedExecutor executor = ManagedExecutor.builder().propagated(new String[]{"Buffer"}).cleared(new String[]{"Remaining"}).build();
        try {
            Buffer.set(new StringBuffer("contextualRunnableOverride-buffer-1"));
            Label.set("contextualRunnableOverride-label-1");
            Runnable precontextualizedTask1 = labelContext.contextualRunnable(() -> {
                Assert.assertEquals((String)Label.get(), (String)"contextualRunnableOverride-label-1", (String)"Previously captured context type not found on thread.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type not cleared from thread.");
            });
            Buffer.set(new StringBuffer("contextualRunnableOverride-buffer-2"));
            Label.set("contextualRunnableOverride-label-2");
            Runnable precontextualizedTask2 = labelContext.contextualRunnable(() -> {
                Assert.assertEquals((String)Label.get(), (String)"contextualRunnableOverride-label-2", (String)"Previously captured context type not found on thread.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type not cleared from thread.");
            });
            Buffer.set(new StringBuffer("contextualRunnableOverride-buffer-3"));
            Label.set("contextualRunnableOverride-label-3");
            Runnable normalTask = () -> {
                Assert.assertEquals((String)Buffer.get().toString(), (String)"contextualRunnableOverride-buffer-3", (String)"Previously captured context type not found on thread.");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type not cleared from thread.");
            };
            Future future = executor.submit(precontextualizedTask1, (Object)1);
            Assert.assertEquals(future.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (Object)1, (String)"Unexpected result of task.");
            CompletableFuture stage0 = executor.runAsync(precontextualizedTask1);
            CompletionStage stage1 = stage0.thenRunAsync(precontextualizedTask1);
            CompletionStage stage2 = stage0.thenRun(precontextualizedTask2);
            CompletionStage stage3 = ((CompletableFuture)stage1).runAfterEither(stage2, precontextualizedTask2);
            CompletionStage stage4 = ((CompletableFuture)stage1).runAfterBothAsync(stage2, precontextualizedTask1);
            CompletionStage stage5 = ((CompletableFuture)stage4).runAfterBoth(stage3, normalTask);
            ((CompletableFuture)stage5).join();
            LinkedBlockingQueue results = new LinkedBlockingQueue();
            Runnable precontextualizedTask3 = labelContext.contextualRunnable(() -> results.add(Label.get()));
            Buffer.set(new StringBuffer("contextualRunnableOverride-buffer-4"));
            Label.set("contextualRunnableOverride-label-4");
            executor.execute(precontextualizedTask3);
            Assert.assertEquals((String)((String)results.poll(MAX_WAIT_NS, TimeUnit.NANOSECONDS)), (String)"contextualRunnableOverride-label-3", (String)"Previously captured context type not found on thread.");
        }
        finally {
            executor.shutdownNow();
            Buffer.set(null);
            Label.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void contextOfContextualSuppplierAndBiConsumerOverrideContextOfManagedExecutor() throws ExecutionException, InterruptedException, TimeoutException {
        ThreadContext bufferContext = ThreadContext.builder().propagated(new String[]{"Buffer"}).unchanged(new String[0]).cleared(new String[]{"Remaining"}).build();
        ManagedExecutor executor = ManagedExecutor.builder().propagated(new String[]{"Label"}).cleared(new String[]{"Remaining"}).build();
        try {
            Supplier<String> getBuffer = () -> {
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type not cleared from thread.");
                return Buffer.get().toString();
            };
            Buffer.set(new StringBuffer("contextualSupplierOverride-buffer-1"));
            Label.set("contextualSupplierOverride-label-1");
            Supplier precontextualizedSupplier1 = bufferContext.contextualSupplier(getBuffer);
            Buffer.set(new StringBuffer("contextualSupplierOverride-buffer-2"));
            Label.set("contextualSupplierOverride-label-2");
            Supplier precontextualizedSupplier2 = bufferContext.contextualSupplier(getBuffer);
            Buffer.set(new StringBuffer("contextualBiConsumerOverride-buffer-3"));
            Label.set("contextualBiConsumerOverride-label-3");
            BiConsumer precontextualizedConsumer3 = bufferContext.contextualConsumer((b1, b2) -> {
                Assert.assertEquals((String)Buffer.get().toString(), (String)"contextualBiConsumerOverride-buffer-3", (String)"Previously captured context type not found on thread.");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type not cleared from thread.");
                Assert.assertEquals((String)b1, (String)"contextualSupplierOverride-buffer-1", (String)"Previously captured context type not found on Supplier's thread.");
                Assert.assertEquals((String)b2, (String)"contextualSupplierOverride-buffer-2", (String)"Previously captured context type not found on Supplier's thread.");
            });
            Buffer.set(new StringBuffer("contextualBiConsumerOverride-buffer-4"));
            Label.set("contextualBiConsumerOverride-label-4");
            BiConsumer precontextualizedConsumer4 = bufferContext.contextualConsumer((unused, failure) -> {
                Assert.assertEquals((String)Buffer.get().toString(), (String)"contextualBiConsumerOverride-buffer-4", (String)"Previously captured context type not found on thread.");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type not cleared from thread.");
            });
            Buffer.set(new StringBuffer("contextualSupplierAndBiConsumerOverride-buffer-5"));
            Label.set("contextualSupplierAndBiConsumerOverride-label-5");
            CompletableFuture stage1 = executor.supplyAsync(precontextualizedSupplier1);
            CompletableFuture stage2 = executor.supplyAsync(precontextualizedSupplier2);
            CompletionStage stage3 = stage1.thenAcceptBoth((CompletionStage)stage2, precontextualizedConsumer3);
            CompletionStage stage4 = ((CompletableFuture)stage3).whenCompleteAsync(precontextualizedConsumer4);
            CompletionStage stage5 = ((CompletableFuture)stage4).whenComplete((unused, failure) -> {
                Assert.assertEquals((String)Label.get(), (String)"contextualSupplierAndBiConsumerOverride-label-5", (String)"Context type captured by managed executor not found on thread.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type not cleared from thread.");
            });
            ((CompletableFuture)stage5).join();
        }
        finally {
            executor.shutdownNow();
            Buffer.set(null);
            Label.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void executedTaskRunsWithClearedContext() throws ExecutionException, InterruptedException, TimeoutException {
        ManagedExecutor executor = ManagedExecutor.builder().propagated(new String[0]).cleared(new String[]{"Remaining"}).build();
        try {
            Buffer.set(new StringBuffer("executed-task-test-buffer-A"));
            Label.set("executed-task-test-label-A");
            CompletableFuture<Integer> cf1 = new CompletableFuture<Integer>();
            CompletionStage cf2 = cf1.thenAcceptAsync(i -> {
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Label.set("executed-task-test-label-B");
            }, (Executor)executor);
            cf1.complete(1000);
            ((CompletableFuture)cf2).join();
            Assert.assertEquals((String)Buffer.get().toString(), (String)"executed-task-test-buffer-A", (String)"Context unexpectedly changed on thread.");
            Assert.assertEquals((String)Label.get(), (String)"executed-task-test-label-A", (String)"Context unexpectedly changed on thread.");
        }
        finally {
            executor.shutdownNow();
            Buffer.set(null);
            Label.set(null);
        }
    }

    @Test
    public void executedTaskRunsWithContext() throws ExecutionException, InterruptedException, TimeoutException {
        ManagedExecutor executor = ManagedExecutor.builder().propagated(new String[]{"Buffer", "Label"}).cleared(new String[]{"Remaining"}).build();
        try {
            Buffer.set(new StringBuffer("executed-task-test-buffer-C"));
            Label.set("executed-task-test-label-C");
            CompletableFuture result = new CompletableFuture();
            executor.execute(() -> {
                try {
                    Assert.assertEquals((String)Buffer.get().toString(), (String)"executed-task-test-buffer-C", (String)"Context type that is configured to be propagated was not propagated.");
                    Assert.assertEquals((String)Label.get(), (String)"executed-task-test-label-C", (String)"Context type that is configured to be propagated was not propagated.");
                    Label.set("executed-task-test-label-D");
                    result.complete("successful");
                }
                catch (Throwable x) {
                    result.completeExceptionally(x);
                }
            });
            result.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS);
            Assert.assertEquals((String)Buffer.get().toString(), (String)"executed-task-test-buffer-C", (String)"Context unexpectedly changed on thread.");
            Assert.assertEquals((String)Label.get(), (String)"executed-task-test-label-C", (String)"Context unexpectedly changed on thread.");
        }
        finally {
            executor.shutdownNow();
            Buffer.set(null);
            Label.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void failedFutureDependentStagesRunWithContext() throws ExecutionException, InterruptedException, TimeoutException {
        ManagedExecutor executor = ManagedExecutor.builder().propagated(new String[]{"Buffer"}).cleared(new String[]{"Remaining"}).build();
        try {
            CompletableFuture stage1;
            block5: {
                Buffer.set(new StringBuffer("failedFuture-test-buffer-1"));
                Label.set("failedFuture-test-label");
                stage1 = executor.failedFuture((Throwable)new CharConversionException("A fake exception created by the test"));
                Assert.assertTrue((boolean)stage1.isDone(), (String)"Future created by failedFuture is not complete.");
                Assert.assertTrue((boolean)stage1.isCompletedExceptionally(), (String)"Future created by failedFuture does not report exceptional completion.");
                try {
                    Character result = stage1.getNow(Character.valueOf('1'));
                    Assert.fail((String)("Failed future must raise exception. Instead, getNow returned: " + result));
                }
                catch (CompletionException x2) {
                    if (x2.getCause() != null && x2.getCause() instanceof CharConversionException && "A fake exception created by the test".equals(x2.getCause().getMessage())) break block5;
                    throw x2;
                }
            }
            Buffer.set(new StringBuffer("failedFuture-test-buffer-B"));
            CompletionStage stage2a = stage1.exceptionally(x -> {
                Assert.assertEquals(x.getClass(), CharConversionException.class, (String)"Wrong exception class supplied to 'exceptionally' method.");
                Assert.assertEquals((String)x.getMessage(), (String)"A fake exception created by the test", (String)"Exception message was lost or altered.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"failedFuture-test-buffer-B", (String)"Context type was not propagated to contextual action.");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                return Character.valueOf('A');
            });
            CompletableFuture<Character> stage2b = new CompletableFuture<Character>();
            Buffer.set(new StringBuffer("failedFuture-test-buffer-C"));
            AtomicBoolean stage3Runs = new AtomicBoolean();
            CompletionStage stage3 = ((CompletableFuture)stage2a).runAfterBoth(stage2b, () -> {
                stage3Runs.set(true);
                Assert.assertEquals((String)Buffer.get().toString(), (String)"failedFuture-test-buffer-C", (String)"Context type was not propagated to contextual action.");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
            });
            Buffer.set(new StringBuffer("failedFuture-test-buffer-D"));
            Assert.assertFalse((boolean)((CompletableFuture)stage3).isDone(), (String)"Third stage should not report done until both of the stages upon which it depends complete.");
            stage2b.complete(Character.valueOf('B'));
            Assert.assertNull(((CompletableFuture)stage3).get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (String)"Unexpected result for stage 3.");
            Assert.assertTrue((boolean)stage3Runs.get(), (String)"The Runnable for stage 3 did not run.");
            Assert.assertEquals((Object)((CompletableFuture)stage2a).getNow(Character.valueOf('F')), (Object)Character.valueOf('A'), (String)"Unexpected or missing result for stage 2.");
            Assert.assertTrue((boolean)((CompletableFuture)stage2a).isDone(), (String)"Second stage did not transition to done upon completion.");
            Assert.assertTrue((boolean)((CompletableFuture)stage3).isDone(), (String)"Third stage did not transition to done upon completion.");
            Assert.assertFalse((boolean)((CompletableFuture)stage2a).isCompletedExceptionally(), (String)"Second stage should not report exceptional completion.");
            Assert.assertFalse((boolean)((CompletableFuture)stage3).isCompletedExceptionally(), (String)"Third stage should not report exceptional completion.");
            Assert.assertEquals((String)Buffer.get().toString(), (String)"failedFuture-test-buffer-D", (String)"Previous context was not restored after context was cleared for managed executor tasks.");
            Assert.assertEquals((String)Label.get(), (String)"failedFuture-test-label", (String)"Previous context was not restored after context was propagated for managed executor tasks.");
        }
        finally {
            executor.shutdownNow();
            Buffer.set(null);
            Label.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void failedStageDependentStagesRunWithContext() throws ExecutionException, InterruptedException, TimeoutException {
        ManagedExecutor executor = ManagedExecutor.builder().propagated(new String[]{"Label"}).cleared(new String[]{"Remaining"}).build();
        try {
            block8: {
                CompletionStage<Integer> stage2;
                block7: {
                    Buffer.set(new StringBuffer("failedStage-test-buffer"));
                    Label.set("failedStage-test-label-A");
                    CompletionStage stage1 = executor.failedStage((Throwable)new LinkageError("Error intentionally raised by test case"));
                    Label.set("failedStage-test-label-B");
                    stage2 = stage1.whenComplete((result, failure) -> {
                        Assert.assertEquals(failure.getClass(), LinkageError.class, (String)"Wrong exception class supplied to 'whenComplete' method.");
                        Assert.assertEquals((String)failure.getMessage(), (String)"Error intentionally raised by test case", (String)"Error message was lost or altered.");
                        Assert.assertNull((Object)result, (String)"Non-null result supplied to whenComplete for failed stage.");
                        Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                        Assert.assertEquals((String)Label.get(), (String)"failedStage-test-label-B", (String)"Context type was not propagated to contextual action.");
                    });
                    Label.set("failedStage-test-label-C");
                    CompletableFuture future1 = stage1.toCompletableFuture();
                    try {
                        Integer result2 = (Integer)future1.join();
                        Assert.fail((String)("The join operation did not raise the error from the failed stage. Instead: " + result2));
                    }
                    catch (CompletionException x) {
                        if (x.getCause() != null && x.getCause() instanceof LinkageError && "Error intentionally raised by test case".equals(x.getCause().getMessage())) break block7;
                        throw x;
                    }
                }
                CompletableFuture<Integer> future2 = stage2.toCompletableFuture();
                try {
                    Integer result3 = future2.get();
                    Assert.fail((String)("The get operation did not raise the error from the failed stage. Instead: " + result3));
                }
                catch (ExecutionException x) {
                    if (x.getCause() != null && x.getCause() instanceof LinkageError && "Error intentionally raised by test case".equals(x.getCause().getMessage())) break block8;
                    throw x;
                }
            }
            Assert.assertEquals((String)Buffer.get().toString(), (String)"failedStage-test-buffer", (String)"Previous context was not restored after context was cleared for managed executor tasks.");
            Assert.assertEquals((String)Label.get(), (String)"failedStage-test-label-C", (String)"Previous context was not restored after context was propagated for managed executor tasks.");
        }
        finally {
            executor.shutdownNow();
            Buffer.set(null);
            Label.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void maxAsync2() throws ExecutionException, InterruptedException, TimeoutException {
        ManagedExecutor executor = ManagedExecutor.builder().maxAsync(2).propagated(new String[0]).cleared(new String[]{"Remaining"}).build();
        Phaser barrier = new Phaser(2);
        try {
            Future future1 = executor.submit(() -> barrier.awaitAdvance(barrier.arriveAndAwaitAdvance()));
            CompletableFuture future2 = executor.supplyAsync(() -> barrier.awaitAdvance(barrier.arriveAndAwaitAdvance()));
            barrier.awaitAdvanceInterruptibly(0, MAX_WAIT_NS, TimeUnit.NANOSECONDS);
            LinkedBlockingQueue results = new LinkedBlockingQueue();
            CompletableFuture future3 = executor.runAsync(() -> results.offer("Result3"));
            CompletableFuture future4 = executor.supplyAsync(() -> results.offer("Result4"));
            Future future5 = executor.submit(() -> results.offer("Result5"));
            CompletionStage future6 = executor.completedFuture((Object)"6").thenApplyAsync(s -> results.offer("Result" + s));
            Assert.assertNull(results.poll(5L, TimeUnit.SECONDS), (String)"Should not be able start more than 2 async tasks when maxAsync is 2.");
            barrier.arrive();
            barrier.arrive();
            Assert.assertNotNull(results.poll(MAX_WAIT_NS, TimeUnit.SECONDS), (String)"None of the queued tasks ran.");
            Assert.assertNotNull(results.poll(MAX_WAIT_NS, TimeUnit.SECONDS), (String)"Only 1 of the queued tasks ran.");
            Assert.assertNotNull(results.poll(MAX_WAIT_NS, TimeUnit.SECONDS), (String)"Only 2 of the queued tasks ran.");
            Assert.assertNotNull(results.poll(MAX_WAIT_NS, TimeUnit.SECONDS), (String)"Only 3 of the queued tasks ran.");
            Assert.assertEquals(future1.get(), (Object)2, (String)"Unexpected result of first task.");
            Assert.assertEquals(future2.get(), (Object)2, (String)"Unexpected result of second task.");
            Assert.assertNull(future3.join(), (String)"Unexpected result of third task.");
            Assert.assertEquals(future4.join(), (Object)Boolean.TRUE, (String)"Unexpected result of fourth task.");
            Assert.assertEquals(future5.get(), (Object)Boolean.TRUE, (String)"Unexpected result of fifth task.");
            Assert.assertEquals(((CompletableFuture)future6).get(), (Object)Boolean.TRUE, (String)"Unexpected result of sixth task.");
        }
        finally {
            barrier.forceTermination();
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void maxAsyncInvalidValues() throws ExecutionException, InterruptedException, TimeoutException {
        ManagedExecutor.Builder builder = ManagedExecutor.builder();
        builder.propagated(new String[]{"Remaining"});
        builder.cleared(new String[]{"Transaction"});
        try {
            builder.maxAsync(-10);
            Assert.fail((String)"ManagedExecutor builder permitted value of -10 for maxAsync.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            builder.maxAsync(-2);
            Assert.fail((String)"ManagedExecutor builder permitted value of -2 for maxAsync.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            builder.maxQueued(0);
            Assert.fail((String)"ManagedExecutor builder permitted value of 0 for maxAsync.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ManagedExecutor executor = builder.build();
        try {
            Future future = executor.submit(() -> "it worked!");
            Assert.assertEquals((String)((String)future.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS)), (String)"it worked!", (String)"Task had missing or unexpected result.");
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void maxQueued3() throws ExecutionException, InterruptedException, TimeoutException {
        ManagedExecutor executor = ManagedExecutor.builder().maxAsync(1).maxQueued(3).propagated(new String[0]).cleared(new String[]{"Remaining"}).build();
        Phaser barrier = new Phaser(1);
        try {
            executor.submit(() -> barrier.awaitAdvanceInterruptibly(barrier.arrive() + 1));
            barrier.awaitAdvanceInterruptibly(0, MAX_WAIT_NS, TimeUnit.NANOSECONDS);
            Future future1 = executor.submit(() -> 101);
            CompletableFuture future2 = executor.runAsync(() -> System.out.println("second task running"));
            Future future3 = executor.submit(() -> 103);
            try {
                Future future4 = executor.submit(() -> 104);
                Assert.fail((String)("Exceeded maxQueued of 3. Future for 4th queued task/action is " + future4));
            }
            catch (RejectedExecutionException future4) {
                // empty catch block
            }
            try {
                CompletableFuture future5 = executor.supplyAsync(() -> 105);
                Assert.fail((String)("Exceeded maxQueued of 3. Future for 5th queued task/action is " + future5));
            }
            catch (RejectedExecutionException future5) {
                // empty catch block
            }
            barrier.arrive();
            Assert.assertEquals(future1.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (Object)101, (String)"Unexpected result of first task.");
            Assert.assertNull(future2.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (String)"Unexpected result of second task.");
            Future future6 = executor.submit(() -> 106);
            CompletableFuture future7 = executor.supplyAsync(() -> 107);
            Assert.assertEquals(future3.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (Object)103, (String)"Unexpected result of third task.");
            Assert.assertEquals(future6.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (Object)106, (String)"Unexpected result of sixth task.");
            Assert.assertEquals(future7.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (Object)107, (String)"Unexpected result of seventh task.");
        }
        finally {
            barrier.forceTermination();
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void maxQueuedInvalidValues() throws ExecutionException, InterruptedException, TimeoutException {
        ManagedExecutor.Builder builder = ManagedExecutor.builder().propagated(new String[0]).cleared(new String[]{"Remaining"});
        try {
            builder.maxQueued(-2);
            Assert.fail((String)"ManagedExecutor builder permitted value of -2 for maxQueued.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            builder.maxQueued(0);
            Assert.fail((String)"ManagedExecutor builder permitted value of 0 for maxQueued.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ManagedExecutor executor = builder.build();
        try {
            Future future = executor.submit(() -> "successful!");
            Assert.assertEquals((String)((String)future.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS)), (String)"successful!", (String)"Task had missing or unexpected result.");
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void newIncompleteFutureDependentStagesRunWithContext() throws ExecutionException, InterruptedException {
        ManagedExecutor executor = ManagedExecutor.builder().propagated(new String[]{"Label"}).cleared(new String[]{"Remaining"}).build();
        try {
            CompletableFuture stage1 = executor.newIncompleteFuture();
            Assert.assertFalse((boolean)stage1.isDone(), (String)"Completable future created by newIncompleteFuture did not start out as incomplete.");
            Buffer.get().append("newIncompleteFuture-test-buffer");
            Label.set("newIncompleteFuture-test-label-A");
            CompletionStage stage2 = stage1.thenApply(i -> {
                Assert.assertEquals((Object)i, (Object)10, (String)"Value supplied to second stage was lost or altered.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Assert.assertEquals((String)Label.get(), (String)"newIncompleteFuture-test-label-A", (String)"Context type was not correctly propagated to contextual action.");
                return i * 2;
            });
            Label.set("newIncompleteFuture-test-label-B");
            CompletionStage stage3 = ((CompletableFuture)stage2).thenApply(i -> {
                Assert.assertEquals((Object)i, (Object)20, (String)"Value supplied to third stage was lost or altered.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Assert.assertEquals((String)Label.get(), (String)"newIncompleteFuture-test-label-B", (String)"Context type was not correctly propagated to contextual action.");
                return i + 10;
            });
            Label.set("newIncompleteFuture-test-label-C");
            CountDownLatch completed = new CountDownLatch(1);
            ((CompletableFuture)stage3).whenComplete((result, failure) -> completed.countDown());
            Assert.assertTrue((boolean)stage1.complete(10), (String)"Unable to complete the future that was created by newIncompleteFuture.");
            Assert.assertTrue((boolean)completed.await(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (String)"Completable future did not finish in a reasonable amount of time.");
            Assert.assertTrue((boolean)stage1.isDone(), (String)"First stage did not transition to done upon completion.");
            Assert.assertTrue((boolean)((CompletableFuture)stage2).isDone(), (String)"Second stage did not transition to done upon completion.");
            Assert.assertTrue((boolean)((CompletableFuture)stage3).isDone(), (String)"Third stage did not transition to done upon completion.");
            Assert.assertEquals(stage1.get(), (Object)10, (String)"Result of first stage does not match the value with which it was completed.");
            Assert.assertEquals((Object)((CompletableFuture)stage2).getNow(22), (Object)20, (String)"Result of second stage was lost or altered.");
            Assert.assertEquals(((CompletableFuture)stage3).join(), (Object)30, (String)"Result of third stage was lost or altered.");
            Assert.assertFalse((boolean)stage1.isCompletedExceptionally(), (String)"First stage should not report exceptional completion.");
            Assert.assertFalse((boolean)((CompletableFuture)stage2).isCompletedExceptionally(), (String)"Second stage should not report exceptional completion.");
            Assert.assertFalse((boolean)((CompletableFuture)stage3).isCompletedExceptionally(), (String)"Third stage should not report exceptional completion.");
            Assert.assertEquals((String)Buffer.get().toString(), (String)"newIncompleteFuture-test-buffer", (String)"Previous context was not restored after context was cleared for managed executor tasks.");
            Assert.assertEquals((String)Label.get(), (String)"newIncompleteFuture-test-label-C", (String)"Previous context was not restored after context was propagated for managed executor tasks.");
        }
        finally {
            executor.shutdownNow();
            Buffer.set(null);
            Label.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void propagateApplicationContext() throws ExecutionException, InterruptedException, TimeoutException {
        ManagedExecutor executor;
        ManagedExecutor.Builder builder = ManagedExecutor.builder().propagated(new String[]{"Application"}).cleared(new String[]{"Remaining"});
        try {
            executor = builder.build();
        }
        catch (IllegalStateException x) {
            return;
        }
        try {
            CompletableFuture cf = executor.supplyAsync(() -> {
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    return loader.loadClass("org.eclipse.microprofile.context.tck.contexts.label.Label");
                }
                catch (ClassNotFoundException x) {
                    throw new CompletionException(x);
                }
            });
            Assert.assertEquals(cf.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), Label.class, (String)"Could not load class from application's class loader.");
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void propagateTransactionContextJTA() throws Exception {
        Object tx;
        Class<?> userTransaction;
        ManagedExecutor executor;
        try {
            executor = ManagedExecutor.builder().propagated(new String[]{"Transaction"}).cleared(new String[]{"Remaining"}).build();
        }
        catch (IllegalStateException x) {
            System.out.println("Skipping test propagateTransactionContextJTA. Transaction context propagation is not supported.");
            return;
        }
        try {
            userTransaction = Class.forName("javax.transaction.UserTransaction");
        }
        catch (ClassNotFoundException x) {
            System.out.println("Skipping test propagateTransactionContextJTA. javax.transaction.UserTransaction not available to applications.");
            return;
        }
        Object txFromJNDI = null;
        try {
            txFromJNDI = InitialContext.doLookup("java:comp/UserTransaction");
            System.out.println("JTA UserTransaction is available in JNDI.");
        }
        catch (NamingException x) {
            System.out.println("JTA UserTransaction not available in JNDI: " + x);
        }
        Object txFromCDI = null;
        try {
            Class<?> cdi = Class.forName("javax.enterprise.inject.spi.CDI");
            Object current = cdi.getMethod("current", new Class[0]).invoke(null, new Object[0]);
            Object instance = cdi.getMethod("select", Class.class, Annotation[].class).invoke(current, userTransaction, new Annotation[0]);
            txFromCDI = instance.getClass().getMethod("get", new Class[0]).invoke(instance, new Object[0]);
            System.out.println("JTA UserTransaction is available via CDI.");
        }
        catch (RuntimeException | InvocationTargetException x) {
            System.out.println("JTA UserTransaction not available via CDI: " + (x instanceof InvocationTargetException ? x.getCause() : x));
        }
        Object object = tx = txFromJNDI == null ? txFromCDI : txFromJNDI;
        if (tx == null) {
            System.out.println("Skipping test propagateTransactionContextJTA. JTA transactions are not supported.");
            return;
        }
        System.out.println("Using JTA UserTransaction: " + tx);
        Method begin = userTransaction.getMethod("begin", new Class[0]);
        Method commit = userTransaction.getMethod("commit", new Class[0]);
        Method getStatus = userTransaction.getMethod("getStatus", new Class[0]);
        Method rollback = userTransaction.getMethod("rollback", new Class[0]);
        CompletableFuture stage0 = executor.newIncompleteFuture();
        CompletionStage stage1 = stage0.thenApply(s -> {
            try {
                Assert.assertEquals((Object)getStatus.invoke(tx, new Object[0]), (Object)6, (String)"Transaction status should indicate no transaction is active on thread.");
                begin.invoke(tx, new Object[0]);
                commit.invoke(tx, new Object[0]);
                return "SUCCESS1";
            }
            catch (Exception x) {
                throw new CompletionException(x);
            }
        });
        boolean txPropagationRejected = false;
        begin.invoke(tx, new Object[0]);
        try {
            String result;
            CompletionStage stage2;
            Assert.assertTrue((boolean)stage0.complete("READY"));
            Assert.assertEquals((String)((String)((CompletableFuture)stage1).join()), (String)"SUCCESS1");
            Assert.assertEquals((Object)getStatus.invoke(tx, new Object[0]), (Object)0, (String)"Transaction no longer active after running task.");
            try {
                stage2 = ((CompletableFuture)stage1).thenApplyAsync(s -> {
                    try {
                        Assert.assertEquals((Object)getStatus.invoke(tx, new Object[0]), (Object)0, (String)"Transaction context not propagated.");
                        return "SUCCESS2";
                    }
                    catch (Exception x) {
                        throw new CompletionException(x);
                    }
                });
            }
            catch (IllegalStateException x) {
                System.out.println("Skipping portion of test propagateTransactionContextJTA. Propagation of active transaction is not supported.");
                txPropagationRejected = true;
                if (txPropagationRejected) {
                    rollback.invoke(tx, new Object[0]);
                } else {
                    commit.invoke(tx, new Object[0]);
                }
                return;
            }
            try {
                result = (String)((CompletableFuture)stage2).get(MAX_WAIT_NS, TimeUnit.NANOSECONDS);
            }
            catch (ExecutionException x) {
                if (x.getCause() instanceof IllegalStateException) {
                    System.out.println("Skipping portion of test propagateTransactionContextJTA. Propagation of active transaction to multiple threads in parallel is not supported.");
                    txPropagationRejected = true;
                    if (txPropagationRejected) {
                        rollback.invoke(tx, new Object[0]);
                    } else {
                        commit.invoke(tx, new Object[0]);
                    }
                    return;
                }
                throw x;
            }
            Assert.assertEquals((String)result, (String)"SUCCESS2");
        }
        finally {
            if (txPropagationRejected) {
                rollback.invoke(tx, new Object[0]);
            } else {
                commit.invoke(tx, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shutdownNowPreventsAdditionalSubmitsAndCancelsTasks() throws ExecutionException, InterruptedException, TimeoutException {
        ManagedExecutor executor = ManagedExecutor.builder().maxAsync(1).maxQueued(4).propagated(new String[0]).cleared(new String[]{"Remaining"}).build();
        Phaser barrier = new Phaser(1);
        Future<Boolean> future5 = null;
        AtomicInteger task2ResultRef = new AtomicInteger(-1);
        try {
            List tasksThatDidNotStart;
            Future future4;
            CompletableFuture future3;
            CompletableFuture future2;
            Future future1;
            try {
                future1 = executor.submit(() -> barrier.awaitAdvanceInterruptibly(barrier.arrive() + 1));
                barrier.awaitAdvanceInterruptibly(0, MAX_WAIT_NS, TimeUnit.NANOSECONDS);
                future2 = executor.runAsync(() -> task2ResultRef.set(20));
                future3 = executor.supplyAsync(() -> "Q30");
                future4 = executor.submit(() -> "Q40");
                Assert.assertFalse((boolean)executor.isTerminated(), (String)"ManagedExecutor should not report being terminated when tasks are still running/queued.");
                future5 = this.unmanagedThreads.submit(() -> executor.awaitTermination(MAX_WAIT_NS, TimeUnit.NANOSECONDS));
            }
            finally {
                tasksThatDidNotStart = executor.shutdownNow();
            }
            Assert.assertNotNull((Object)tasksThatDidNotStart, (String)"Null list returned by ManagedExecutor.shutdownNow.");
            Assert.assertEquals((int)tasksThatDidNotStart.size(), (int)3, (String)("List of tasks that did not start should correspond to the tasks/actions that are queued. Observed: " + tasksThatDidNotStart));
            Assert.assertTrue((boolean)executor.isShutdown(), (String)"ManagedExecutor reported that it has not been shut down after we shut it down.");
            try {
                Future future6 = executor.submit(() -> 60);
                Assert.fail((String)("Should not be possible to submit new task after shutdownNow. Future: " + future6));
            }
            catch (RejectedExecutionException future6) {
                // empty catch block
            }
            try {
                CompletableFuture future7 = executor.supplyAsync(() -> 70);
                Assert.fail((String)("Should not be possible to create new async action after shutdownNow. Future: " + future7));
            }
            catch (RejectedExecutionException future7) {
                // empty catch block
            }
            Assert.assertTrue((boolean)executor.awaitTermination(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (String)"ManagedExecutor did not reach terminated state within a reasonable amount of time.");
            Assert.assertTrue((boolean)executor.isTerminated(), (String)"ManagedExecutor did not report being terminated after running/queued tasks were canceled and ended.");
            try {
                Assert.assertTrue((boolean)future1.isDone());
                Integer result1 = (Integer)future1.get(1L, TimeUnit.SECONDS);
                Assert.fail((String)("Running task should not complete successfully after shutdownNow. Result: " + result1));
            }
            catch (ExecutionException x) {
                if (!(x.getCause() instanceof InterruptedException)) {
                    throw x;
                }
            }
            catch (CancellationException x) {
                // empty catch block
            }
            if (future2.isDone()) {
                try {
                    Object result2 = future2.join();
                    Assert.fail((String)("Queued action should not run after shutdownNow. Result: " + result2));
                }
                catch (CancellationException result2) {}
            } else {
                Assert.assertTrue((!future2.isCancelled() ? 1 : 0) != 0, (String)"Running task should not complete after shutdownNow() invocation.");
            }
            if (future3.isDone()) {
                try {
                    String result3 = future3.getNow("333");
                    Assert.fail((String)("Queued action should not run after shutdownNow. Result: " + result3));
                }
                catch (CancellationException result3) {}
            } else {
                Assert.assertTrue((!future3.isCancelled() ? 1 : 0) != 0, (String)"Running task should not complete after shutdownNow() invocation.");
            }
            if (future4.isDone()) {
                try {
                    String result4 = (String)future4.get(1L, TimeUnit.SECONDS);
                    Assert.fail((String)("Queued task should not run after shutdownNow. Result: " + result4));
                }
                catch (CancellationException cancellationException) {}
            } else {
                Assert.assertTrue((!future4.isCancelled() ? 1 : 0) != 0, (String)"Running task should not complete after shutdownNow() invocation.");
            }
            Assert.assertEquals((int)task2ResultRef.get(), (int)-1, (String)"Queued action should not start running after shutdownNow.");
            Assert.assertEquals((Object)future5.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (Object)Boolean.TRUE, (String)"Notification of termination was not received in a reasonable amount of time by the awaitTermination request that was issued before shutdownNow");
        }
        finally {
            barrier.forceTermination();
            if (future5 != null) {
                future5.cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shutdownPreventsAdditionalSubmits() throws ExecutionException, InterruptedException, TimeoutException {
        ManagedExecutor executor = ManagedExecutor.builder().maxAsync(1).maxQueued(10).propagated(new String[0]).cleared(new String[]{"Remaining"}).build();
        Phaser barrier = new Phaser(1);
        Future<Boolean> future4 = null;
        Future<Boolean> future5 = null;
        try {
            Future future3;
            CompletableFuture future2;
            CompletableFuture future1;
            try {
                future1 = executor.supplyAsync(() -> barrier.awaitAdvance(barrier.arrive() + 1));
                barrier.awaitAdvanceInterruptibly(0, MAX_WAIT_NS, TimeUnit.NANOSECONDS);
                future2 = executor.supplyAsync(() -> "Q2");
                future3 = executor.submit(() -> "Q3");
                Assert.assertFalse((boolean)executor.isShutdown(), (String)"ManagedExecutor reportd that it has been shut down even though we did not shut it down yet.");
                future4 = this.unmanagedThreads.submit(() -> executor.awaitTermination(MAX_WAIT_NS, TimeUnit.NANOSECONDS));
            }
            finally {
                executor.shutdown();
            }
            Assert.assertTrue((boolean)executor.isShutdown(), (String)"ManagedExecutor reported that it has not been shut down after we shut it down.");
            try {
                Future future6 = executor.submit(() -> 60);
                Assert.fail((String)("Should not be possible to submit new task after shutdown. Future: " + future6));
            }
            catch (RejectedExecutionException future6) {
                // empty catch block
            }
            try {
                CompletableFuture future7 = executor.supplyAsync(() -> 70);
                Assert.fail((String)("Should not be possible to create new async action after shutdown. Future: " + future7));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
            Assert.assertFalse((boolean)future1.isDone(), (String)"Task should remain running after shutdown is invoked.");
            Assert.assertFalse((boolean)future2.isDone(), (String)"Action should remain queued after shutdown is invoked.");
            Assert.assertFalse((boolean)future3.isDone(), (String)"Task should remain queued after shutdown is invoked.");
            Assert.assertFalse((boolean)executor.isTerminated(), (String)"ManagedExecutor should not report being terminated when tasks are still running/queued.");
            executor.shutdown();
            future5 = this.unmanagedThreads.submit(() -> executor.awaitTermination(MAX_WAIT_NS, TimeUnit.NANOSECONDS));
            barrier.arrive();
            Assert.assertEquals(future1.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (Object)2, (String)"Unexpected result for action that was running when shutdown was requested.");
            Assert.assertEquals((String)((String)future2.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS)), (String)"Q2", (String)"Unexpected result for action that was in the queue when shutdown was requested.");
            Assert.assertEquals((String)((String)future3.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS)), (String)"Q3", (String)"Unexpected result for task that was in the queue when shutdown was requested.");
            Assert.assertEquals((Object)future4.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (Object)Boolean.TRUE, (String)"Notification of termination was not received in a reasonable amount of time by the awaitTermination request that was issued prior to shutdown");
            Assert.assertEquals((Object)future5.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (Object)Boolean.TRUE, (String)"Notification of termination was not received in a reasonable amount of time by the awaitTermination request that was issued after shutdown");
            Assert.assertTrue((boolean)executor.isTerminated(), (String)"ManagedExecutor did not report being terminated after running/queued tasks completed.");
        }
        finally {
            barrier.forceTermination();
            if (future4 != null) {
                future4.cancel(true);
            }
            if (future5 != null) {
                future5.cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void reuseManagedExecutorBuilder() throws ExecutionException, InterruptedException, TimeoutException {
        ManagedExecutor.Builder builder = ManagedExecutor.builder().propagated(new String[0]).cleared(new String[]{"Buffer"});
        ManagedExecutor clearingExecutor = builder.build();
        ManagedExecutor propagatingExecutor = builder.propagated(new String[]{"Buffer"}).cleared(new String[0]).build();
        try {
            Buffer.set(new StringBuffer("reuseBuilder-test-buffer-A"));
            CompletionStage clearedFuture = clearingExecutor.completedFuture((Object)1).thenRun(() -> {
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Buffer.set(new StringBuffer("reuseBuilder-test-buffer-B"));
            });
            CompletionStage propagatedFuture = propagatingExecutor.completedFuture((Object)1).thenRunAsync(() -> {
                Assert.assertEquals((String)Buffer.get().toString(), (String)"reuseBuilder-test-buffer-A", (String)"Context type was not propagated to contextual action.");
                Buffer.set(new StringBuffer("reuseBuilder-test-buffer-C"));
            });
            Assert.assertNull(propagatedFuture.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (String)"Non-null value returned by stage that runs Runnable.");
            Assert.assertNull(clearedFuture.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (String)"Non-null value returned by stage that runs Runnable.");
            Assert.assertEquals((String)Buffer.get().toString(), (String)"reuseBuilder-test-buffer-A", (String)"Previous context (Buffer) was not restored after context was propagated for contextual action.");
        }
        finally {
            clearingExecutor.shutdownNow();
            propagatingExecutor.shutdownNow();
            Buffer.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void runAsyncStageAndDependentStagesRunWithContext() throws ExecutionException, InterruptedException {
        ManagedExecutor executor = ManagedExecutor.builder().propagated(new String[]{"Label"}).cleared(new String[]{"Remaining"}).build();
        try {
            CompletionStage stage6;
            CompletionStage stage5;
            CompletionStage stage4;
            CompletionStage stage3;
            CompletionStage stage2;
            CompletableFuture stage1;
            block5: {
                Buffer.get().append("runAsync-test-buffer");
                Label.set("runAsync-test-label-A");
                stage1 = executor.runAsync(() -> {
                    Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                    Assert.assertEquals((String)Label.get(), (String)"runAsync-test-label-A", (String)"Context type was not correctly propagated to contextual action.");
                });
                Label.set("runAsync-test-label-B");
                stage2 = stage1.thenRunAsync(() -> {
                    Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                    Assert.assertEquals((String)Label.get(), (String)"runAsync-test-label-B", (String)"Context type was not correctly propagated to contextual action.");
                });
                Label.set("runAsync-test-label-C");
                stage3 = ((CompletableFuture)stage2).thenRunAsync(() -> {
                    Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                    Assert.assertEquals((String)Label.get(), (String)"runAsync-test-label-C", (String)"Context type was not correctly propagated to contextual action.");
                }, this.unmanagedThreads);
                Label.set("runAsync-test-label-D");
                stage4 = ((CompletableFuture)stage3).thenRun(() -> {
                    Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                    Assert.assertEquals((String)Label.get(), (String)"runAsync-test-label-D", (String)"Context type was not correctly propagated to contextual action.");
                    throw new NegativeArraySizeException("Fake exception raised by test");
                });
                Label.set("runAsync-test-label-E");
                stage5 = ((CompletableFuture)stage4).handle((v, x) -> {
                    Assert.assertNull((Object)v, (String)"Non-null value supplied to 'handle' method.");
                    Assert.assertEquals(x.getClass(), CompletionException.class, (String)"Exception parameter to 'handle' method is inconsistent with java.util.concurrent.CompletableFuture.");
                    Throwable cause = x.getCause();
                    Assert.assertNotNull((Object)cause, (String)"CompletionException supplied to 'handle' method lacks cause.");
                    Assert.assertEquals(cause.getClass(), NegativeArraySizeException.class, (String)"Wrong exception class supplied to 'handle' method.");
                    Assert.assertEquals((String)cause.getMessage(), (String)"Fake exception raised by test", (String)"Exception message was lost or altered.");
                    Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                    Assert.assertEquals((String)Label.get(), (String)"runAsync-test-label-E", (String)"Context type was not correctly propagated to contextual action.");
                    return Character.valueOf('E');
                });
                Label.set("runAsync-test-label-F");
                stage6 = ((CompletableFuture)stage5).thenAccept(c -> {
                    Assert.assertEquals((Object)c, (Object)Character.valueOf('E'), (String)"Value supplied to Consumer was lost or altered.");
                    Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                    Assert.assertEquals((String)Label.get(), (String)"runAsync-test-label-F", (String)"Context type was not correctly propagated to contextual action.");
                });
                Label.set("runAsync-test-label-G");
                CountDownLatch completed = new CountDownLatch(1);
                ((CompletableFuture)stage6).whenComplete((result, failure) -> completed.countDown());
                Assert.assertTrue((boolean)completed.await(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (String)"Completable future did not finish in a reasonable amount of time.");
                Assert.assertTrue((boolean)stage1.isDone(), (String)"First stage did not transition to done upon completion.");
                Assert.assertTrue((boolean)((CompletableFuture)stage2).isDone(), (String)"Second stage did not transition to done upon completion.");
                Assert.assertTrue((boolean)((CompletableFuture)stage3).isDone(), (String)"Third stage did not transition to done upon completion.");
                Assert.assertTrue((boolean)((CompletableFuture)stage4).isDone(), (String)"Fourth stage did not transition to done upon completion.");
                Assert.assertTrue((boolean)((CompletableFuture)stage5).isDone(), (String)"Fifth stage did not transition to done upon completion.");
                Assert.assertTrue((boolean)((CompletableFuture)stage6).isDone(), (String)"Sixth stage did not transition to done upon completion.");
                try {
                    Object result2 = ((CompletableFuture)stage4).join();
                    Assert.fail((String)("The join method must not return value " + result2 + " for stage with exceptional completion."));
                }
                catch (CompletionException x2) {
                    if (x2.getCause() != null && x2.getCause() instanceof NegativeArraySizeException && "Fake exception raised by test".equals(x2.getCause().getMessage())) break block5;
                    throw x2;
                }
            }
            Assert.assertEquals(((CompletableFuture)stage5).join(), (Object)Character.valueOf('E'), (String)"Return value of 'handle' method was lost or altered.");
            Assert.assertFalse((boolean)stage1.isCompletedExceptionally(), (String)"First stage should not report exceptional completion.");
            Assert.assertFalse((boolean)((CompletableFuture)stage2).isCompletedExceptionally(), (String)"Second stage should not report exceptional completion.");
            Assert.assertFalse((boolean)((CompletableFuture)stage3).isCompletedExceptionally(), (String)"Third stage should not report exceptional completion.");
            Assert.assertTrue((boolean)((CompletableFuture)stage4).isCompletedExceptionally(), (String)"Fourth stage did not report exceptional completion.");
            Assert.assertFalse((boolean)((CompletableFuture)stage5).isCompletedExceptionally(), (String)"Fifth stage should not report exceptional completion.");
            Assert.assertFalse((boolean)((CompletableFuture)stage6).isCompletedExceptionally(), (String)"Sixth stage should not report exceptional completion.");
        }
        finally {
            executor.shutdownNow();
            Buffer.set(null);
            Label.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void submittedTasksRunWithContext() throws ExecutionException, InterruptedException, TimeoutException {
        ManagedExecutor executor = ManagedExecutor.builder().propagated(new String[]{"Label"}).cleared(new String[]{"Remaining"}).build();
        try {
            Future futureC;
            Future futureB;
            Future futureA;
            block5: {
                Buffer.set(new StringBuffer("submitted-tasks-test-buffer-A"));
                Label.set("submitted-tasks-test-label-A");
                futureA = executor.submit(() -> {
                    Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                    Assert.assertEquals((String)Label.get(), (String)"submitted-tasks-test-label-A", (String)"Context type was not correctly propagated to contextual action.");
                    throw new Error("Fake error intentionally raised by test Runnable.");
                });
                Label.set("submitted-tasks-test-label-B");
                futureB = executor.submit(() -> {
                    Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                    Assert.assertEquals((String)Label.get(), (String)"submitted-tasks-test-label-B", (String)"Context type was not correctly propagated to contextual action.");
                }, (Object)"Task-B-Result");
                Label.set("submitted-tasks-test-label-C");
                futureC = executor.submit(() -> {
                    Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                    Assert.assertEquals((String)Label.get(), (String)"submitted-tasks-test-label-C", (String)"Context type was not correctly propagated to contextual action.");
                    return "Task-C-Result";
                });
                try {
                    Object result = futureA.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS);
                    Assert.fail((String)("Result of " + result + " returned for Runnable that throws an Error."));
                }
                catch (ExecutionException x) {
                    if (x.getCause() != null && x.getCause() instanceof Error && "Fake error intentionally raised by test Runnable.".equals(x.getCause().getMessage())) break block5;
                    throw x;
                }
            }
            Assert.assertEquals((String)"Task-B-Result", (String)((String)futureB.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS)), (String)"Result does not match the predetermined result that was specified when submitting the Runnable.");
            Assert.assertEquals((String)"Task-C-Result", (String)((String)futureC.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS)), (String)"Result does not match the result returned by the Callable.");
            Assert.assertTrue((boolean)futureA.isDone(), (String)"Future for first Runnable should report being done after test case awaits its completion.");
            Assert.assertTrue((boolean)futureB.isDone(), (String)"Future for second Runnable should report being done after test case awaits its completion.");
            Assert.assertTrue((boolean)futureC.isDone(), (String)"Future for Callable should report being done after test case awaits its completion.");
            Assert.assertFalse((boolean)futureA.isCancelled(), (String)"Future for first Runnable should not be canceled because the test case did not cancel it.");
            Assert.assertFalse((boolean)futureB.isCancelled(), (String)"Future for second Runnable should not be canceled because the test case did not cancel it.");
            Assert.assertFalse((boolean)futureC.isCancelled(), (String)"Future for Callable should not be canceled because the test case did not cancel it.");
        }
        finally {
            executor.shutdownNow();
            Buffer.set(null);
            Label.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void supplyAsyncStageAndDependentStagesRunWithContext() throws ExecutionException, InterruptedException, TimeoutException {
        ManagedExecutor executor = ManagedExecutor.builder().propagated(new String[]{"Buffer"}).cleared(new String[]{"Remaining"}).build();
        try {
            Buffer.set(new StringBuffer("supplyAsync-test-buffer-A"));
            Label.set("supplyAsync-test-label");
            CompletableFuture stage1 = executor.supplyAsync(() -> {
                Assert.assertEquals((String)Buffer.get().toString(), (String)"supplyAsync-test-buffer-A", (String)"Context type was not correctly propagated to contextual action.");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                return 100L;
            });
            Buffer.set(new StringBuffer("supplyAsync-test-buffer-B"));
            CompletionStage stage2 = stage1.thenApply(i -> {
                Assert.assertEquals((Object)i, (Object)100L, (String)"Value supplied to Function was lost or altered.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"supplyAsync-test-buffer-B", (String)"Context type was not correctly propagated to contextual action.");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                return 200L;
            });
            Buffer.set(new StringBuffer("supplyAsync-test-buffer-C"));
            CompletionStage stage3 = stage1.thenApply(i -> {
                Assert.assertEquals((Object)i, (Object)100L, (String)"Value supplied to Function was lost or altered.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"supplyAsync-test-buffer-C", (String)"Context type was not correctly propagated to contextual action.");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                return 300L;
            });
            Buffer.set(new StringBuffer("supplyAsync-test-buffer-D"));
            CompletionStage stage4 = ((CompletableFuture)stage2).thenAcceptBoth(stage3, (i, j) -> {
                Assert.assertEquals((Object)i, (Object)200L, (String)"First value supplied to BiConsumer was lost or altered.");
                Assert.assertEquals((Object)j, (Object)300L, (String)"Second value supplied to BiConsumer was lost or altered.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"supplyAsync-test-buffer-D", (String)"Context type was not correctly propagated to contextual action.");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
            });
            Buffer.set(new StringBuffer("supplyAsync-test-buffer-D"));
            CountDownLatch completed = new CountDownLatch(1);
            ((CompletableFuture)stage4).handleAsync((result, x) -> {
                completed.countDown();
                return result;
            }, (Executor)this.unmanagedThreads);
            Assert.assertTrue((boolean)completed.await(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (String)"Completable future did not finish in a reasonable amount of time.");
            Assert.assertEquals(stage1.get(10L, TimeUnit.SECONDS), (Object)100L, (String)"Unexpected result for first stage.");
            Assert.assertEquals(((CompletableFuture)stage2).join(), (Object)200L, (String)"Unexpected result for second stage.");
            Assert.assertEquals((Object)((CompletableFuture)stage3).getNow(33L), (Object)300L, (String)"Unexpected result for third stage.");
            Assert.assertNull(((CompletableFuture)stage4).join(), (String)"Unexpected result for fourth stage.");
            Assert.assertEquals((String)Buffer.get().toString(), (String)"supplyAsync-test-buffer-D", (String)"Previous context was not restored after context was propagated for managed executor tasks.");
            Assert.assertEquals((String)Label.get(), (String)"supplyAsync-test-label", (String)"Previous context was not restored after context was cleared for managed executor tasks.");
        }
        finally {
            executor.shutdownNow();
            Buffer.set(null);
            Label.set(null);
        }
    }

    @Test
    public void timedInvokeAllRunsTasksWithContext() throws ExecutionException, InterruptedException, TimeoutException {
        ManagedExecutor executor = ManagedExecutor.builder().propagated(new String[]{"Buffer"}).cleared(new String[]{"Remaining"}).build();
        try {
            Buffer.set(new StringBuffer("timed-invokeAll-test-buffer-A"));
            Label.set("timed-invokeAll-test-label-A");
            List futures = executor.invokeAll(Arrays.asList(() -> {
                Assert.assertEquals((String)Buffer.get().toString(), (String)"timed-invokeAll-test-buffer-A", (String)"Context type was not propagated to contextual action.");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Label.set("timed-invokeAll-test-label-B");
                Buffer.set(new StringBuffer("timed-invokeAll-test-buffer-B"));
                return "B";
            }, () -> {
                Assert.assertEquals((String)Buffer.get().toString(), (String)"timed-invokeAll-test-buffer-A", (String)"Context type was not propagated to contextual action.");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Label.set("timed-invokeAll-test-label-C");
                Buffer.set(new StringBuffer("invokeAll-test-buffer-C"));
                return "C";
            }), MAX_WAIT_NS, TimeUnit.NANOSECONDS);
            Assert.assertEquals((int)futures.size(), (int)2, (String)("Number of futures does not match the number of tasks. " + futures));
            Assert.assertTrue((boolean)((Future)futures.get(0)).isDone(), (String)"Future for first task does not indicate it is done after invokeAll.");
            Assert.assertEquals((String)((String)((Future)futures.get(0)).get()), (String)"B", (String)"Future for first task returned wrong value.");
            Assert.assertTrue((boolean)((Future)futures.get(1)).isDone(), (String)"Future for second task does not indicate it is done after invokeAll.");
            Assert.assertEquals((String)((String)((Future)futures.get(1)).get(1L, TimeUnit.SECONDS)), (String)"C", (String)"Future for second task returned wrong value.");
            Assert.assertEquals((String)Label.get(), (String)"timed-invokeAll-test-label-A", (String)"Previous context was not restored after context was propagated for managed executor tasks.");
            Assert.assertEquals((String)Buffer.get().toString(), (String)"timed-invokeAll-test-buffer-A", (String)"Previous context was not restored after context was cleared for managed executor tasks.");
        }
        finally {
            executor.shutdownNow();
            Buffer.set(null);
            Label.set(null);
        }
    }

    @Test
    public void timedInvokeAnyRunsTaskWithContext() throws ExecutionException, InterruptedException, TimeoutException {
        ManagedExecutor executor = ManagedExecutor.builder().propagated(new String[]{"Buffer"}).cleared(new String[]{"Remaining"}).build();
        try {
            Buffer.set(new StringBuffer("timed-invokeAny-test-buffer-A"));
            Label.set("timed-invokeAny-test-label-A");
            Character result = (Character)executor.invokeAny(Arrays.asList(() -> {
                Assert.assertEquals((String)Buffer.get().toString(), (String)"timed-invokeAny-test-buffer-A", (String)"Context type was not propagated to contextual action.");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Label.set("timed-invokeAny-test-label-B");
                Buffer.set(new StringBuffer("timed-invokeAny-test-buffer-B"));
                return Character.valueOf('b');
            }, () -> {
                Assert.assertEquals((String)Buffer.get().toString(), (String)"timed-invokeAny-test-buffer-A", (String)"Context type was not propagated to contextual action.");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Label.set("timed-invokeAny-test-label-C");
                Buffer.set(new StringBuffer("invokeAny-test-buffer-C"));
                return Character.valueOf('c');
            }), MAX_WAIT_NS, TimeUnit.NANOSECONDS);
            Assert.assertTrue((Character.valueOf('b').equals(result) || Character.valueOf('c').equals(result) ? 1 : 0) != 0, (String)("Result of invokeAny, " + result + ", does not match the result of either of the tasks."));
            Assert.assertEquals((String)Label.get(), (String)"timed-invokeAny-test-label-A", (String)"Previous context was not restored after context was propagated for managed executor tasks.");
            Assert.assertEquals((String)Buffer.get().toString(), (String)"timed-invokeAny-test-buffer-A", (String)"Previous context was not restored after context was cleared for managed executor tasks.");
        }
        finally {
            executor.shutdownNow();
            Buffer.set(null);
            Label.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void untimedInvokeAllRunsTasksWithContext() throws ExecutionException, InterruptedException, TimeoutException {
        ManagedExecutor executor = ManagedExecutor.builder().maxAsync(1).propagated(new String[]{"Label"}).cleared(new String[]{"Remaining"}).build();
        AtomicLong asyncThreadIdRef = new AtomicLong();
        long testThreadId = Thread.currentThread().getId();
        try {
            Buffer.set(new StringBuffer("untimed-invokeAll-test-buffer-A"));
            Label.set("untimed-invokeAll-test-label-A");
            List futures = executor.invokeAll(Arrays.asList(() -> {
                long threadId = Thread.currentThread().getId();
                if (threadId != testThreadId) {
                    Assert.assertEquals((long)asyncThreadIdRef.getAndSet(threadId), (long)0L, (String)"Thread ID indicates that ManagedExecutor invokeAll operation exceeded maxAsync of 1.");
                }
                Assert.assertEquals((String)Label.get(), (String)"untimed-invokeAll-test-label-A", (String)"Context type was not propagated to contextual action.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Label.set("untimed-invokeAll-test-label-B");
                Buffer.set(new StringBuffer("untimed-invokeAll-test-buffer-B"));
                asyncThreadIdRef.compareAndSet(threadId, 0L);
                return 66;
            }, () -> {
                long threadId = Thread.currentThread().getId();
                if (threadId != testThreadId) {
                    Assert.assertEquals((long)asyncThreadIdRef.getAndSet(threadId), (long)0L, (String)"Thread ID indicates that ManagedExecutor invokeAll operation exceeded maxAsync of 1.");
                }
                Assert.assertEquals((String)Label.get(), (String)"untimed-invokeAll-test-label-A", (String)"Context type was not propagated to contextual action.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Label.set("untimed-invokeAll-test-label-C");
                Buffer.set(new StringBuffer("uninvokeAll-test-buffer-C"));
                asyncThreadIdRef.compareAndSet(threadId, 0L);
                return 67;
            }, () -> {
                long threadId = Thread.currentThread().getId();
                if (threadId != testThreadId) {
                    Assert.assertEquals((long)asyncThreadIdRef.getAndSet(threadId), (long)0L, (String)"Thread ID indicates that ManagedExecutor invokeAll operation exceeded maxAsync of 1.");
                }
                Assert.assertEquals((String)Label.get(), (String)"untimed-invokeAll-test-label-A", (String)"Context type was not propagated to contextual action.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Label.set("untimed-invokeAll-test-label-D");
                Buffer.set(new StringBuffer("untimed-invokeAll-test-buffer-D"));
                asyncThreadIdRef.compareAndSet(threadId, 0L);
                return 68;
            }, () -> {
                long threadId = Thread.currentThread().getId();
                if (threadId != testThreadId) {
                    Assert.assertEquals((long)asyncThreadIdRef.getAndSet(threadId), (long)0L, (String)"Thread ID indicates that ManagedExecutor invokeAll operation exceeded maxAsync of 1.");
                }
                Assert.assertEquals((String)Label.get(), (String)"untimed-invokeAll-test-label-A", (String)"Context type was not propagated to contextual action.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Label.set("untimed-invokeAll-test-label-E");
                Buffer.set(new StringBuffer("untimed-invokeAll-test-buffer-E"));
                asyncThreadIdRef.compareAndSet(threadId, 0L);
                return 69;
            }), MAX_WAIT_NS, TimeUnit.NANOSECONDS);
            Assert.assertEquals((int)futures.size(), (int)4, (String)("Number of futures does not match the number of tasks. " + futures));
            Assert.assertTrue((boolean)((Future)futures.get(0)).isDone(), (String)"Future for first task does not indicate it is done after invokeAll.");
            Assert.assertEquals(((Future)futures.get(0)).get(), (Object)66, (String)"Future for first task returned wrong value.");
            Assert.assertTrue((boolean)((Future)futures.get(1)).isDone(), (String)"Future for second task does not indicate it is done after invokeAll.");
            Assert.assertEquals(((Future)futures.get(1)).get(1L, TimeUnit.SECONDS), (Object)67, (String)"Future for second task returned wrong value.");
            Assert.assertTrue((boolean)((Future)futures.get(2)).isDone(), (String)"Future for third task does not indicate it is done after invokeAll.");
            Assert.assertEquals(((Future)futures.get(2)).get(), (Object)68, (String)"Future for third task returned wrong value.");
            Assert.assertTrue((boolean)((Future)futures.get(3)).isDone(), (String)"Future for fourth task does not indicate it is done after invokeAll.");
            Assert.assertEquals(((Future)futures.get(3)).get(), (Object)69, (String)"Future for fourth task returned wrong value.");
            Assert.assertEquals((String)Label.get(), (String)"untimed-invokeAll-test-label-A", (String)"Previous context was not restored after context was propagated for managed executor tasks.");
            Assert.assertEquals((String)Buffer.get().toString(), (String)"untimed-invokeAll-test-buffer-A", (String)"Previous context was not restored after context was cleared for managed executor tasks.");
        }
        finally {
            executor.shutdownNow();
            Buffer.set(null);
            Label.set(null);
        }
    }

    @Test
    public void untimedInvokeAnyRunsTasksWithContext() throws ExecutionException, InterruptedException, TimeoutException {
        ManagedExecutor executor = ManagedExecutor.builder().maxAsync(1).propagated(new String[]{"Label"}).cleared(new String[]{"Remaining"}).build();
        try {
            Buffer.set(new StringBuffer("untimed-invokeAny-test-buffer-A"));
            Label.set("untimed-invokeAny-test-label-A");
            String result = (String)executor.invokeAny(Arrays.asList(() -> {
                Assert.assertEquals((String)Label.get(), (String)"untimed-invokeAny-test-label-A", (String)"Context type was not propagated to contextual action.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Label.set("untimed-invokeAny-test-label-B");
                Buffer.set(new StringBuffer("untimed-invokeAny-test-buffer-B"));
                return "Bb";
            }, () -> {
                Assert.assertEquals((String)Label.get(), (String)"untimed-invokeAny-test-label-A", (String)"Context type was not propagated to contextual action.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Label.set("untimed-invokeAny-test-label-C");
                Buffer.set(new StringBuffer("uninvokeAny-test-buffer-C"));
                return "Cc";
            }, () -> {
                Assert.assertEquals((String)Label.get(), (String)"untimed-invokeAny-test-label-A", (String)"Context type was not propagated to contextual action.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Label.set("untimed-invokeAny-test-label-D");
                Buffer.set(new StringBuffer("untimed-invokeAny-test-buffer-D"));
                return "Dd";
            }), MAX_WAIT_NS, TimeUnit.NANOSECONDS);
            Assert.assertTrue(("Bb".equals(result) || "Cc".equals(result) || "Dd".equals(result) ? 1 : 0) != 0, (String)("Result of invokeAny, " + result + ", does not match the result of any of the tasks."));
            Assert.assertEquals((String)Label.get(), (String)"untimed-invokeAny-test-label-A", (String)"Previous context was not restored after context was propagated for managed executor tasks.");
            Assert.assertEquals((String)Buffer.get().toString(), (String)"untimed-invokeAny-test-buffer-A", (String)"Previous context was not restored after context was cleared for managed executor tasks.");
        }
        finally {
            executor.shutdownNow();
            Buffer.set(null);
            Label.set(null);
        }
    }

    private static /* synthetic */ CompletableFuture lambda$contextOfContextualFunctionOverridesContextOfManagedExecutor$19(CompletableFuture stage1, Integer i) {
        Assert.assertEquals((String)Label.get(), (String)"contextualFunctionOverride-label-4", (String)"Previously captured context type not found on thread.");
        Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type not cleared from thread.");
        return stage1;
    }
}

