/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck;

import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.tck.base.AbstractTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ConfigProviderTest
extends Arquillian {
    @Inject
    private Config config;

    @Deployment
    public static WebArchive deploy() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"configProviderTest.war")).addPackage(AbstractTest.class.getPackage())).addClass(ConfigProviderTest.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        AbstractTest.addFile(war, "META-INF/microprofile-config.properties");
        return war;
    }

    @BeforeClass
    public static void setupCheck() {
        boolean checkOK = false;
        Map<String, String> env = System.getenv();
        Properties properties = System.getProperties();
        for (Map.Entry<String, String> envEntry : env.entrySet()) {
            String key = envEntry.getKey();
            if (properties.containsKey(key)) continue;
            checkOK = true;
            break;
        }
        Assert.assertTrue((boolean)checkOK, (String)"Ensure that there is at least one property which is unique to the environment variables and not also a system property.");
    }

    @Test
    public void testEnvironmentConfigSource() {
        String value = System.getenv().get("MP_TCK_ENV_DUMMY");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((String)"dummy", (String)value);
        Assert.assertEquals((String)value, (String)((String)this.config.getValue("mp.tck.env.dummy", String.class)));
    }

    @Test
    public void testPropertyConfigSource() {
        Assert.assertNotNull((Object)this.config.getValue("java.version", String.class));
        String value = System.getProperties().getProperty("mp.tck.prop.dummy");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((String)"dummy", (String)value);
        Assert.assertEquals((String)value, (String)((String)this.config.getValue("mp.tck.prop.dummy", String.class)));
    }

    @Test
    public void testDynamicValueInPropertyConfigSource() {
        String configKey = "tck.config.test.systemproperty.dynamic.value";
        String configValue = "myDynamicValue;";
        System.setProperty(configKey, configValue);
        Assert.assertEquals((String)((String)this.config.getValue(configKey, String.class)), (String)configValue);
    }

    @Test
    public void testJavaConfigPropertyFilesConfigSource() {
        Assert.assertEquals((String)((String)this.config.getValue("tck.config.test.javaconfig.properties.key1", String.class)), (String)"VALue1");
    }

    @Test
    public void testNonExistingConfigKey() {
        Assert.assertFalse((boolean)this.config.getOptionalValue("tck.config.test.keydoesnotexist", String.class).isPresent());
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testNonExistingConfigKeyGet() {
        this.config.getValue("tck.config.test.keydoesnotexist", String.class);
    }

    @Test
    public void testGetConfigSources() {
        Iterable configSources = this.config.getConfigSources();
        Assert.assertNotNull((Object)configSources);
        int prevOrdinal = Integer.MAX_VALUE;
        for (ConfigSource configSource : configSources) {
            Assert.assertTrue((configSource.getOrdinal() <= prevOrdinal ? 1 : 0) != 0);
            prevOrdinal = configSource.getOrdinal();
        }
    }

    @Test
    public void testInjectedConfigSerializable() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(byteArrayOutputStream);){
            out.writeObject(this.config);
        }
        catch (IOException ex) {
            Assert.fail((String)"Injected config should be serializable, but could not serialize it", (Throwable)ex);
        }
        Object readObject = null;
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));){
            readObject = in.readObject();
        }
        catch (IOException | ClassNotFoundException ex) {
            Assert.fail((String)"Injected config should be serializable, but could not deserialize a previously serialized instance", (Throwable)ex);
        }
        MatcherAssert.assertThat((String)"Deserialized object", readObject, (Matcher)CoreMatchers.instanceOf(Config.class));
    }

    @Test
    public void testGetPropertyNames() {
        String configKey = "some.arbitrary.key";
        String configValue = "value";
        System.setProperty(configKey, configValue);
        AtomicBoolean foundKey = new AtomicBoolean(false);
        this.config.getConfigSources().forEach(c -> {
            if (c.getPropertyNames().contains(configKey)) {
                foundKey.set(true);
            }
        });
        Assert.assertTrue((boolean)foundKey.get(), (String)("Unable to find property " + configKey));
    }
}

