/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck.util;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import org.testng.Assert;

public final class AdditionalAssertions {
    private AdditionalAssertions() {
    }

    public static boolean urlEquals(URL expected, URL actual) throws URISyntaxException {
        return expected.toURI().equals(actual.toURI());
    }

    public static void assertURLArrayEquals(URL[] value, URL[] expectedValue) throws MalformedURLException {
        AdditionalAssertions.assertURLListEquals(Arrays.asList(value), Arrays.asList(expectedValue));
    }

    public static void assertURLListEquals(List<URL> value, List<URL> expectedValue) throws MalformedURLException {
        Assert.assertTrue((boolean)IntStream.range(0, expectedValue.size()).allMatch(i -> {
            try {
                return AdditionalAssertions.urlEquals((URL)expectedValue.get(i), (URL)value.get(i));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return false;
            }
        }));
    }

    public static void assertURLSetEquals(Set<URL> valueSet, Set<URL> expectedURLSet) throws MalformedURLException, URISyntaxException {
        Assert.assertTrue((valueSet.size() == expectedURLSet.size() ? 1 : 0) != 0);
        Iterator<URL> it = valueSet.iterator();
        boolean isEquals = true;
        while (it.hasNext()) {
            boolean found = false;
            URL url = it.next();
            for (URL thisURL : expectedURLSet) {
                if (!AdditionalAssertions.urlEquals(thisURL, url)) continue;
                found = true;
                break;
            }
            if (found) continue;
            isEquals = false;
            break;
        }
        Assert.assertTrue((boolean)isEquals);
    }
}

