/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck;

import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.tck.SimpleValuesBean;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CDIPropertyNameMatchingTest
extends Arquillian {
    @Inject
    private Config config;

    @Deployment
    public static Archive deployment() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"CDIPropertyNameMatchingTest.jar")).addClasses(new Class[]{CDIPropertyNameMatchingTest.class, SimpleValuesBean.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"CDIPropertyNameMatchingTest.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @BeforeClass
    public void checkSetup() {
        if (!"45".equals(System.getenv("my_int_property"))) {
            Assert.fail((String)"Before running this test, the environment variable \"my_int_property\" must be set with the value of 45");
        }
        if (!"true".equals(System.getenv("MY_BOOLEAN_PROPERTY"))) {
            Assert.fail((String)"Before running this test, the environment variable \"MY_BOOLEAN_Property\" must be set with the value of true");
        }
        if (System.getProperty("os.name").contains("Windows")) {
            String myStringProp = System.getenv("MY_STRING_PROPERTY");
            if (!"woohoo".equals(myStringProp) && !"haha".equals(myStringProp)) {
                Assert.fail((String)"Before running this test on a Windows platform, the environment variable \"MY_STRING_PROPERTY\" must be set with the value of woohoo or haha");
            }
        } else {
            if (!"haha".equals(System.getenv("my_string_property"))) {
                Assert.fail((String)"Before running this test on a non-Windows platform, the environment variable \"my_string_property\" must be set with the value of haha");
            }
            if (!"woohoo".equals(System.getenv("MY_STRING_PROPERTY"))) {
                Assert.fail((String)"Before running this test on a non-Windows platform, the environment variable \"MY_STRING_PROPERTY\" must be set with the value of woohoo");
            }
        }
    }

    @Test
    public void testPropertyFromEnvironmentVariables() {
        SimpleValuesBean bean = this.getBeanOfType(SimpleValuesBean.class);
        if (((String)this.config.getValue("os.name", String.class)).contains("Windows")) {
            MatcherAssert.assertThat((Object)bean.getStringProperty(), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)"haha"), (Matcher)Matchers.equalTo((Object)"woohoo")));
        } else {
            MatcherAssert.assertThat((Object)bean.getStringProperty(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"haha")));
        }
        MatcherAssert.assertThat((Object)bean.getBooleanProperty(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)bean.getIntProperty(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)45)));
    }

    private <T> T getBeanOfType(Class<T> beanClass) {
        return (T)CDI.current().select(beanClass, new Annotation[0]).get();
    }
}

