/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck;

import jakarta.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.Converter;
import org.eclipse.microprofile.config.tck.base.AbstractTest;
import org.eclipse.microprofile.config.tck.converters.custom.BooleanConverter;
import org.eclipse.microprofile.config.tck.converters.custom.CharacterConverter;
import org.eclipse.microprofile.config.tck.converters.custom.DoubleConverter;
import org.eclipse.microprofile.config.tck.converters.custom.IntegerConverter;
import org.eclipse.microprofile.config.tck.converters.custom.LongConverter;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CustomConverterTest
extends Arquillian {
    @Inject
    private Config config;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"customConverterTest.jar")).addClass(CustomConverterTest.class)).addClass(IntegerConverter.class)).addClass(LongConverter.class)).addClass(DoubleConverter.class)).addClass(BooleanConverter.class)).addClass(CharacterConverter.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsServiceProvider(Converter.class, new Class[]{IntegerConverter.class, LongConverter.class, DoubleConverter.class, BooleanConverter.class, CharacterConverter.class})).as(JavaArchive.class);
        AbstractTest.addFile(testJar, "META-INF/microprofile-config.properties");
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"customConverterTest.war")).addAsLibrary((Archive)testJar);
    }

    @Test
    public void testInteger() {
        Integer value = (Integer)this.config.getValue("tck.config.test.javaconfig.custom.converter.integervalue", Integer.class);
        Assert.assertEquals((Object)value, (Object)999);
    }

    @Test
    public void testIntPrimitive() {
        int value = (Integer)this.config.getValue("tck.config.test.javaconfig.custom.converter.integervalue", Integer.TYPE);
        Assert.assertEquals((int)value, (int)999);
    }

    @Test
    public void testLong() {
        Long value = (Long)this.config.getValue("tck.config.test.javaconfig.custom.converter.longvalue", Long.class);
        Assert.assertEquals((Object)value, (Object)999L);
    }

    @Test
    public void testLongPrimitive() {
        long value = (Long)this.config.getValue("tck.config.test.javaconfig.custom.converter.longvalue", Long.TYPE);
        Assert.assertEquals((long)value, (long)999L);
    }

    @Test
    public void testDouble() {
        Double value = (Double)this.config.getValue("tck.config.test.javaconfig.custom.converter.doublevalue", Double.class);
        Assert.assertEquals((Object)value, (Object)new Double(999.9));
    }

    @Test
    public void testDoublePrimitive() {
        double value = (Double)this.config.getValue("tck.config.test.javaconfig.custom.converter.doublevalue", Double.TYPE);
        Assert.assertEquals((double)value, (double)999.9);
    }

    @Test
    public void testBoolean() {
        Boolean value = (Boolean)this.config.getValue("tck.config.test.javaconfig.custom.converter.booleanvalue", Boolean.class);
        Assert.assertEquals((Object)value, (Object)Boolean.TRUE);
    }

    @Test
    public void testBooleanPrimitive() {
        boolean value = (Boolean)this.config.getValue("tck.config.test.javaconfig.custom.converter.booleanvalue", Boolean.TYPE);
        Assert.assertTrue((boolean)value);
    }

    @Test
    public void testCharacter() {
        Character value = (Character)this.config.getValue("tck.config.test.javaconfig.custom.converter.charvalue", Character.class);
        Assert.assertEquals((Object)value, (Object)Character.valueOf('r'));
    }

    @Test
    public void testCharPrimitive() {
        char value = ((Character)this.config.getValue("tck.config.test.javaconfig.custom.converter.charvalue", Character.TYPE)).charValue();
        Assert.assertEquals((char)value, (char)'r');
    }

    @Test
    public void testGetIntegerConverter() {
        Integer value = (Integer)((Converter)this.config.getConverter(Integer.class).get()).convert("1");
        Assert.assertEquals((Object)value, (Object)999);
    }

    @Test
    public void testGetIntPrimitiveConverter() {
        int value = (Integer)((Converter)this.config.getConverter(Integer.TYPE).get()).convert("1");
        Assert.assertEquals((int)value, (int)999);
    }

    @Test
    public void testGetLongConverter() {
        Long value = (Long)((Converter)this.config.getConverter(Long.class).get()).convert("1");
        Assert.assertEquals((Object)value, (Object)999L);
    }

    @Test
    public void testGetLongPrimitiveConverter() {
        long value = (Long)((Converter)this.config.getConverter(Long.TYPE).get()).convert("1");
        Assert.assertEquals((long)value, (long)999L);
    }

    @Test
    public void testGetDoubleConverter() {
        Double value = (Double)((Converter)this.config.getConverter(Double.class).get()).convert("1.0");
        Assert.assertEquals((Object)value, (Object)new Double(999.9));
    }

    @Test
    public void testGetDoublePrimitiveConverter() {
        double value = (Double)((Converter)this.config.getConverter(Double.TYPE).get()).convert("1.0");
        Assert.assertEquals((double)value, (double)999.9);
    }

    @Test
    public void testGetBooleanConverter() {
        Boolean value = (Boolean)((Converter)this.config.getConverter(Boolean.class).get()).convert("false");
        Assert.assertEquals((Object)value, (Object)Boolean.TRUE);
    }

    @Test
    public void testGetBooleanPrimitiveConverter() {
        boolean value = (Boolean)((Converter)this.config.getConverter(Boolean.TYPE).get()).convert("false");
        Assert.assertTrue((boolean)value);
    }

    @Test
    public void testGetCharacterConverter() {
        Character value = (Character)((Converter)this.config.getConverter(Character.class).get()).convert("c");
        Assert.assertEquals((Object)value, (Object)Character.valueOf('r'));
    }

    @Test
    public void testGetCharPrimitiveConverter() {
        char value = ((Character)((Converter)this.config.getConverter(Character.TYPE).get()).convert("c")).charValue();
        Assert.assertEquals((char)value, (char)'r');
    }
}

