/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck.emptyvalue;

import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EmptyValuesTestProgrammaticLookup
extends Arquillian {
    @Inject
    private Config config;

    @Deployment
    public static Archive deployment() {
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"emptyValues.jar")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsManifestResource((Asset)new StringAsset("empty.string=\ncomma.string=,\nbackslash.comma.string=\\\\,\ndouble.comma.string=,,\nfoo.bar.string=foo,bar\nfoo.comma.string=foo,\ncomma.bar.string=,bar\nspace.string=\\u0020"), "microprofile-config.properties");
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsLibrary((Archive)jar)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testMissingStringGetValueArray() {
        String[] values = (String[])this.config.getValue("missing.string", String[].class);
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testMissingStringGetValue() {
        this.config.getValue("missing.string", String.class);
    }

    @Test
    public void testMissingStringGetOptionalValue() {
        this.assertConfigurationNotPresentForOptional("missing.string");
        this.assertConfigurationNotPresentForOptionalMultiple("missing.string");
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testEmptyStringGetValueArray() {
        String[] values = (String[])this.config.getValue("empty.string", String[].class);
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testEmptyStringGetValue() {
        this.config.getValue("empty.string", String.class);
    }

    @Test
    public void testEmptyStringGetOptionalValue() {
        this.assertConfigurationNotPresentForOptional("empty.string");
        this.assertConfigurationNotPresentForOptionalMultiple("empty.string");
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testCommaStringGetValueArray() {
        String[] values = (String[])this.config.getValue("comma.string", String[].class);
    }

    @Test
    public void testCommaStringGetValue() {
        String value = (String)this.config.getValue("comma.string", String.class);
        Assert.assertEquals((String)value, (String)",");
    }

    @Test
    public void testCommaStringGetOptionalValue() {
        Assert.assertEquals((String)((String)this.config.getOptionalValue("comma.string", String.class).get()), (String)",");
        this.assertConfigurationNotPresentForOptionalMultiple("comma.string");
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testBackslashCommaStringGetValueArray() {
        String[] values = (String[])this.config.getValue("backslash.comma.string", String[].class);
    }

    @Test
    public void testBackslashCommaStringGetValue() {
        String value = (String)this.config.getValue("backslash.comma.string", String.class);
        Assert.assertEquals((String)value, (String)"\\,");
    }

    @Test
    public void testBackslashCommaStringGetOptionalValue() {
        Assert.assertEquals((String)((String)this.config.getOptionalValue("backslash.comma.string", String.class).get()), (String)"\\,");
        this.assertConfigurationNotPresentForOptionalMultiple("backslash.comma.string");
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testDoubleCommaStringGetValueArray() {
        String[] values = (String[])this.config.getValue("double.comma.string", String[].class);
    }

    @Test
    public void testDoubleCommaStringGetValue() {
        String value = (String)this.config.getValue("double.comma.string", String.class);
        Assert.assertEquals((String)value, (String)",,");
    }

    @Test
    public void testDoubleCommaStringGetOptionalValues() {
        Assert.assertEquals((String)((String)this.config.getOptionalValue("double.comma.string", String.class).get()), (String)",,");
        this.assertConfigurationNotPresentForOptionalMultiple("double.comma.string");
    }

    @Test
    public void testFooBarStringGetValueArray() {
        Object[] values = (String[])this.config.getValue("foo.bar.string", String[].class);
        Assert.assertEquals((Object[])values, (Object[])new String[]{"foo", "bar"});
    }

    @Test
    public void testFooBarStringGetValue() {
        String value = (String)this.config.getValue("foo.bar.string", String.class);
        Assert.assertEquals((String)value, (String)"foo,bar");
    }

    @Test
    public void testFooBarStringGetOptionalValues() {
        Assert.assertEquals((String)((String)this.config.getOptionalValue("foo.bar.string", String.class).get()), (String)"foo,bar");
        Assert.assertEquals((Object[])((Object[])this.config.getOptionalValue("foo.bar.string", String[].class).get()), (Object[])new String[]{"foo", "bar"});
        Assert.assertEquals((Collection)((Collection)this.config.getOptionalValues("foo.bar.string", String.class).get()), Arrays.asList("foo", "bar"));
    }

    @Test
    public void testFooCommaStringGetValueArray() {
        Object[] values = (String[])this.config.getValue("foo.comma.string", String[].class);
        Assert.assertEquals((Object[])values, (Object[])new String[]{"foo"});
    }

    @Test
    public void testFooCommaStringGetValue() {
        String value = (String)this.config.getValue("foo.comma.string", String.class);
        Assert.assertEquals((String)value, (String)"foo,");
    }

    @Test
    public void testFooCommaStringGetOptionalValues() {
        Assert.assertEquals((String)((String)this.config.getOptionalValue("foo.comma.string", String.class).get()), (String)"foo,");
        Assert.assertEquals((Object[])((Object[])this.config.getOptionalValue("foo.comma.string", String[].class).get()), (Object[])new String[]{"foo"});
        Assert.assertEquals((Collection)((Collection)this.config.getOptionalValues("foo.comma.string", String.class).get()), Arrays.asList("foo"));
    }

    @Test
    public void testCommaBarStringGetValueArray() {
        Object[] values = (String[])this.config.getValue("comma.bar.string", String[].class);
        Assert.assertEquals((Object[])values, (Object[])new String[]{"bar"});
    }

    @Test
    public void testCommaBarStringGetValue() {
        String value = (String)this.config.getValue("comma.bar.string", String.class);
        Assert.assertEquals((String)value, (String)",bar");
    }

    @Test
    public void testCommaBarStringGetOptionalValues() {
        Assert.assertEquals((String)((String)this.config.getOptionalValue("comma.bar.string", String.class).get()), (String)",bar");
        Assert.assertEquals((Object[])((Object[])this.config.getOptionalValue("comma.bar.string", String[].class).get()), (Object[])new String[]{"bar"});
        Assert.assertEquals((Collection)((Collection)this.config.getOptionalValues("comma.bar.string", String.class).get()), Arrays.asList("bar"));
    }

    @Test
    public void testSpaceStringGetValueArray() {
        Object[] values = (String[])this.config.getValue("space.string", String[].class);
        Assert.assertEquals((Object[])values, (Object[])new String[]{" "});
    }

    @Test
    public void testSpaceStringGetValue() {
        String value = (String)this.config.getValue("space.string", String.class);
        Assert.assertEquals((String)value, (String)" ");
    }

    @Test
    public void testSpaceStringGetOptionalValue() {
        Assert.assertEquals((String)((String)this.config.getOptionalValue("space.string", String.class).get()), (String)" ");
        Assert.assertEquals((Object[])((Object[])this.config.getOptionalValue("space.string", String[].class).get()), (Object[])new String[]{" "});
        Assert.assertEquals((Collection)((Collection)this.config.getOptionalValues("space.string", String.class).get()), Arrays.asList(" "));
    }

    private void assertConfigurationNotPresentForOptionalMultiple(String property) {
        Assert.assertFalse((boolean)this.config.getOptionalValue(property, String[].class).isPresent());
        Assert.assertFalse((boolean)this.config.getOptionalValues(property, String.class).isPresent());
    }

    private void assertConfigurationNotPresentForOptional(String property) {
        Assert.assertFalse((boolean)this.config.getOptionalValue(property, String.class).isPresent());
    }
}

