/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck;

import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.tck.EmptyValuesBean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EmptyValuesTest
extends Arquillian {
    private static final String EMPTY_PROPERTY = "my.empty.property";
    private static final String PROP_FILE_EMPTY_PROPERTY = "my.empty.property.in.config.file";
    public static final StringAsset EMPTY_STRING_ASSET = new StringAsset("my.empty.property.in.config.file=");
    @Inject
    private EmptyValuesBean emptyValuesBean;
    @Inject
    private Config config;

    @Deployment
    public static Archive deployment() {
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"emptyValues.jar")).addClasses(new Class[]{EmptyValuesTest.class, EmptyValuesBean.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsManifestResource((Asset)EMPTY_STRING_ASSET, "microprofile-config.properties");
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsLibrary((Archive)jar)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void testEmptyStringValues() {
        Assert.assertEquals((String)this.emptyValuesBean.getStringValue(), (String)"");
    }

    @Test
    public void testEmptyStringProgrammaticLookup() {
        System.setProperty(EMPTY_PROPERTY, "");
        String stringValue = (String)this.config.getValue(EMPTY_PROPERTY, String.class);
        Assert.assertEquals((String)stringValue, (String)"");
        System.clearProperty(EMPTY_PROPERTY);
    }

    @Test
    public void testEmptyStringPropertyFromConfigFile() {
        String stringValue = (String)this.config.getValue(PROP_FILE_EMPTY_PROPERTY, String.class);
        Assert.assertEquals((String)stringValue, (String)"");
    }
}

