/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.Converter;
import org.eclipse.microprofile.config.tck.ArrayConverterBean;
import org.eclipse.microprofile.config.tck.base.AbstractTest;
import org.eclipse.microprofile.config.tck.converters.Pizza;
import org.eclipse.microprofile.config.tck.converters.PizzaConverter;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ArrayConverterTest
extends Arquillian {
    @Inject
    private Config config;
    @Inject
    private ArrayConverterBean converterBean;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"arrayConverterTest.jar")).addPackage(PizzaConverter.class.getPackage())).addClasses(new Class[]{ArrayConverterTest.class, ArrayConverterBean.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsServiceProvider(Converter.class, new Class[]{PizzaConverter.class})).as(JavaArchive.class);
        AbstractTest.addFile(testJar, "META-INF/microprofile-config.properties");
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"arrayConverterTest.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testBooleanLookupProgrammatically() {
        Object[] value = (Boolean[])this.config.getValue("tck.config.test.javaconfig.converter.booleanvalues", Boolean[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)3);
        Assert.assertEquals((Object[])value, (Object[])new Boolean[]{true, false, true});
    }

    @Test
    public void testBooleanArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyBooleans().length, (int)3);
        Assert.assertEquals((Object[])this.converterBean.getMyBooleans(), (Object[])new Boolean[]{true, false, true});
    }

    @Test
    public void testbooleanArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMybooleans().length, (int)3);
        Assert.assertEquals((Object)this.converterBean.getMybooleans(), (Object)new boolean[]{true, false, true});
    }

    @Test
    public void testbooleanListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyBooleanList().size(), (int)3);
        Assert.assertEquals(this.converterBean.getMyBooleanList(), Arrays.asList(true, false, true));
    }

    @Test
    public void testbooleanSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyBooleanSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyBooleanSet(), new LinkedHashSet<Boolean>(Arrays.asList(true, false, true)));
    }

    @Test
    public void testStringLookupProgrammatically() {
        Object[] value = (String[])this.config.getValue("tck.config.test.javaconfig.converter.stringvalues", String[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)4);
        Assert.assertEquals((Object[])value, (Object[])new String[]{"microservice", "microprofile", "m,f", "microservice"});
    }

    @Test
    public void testStringArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyStrings().length, (int)4);
        Assert.assertEquals((Object[])this.converterBean.getMyStrings(), (Object[])new String[]{"microservice", "microprofile", "m,f", "microservice"});
    }

    @Test
    public void testStringListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyStringList().size(), (int)4);
        Assert.assertEquals(this.converterBean.getMyStringList(), Arrays.asList("microservice", "microprofile", "m,f", "microservice"));
    }

    @Test
    public void testStringSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyStringSet().size(), (int)3);
        Assert.assertEquals(this.converterBean.getMyStringSet(), new LinkedHashSet<String>(Arrays.asList("microservice", "microprofile", "m,f", "microservice")));
    }

    @Test
    public void testIntLookupProgrammatically() {
        Object[] value = (Integer[])this.config.getValue("tck.config.test.javaconfig.converter.integervalues", Integer[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new Integer[]{1234, 9999});
    }

    @Test
    public void testIntArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyInts().length, (int)2);
        Assert.assertEquals((Object[])this.converterBean.getMyInts(), (Object[])new Integer[]{1234, 9999});
    }

    @Test
    public void testintArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyints().length, (int)2);
        Assert.assertEquals((Object)this.converterBean.getMyInts(), (Object)new int[]{1234, 9999});
    }

    @Test
    public void testIntListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyIntList().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyIntList(), Arrays.asList(1234, 9999));
    }

    @Test
    public void testIntSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyIntSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyIntSet(), new LinkedHashSet<Integer>(Arrays.asList(1234, 9999)));
    }

    @Test
    public void testLongLookupProgrammatically() {
        Object[] value = (Long[])this.config.getValue("tck.config.test.javaconfig.converter.longvalues", Long[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new Long[]{1234567890L, 1999999999L});
    }

    @Test
    public void testLongArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyLongs().length, (int)2);
        Assert.assertEquals((Object[])this.converterBean.getMyLongs(), (Object[])new Long[]{1234567890L, 1999999999L});
    }

    @Test
    public void testlongArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMylongs().length, (int)2);
        Assert.assertEquals((Object)this.converterBean.getMylongs(), (Object)new long[]{1234567890L, 1999999999L});
    }

    @Test
    public void testLongListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyLongList().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyLongList(), Arrays.asList(1234567890L, 1999999999L));
    }

    @Test
    public void testLongSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyLongSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyLongSet(), new LinkedHashSet<Long>(Arrays.asList(1234567890L, 1999999999L)));
    }

    @Test
    public void testFloatLookupProgrammatically() {
        Object[] value = (Float[])this.config.getValue("tck.config.test.javaconfig.converter.floatvalues", Float[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new Float[]{Float.valueOf(12.34f), Float.valueOf(99.99f)});
    }

    @Test
    public void testFloatArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyFloats().length, (int)2);
        Assert.assertEquals((Object[])this.converterBean.getMyFloats(), (Object[])new Float[]{Float.valueOf(12.34f), Float.valueOf(99.99f)});
    }

    @Test
    public void testfloatArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyfloats().length, (int)2);
        Assert.assertEquals((Object)this.converterBean.getMyfloats(), (Object)new float[]{12.34f, 99.99f});
    }

    @Test
    public void testFloatListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyFloatList().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyFloatList(), Arrays.asList(Float.valueOf(12.34f), Float.valueOf(99.99f)));
    }

    @Test
    public void testFloatSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyFloatSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyFloatSet(), new LinkedHashSet<Float>(Arrays.asList(Float.valueOf(12.34f), Float.valueOf(99.99f))));
    }

    @Test
    public void testDoubleLookupProgrammatically() {
        Object[] value = (Double[])this.config.getValue("tck.config.test.javaconfig.converter.doublevalues", Double[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new Double[]{12.34, 99.9999});
    }

    @Test
    public void testDoubleArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyDoubles().length, (int)2);
        Assert.assertEquals((Object[])this.converterBean.getMyDoubles(), (Object[])new Double[]{12.34, 99.9999});
    }

    @Test
    public void testdoubleArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMydoubles().length, (int)2);
        Assert.assertEquals((Object)this.converterBean.getMydoubles(), (Object)new double[]{12.34, 99.9999});
    }

    @Test
    public void testDoubleListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyDoubleList().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyDoubleList(), Arrays.asList(12.34, 99.9999));
    }

    @Test
    public void testDoubleSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyDoubleSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyDoubleSet(), new LinkedHashSet<Double>(Arrays.asList(12.34, 99.9999)));
    }

    @Test
    public void testDurationLookupProgrammatically() {
        Object[] value = (Duration[])this.config.getValue("tck.config.test.javaconfig.converter.durationvalues", Duration[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new Duration[]{Duration.parse("PT15M"), Duration.parse("PT20M")});
    }

    @Test
    public void testDurationArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyDurations().length, (int)2);
        Assert.assertEquals((Object[])this.converterBean.getMyDurations(), (Object[])new Duration[]{Duration.parse("PT15M"), Duration.parse("PT20M")});
    }

    @Test
    public void testDurationListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyDurationList().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyDurationList(), Arrays.asList(Duration.parse("PT15M"), Duration.parse("PT20M")));
    }

    @Test
    public void testDurationSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyDurationSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyDurationList(), new LinkedHashSet<Duration>(Arrays.asList(Duration.parse("PT15M"), Duration.parse("PT20M"))));
    }

    @Test
    public void testLocalTimeLookupProgrammatically() {
        Object[] value = (LocalTime[])this.config.getValue("tck.config.test.javaconfig.converter.localtimevalues", LocalTime[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new LocalTime[]{LocalTime.parse("10:37"), LocalTime.parse("11:44")});
    }

    @Test
    public void testLocalTimeArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyLocaltimes().length, (int)2);
        Assert.assertEquals((Object[])this.converterBean.getMyLocaltimes(), (Object[])new LocalTime[]{LocalTime.parse("10:37"), LocalTime.parse("11:44")});
    }

    @Test
    public void testLocalTimeListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyLocalTimeList().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyLocalTimeList(), Arrays.asList(LocalTime.parse("10:37"), LocalTime.parse("11:44")));
    }

    @Test
    public void testLocalTimeSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyLocalTimeSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyLocalTimeSet(), new LinkedHashSet<LocalTime>(Arrays.asList(LocalTime.parse("10:37"), LocalTime.parse("11:44"))));
    }

    @Test
    public void testLocalDateLookupProgrammatically() {
        Object[] value = (LocalDate[])this.config.getValue("tck.config.test.javaconfig.converter.localdatevalues", LocalDate[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new LocalDate[]{LocalDate.parse("2017-12-24"), LocalDate.parse("2017-11-29")});
    }

    @Test
    public void testLocalDateArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyDates().length, (int)2);
        Assert.assertEquals((Object[])this.converterBean.getMyDates(), (Object[])new LocalDate[]{LocalDate.parse("2017-12-24"), LocalDate.parse("2017-11-29")});
    }

    @Test
    public void testLocalDateListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyLocalDateList().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyLocalDateList(), Arrays.asList(LocalDate.parse("2017-12-24"), LocalDate.parse("2017-11-29")));
    }

    @Test
    public void testLocalDateSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyLocalDateSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyLocalDateSet(), new LinkedHashSet<LocalDate>(Arrays.asList(LocalDate.parse("2017-12-24"), LocalDate.parse("2017-11-29"))));
    }

    @Test
    public void testLocalDateTimeLookupProgrammatically() {
        Object[] value = (LocalDateTime[])this.config.getValue("tck.config.test.javaconfig.converter.localdatetimevalues", LocalDateTime[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new LocalDateTime[]{LocalDateTime.parse("2017-12-24T10:25:30"), LocalDateTime.parse("2017-12-24T10:25:33")});
    }

    @Test
    public void testLocalDateTimeArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyLocalDateTimes().length, (int)2);
        Assert.assertEquals((Object[])this.converterBean.getMyLocalDateTimes(), (Object[])new LocalDateTime[]{LocalDateTime.parse("2017-12-24T10:25:30"), LocalDateTime.parse("2017-12-24T10:25:33")});
    }

    @Test
    public void testLocalDateTimeListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyLocalDateTimeList().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyLocalDateTimeList(), Arrays.asList(LocalDateTime.parse("2017-12-24T10:25:30"), LocalDateTime.parse("2017-12-24T10:25:33")));
    }

    @Test
    public void testLocalDateTimeSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyLocalDateTimeSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyLocalDateTimeList(), new LinkedHashSet<LocalDateTime>(Arrays.asList(LocalDateTime.parse("2017-12-24T10:25:30"), LocalDateTime.parse("2017-12-24T10:25:33"))));
    }

    @Test
    public void testOffsetDateTimeLookupProgrammatically() {
        Object[] value = (OffsetDateTime[])this.config.getValue("tck.config.test.javaconfig.converter.offsetdatetimevalues", OffsetDateTime[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new OffsetDateTime[]{OffsetDateTime.parse("2007-12-03T10:15:30+01:00"), OffsetDateTime.parse("2007-12-03T10:15:30+02:00")});
    }

    @Test
    public void testOffsetDateTimeArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyOffsetDateTimes().length, (int)2);
        Assert.assertEquals((Object[])this.converterBean.getMyOffsetDateTimes(), (Object[])new OffsetDateTime[]{OffsetDateTime.parse("2007-12-03T10:15:30+01:00"), OffsetDateTime.parse("2007-12-03T10:15:30+02:00")});
    }

    @Test
    public void testOffsetDateTimeListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyOffsetDateTimeList().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyOffsetDateTimeList(), Arrays.asList(OffsetDateTime.parse("2007-12-03T10:15:30+01:00"), OffsetDateTime.parse("2007-12-03T10:15:30+02:00")));
    }

    @Test
    public void testOffsetDateTimeSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyOffsetDateTimeSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyOffsetDateTimeSet(), new LinkedHashSet<OffsetDateTime>(Arrays.asList(OffsetDateTime.parse("2007-12-03T10:15:30+01:00"), OffsetDateTime.parse("2007-12-03T10:15:30+02:00"))));
    }

    @Test
    public void testOffsetTimeLookupProgrammatically() {
        Object[] value = (OffsetTime[])this.config.getValue("tck.config.test.javaconfig.converter.offsettimevalues", OffsetTime[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new OffsetTime[]{OffsetTime.parse("13:45:30.123456789+02:00"), OffsetTime.parse("13:45:30.123456789+03:00")});
    }

    @Test
    public void testOffsetTimeArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyOffsetTimes().length, (int)2);
        Assert.assertEquals((Object[])this.converterBean.getMyOffsetTimes(), (Object[])new OffsetTime[]{OffsetTime.parse("13:45:30.123456789+02:00"), OffsetTime.parse("13:45:30.123456789+03:00")});
    }

    @Test
    public void testOffsetTimeListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyOffsetTimeList().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyOffsetTimeList(), Arrays.asList(OffsetTime.parse("13:45:30.123456789+02:00"), OffsetTime.parse("13:45:30.123456789+03:00")));
    }

    @Test
    public void testOffsetTimeSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyOffsetTimeSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyOffsetTimeList(), new LinkedHashSet<OffsetTime>(Arrays.asList(OffsetTime.parse("13:45:30.123456789+02:00"), OffsetTime.parse("13:45:30.123456789+03:00"))));
    }

    @Test
    public void testInstantLookupProgrammatically() {
        Object[] value = (Instant[])this.config.getValue("tck.config.test.javaconfig.converter.instantvalues", Instant[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)2);
        Assert.assertEquals((Object[])value, (Object[])new Instant[]{Instant.parse("2015-06-02T21:34:33.616Z"), Instant.parse("2017-06-02T21:34:33.616Z")});
    }

    @Test
    public void testInstantArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyInstants().length, (int)2);
        Assert.assertEquals((Object[])this.converterBean.getMyInstants(), (Object[])new Instant[]{Instant.parse("2015-06-02T21:34:33.616Z"), Instant.parse("2017-06-02T21:34:33.616Z")});
    }

    @Test
    public void testInstantListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyInstantList().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyInstantList(), Arrays.asList(Instant.parse("2015-06-02T21:34:33.616Z"), Instant.parse("2017-06-02T21:34:33.616Z")));
    }

    @Test
    public void testInstantSetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyInstantSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyInstantList(), new LinkedHashSet<Instant>(Arrays.asList(Instant.parse("2015-06-02T21:34:33.616Z"), Instant.parse("2017-06-02T21:34:33.616Z"))));
    }

    @Test
    public void testUrlLookupProgrammatically() throws MalformedURLException {
        Object[] value = (URL[])this.config.getValue("tck.config.test.javaconfig.converter.urlvalues", URL[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)3);
        Assert.assertEquals((Object[])value, (Object[])new URL[]{new URL("http://microprofile.io"), new URL("http://openliberty.io"), new URL("http://microprofile.io")});
    }

    @Test
    public void testUrlArrayInjection() throws MalformedURLException {
        Assert.assertEquals((int)this.converterBean.getMyUrls().length, (int)3);
        Assert.assertEquals((Object[])this.converterBean.getMyUrls(), (Object[])new URL[]{new URL("http://microprofile.io"), new URL("http://openliberty.io"), new URL("http://microprofile.io")});
    }

    @Test
    public void testURLListInjection() throws MalformedURLException {
        Assert.assertEquals((int)this.converterBean.getMyUrlList().size(), (int)3);
        Assert.assertEquals(this.converterBean.getMyUrlList(), Arrays.asList(new URL("http://microprofile.io"), new URL("http://openliberty.io"), new URL("http://microprofile.io")));
    }

    @Test
    public void testURLSetInjection() throws MalformedURLException {
        Assert.assertEquals((int)this.converterBean.getMyUrlSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyUrlSet(), new LinkedHashSet<URL>(Arrays.asList(new URL("http://openliberty.io"), new URL("http://microprofile.io"))));
    }

    @Test
    public void testUriLookupProgrammatically() {
        Object[] value = (URI[])this.config.getValue("tck.config.test.javaconfig.converter.urlvalues", URI[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)3);
        Assert.assertEquals((Object[])value, (Object[])new URI[]{URI.create("http://microprofile.io"), URI.create("http://openliberty.io"), URI.create("http://microprofile.io")});
    }

    @Test
    public void testUriArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getMyUris().length, (int)3);
        Assert.assertEquals((Object[])this.converterBean.getMyUris(), (Object[])new URI[]{URI.create("http://microprofile.io"), URI.create("http://openliberty.io"), URI.create("http://microprofile.io")});
    }

    @Test
    public void testURIListInjection() {
        Assert.assertEquals((int)this.converterBean.getMyUriList().size(), (int)3);
        Assert.assertEquals(this.converterBean.getMyUriList(), Arrays.asList(URI.create("http://microprofile.io"), URI.create("http://openliberty.io"), URI.create("http://microprofile.io")));
    }

    @Test
    public void testURISetInjection() {
        Assert.assertEquals((int)this.converterBean.getMyUriSet().size(), (int)2);
        Assert.assertEquals(this.converterBean.getMyUriSet(), new LinkedHashSet<URI>(Arrays.asList(URI.create("http://openliberty.io"), URI.create("http://microprofile.io"))));
    }

    @Test
    public void testCustomTypeArrayLookupProgrammatically() {
        Object[] value = (Pizza[])this.config.getValue("tck.config.test.javaconfig.converter.array.pizza", Pizza[].class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((int)value.length, (int)3);
        Assert.assertEquals((Object[])value, (Object[])new Pizza[]{new Pizza("cheese,mushroom", "large"), new Pizza("chicken", "medium"), new Pizza("pepperoni", "small")});
    }

    @Test
    public void testCustomTypeArrayInjection() {
        Assert.assertEquals((int)this.converterBean.getPizzas().length, (int)3);
        Assert.assertEquals((Object[])this.converterBean.getPizzas(), (Object[])new Pizza[]{new Pizza("cheese,mushroom", "large"), new Pizza("chicken", "medium"), new Pizza("pepperoni", "small")});
    }

    @Test
    public void testCustomTypeListInjection() {
        Assert.assertEquals((int)this.converterBean.getPizzaList().size(), (int)3);
        Assert.assertEquals(this.converterBean.getPizzaList(), Arrays.asList(new Pizza("cheese,mushroom", "large"), new Pizza("chicken", "medium"), new Pizza("pepperoni", "small")));
    }

    @Test
    public void testCustomTypeSetInjection() {
        Assert.assertEquals((int)this.converterBean.getPizzaSet().size(), (int)3);
        Assert.assertEquals(this.converterBean.getPizzaSet(), new LinkedHashSet<Pizza>(Arrays.asList(new Pizza("cheese,mushroom", "large"), new Pizza("chicken", "medium"), new Pizza("pepperoni", "small"))));
    }
}

