/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck;

import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.eclipse.microprofile.config.spi.Converter;
import org.eclipse.microprofile.config.tck.base.AbstractTest;
import org.eclipse.microprofile.config.tck.configsources.CustomConfigSourceProvider;
import org.eclipse.microprofile.config.tck.configsources.CustomDbConfigSource;
import org.eclipse.microprofile.config.tck.converters.Donald;
import org.eclipse.microprofile.config.tck.converters.Duck;
import org.eclipse.microprofile.config.tck.converters.DuckConverter;
import org.eclipse.microprofile.config.tck.converters.UpperCaseDuckConverter;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConverterTest
extends Arquillian {
    @Inject
    private Config config;
    @Inject
    @ConfigProperty(name="tck.config.test.javaconfig.converter.duckname")
    private Duck namedDuck;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"converterTest.jar")).addClass(ConverterTest.class)).addPackage(CustomDbConfigSource.class.getPackage())).addClasses(new Class[]{DuckConverter.class, Duck.class, Donald.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsServiceProvider(ConfigSource.class, new Class[]{CustomDbConfigSource.class})).addAsServiceProvider(ConfigSourceProvider.class, new Class[]{CustomConfigSourceProvider.class})).addAsServiceProvider(Converter.class, new Class[]{DuckConverter.class})).as(JavaArchive.class);
        AbstractTest.addFile(testJar, "META-INF/microprofile-config.properties");
        AbstractTest.addFile(testJar, "sampleconfig.yaml");
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"converterTest.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testDonaldNotConvertedByDefault() {
        this.config.getValue("tck.config.test.javaconfig.converter.donaldname", Donald.class);
    }

    @Test
    public void testDonaldConversionWithLambdaConverter() {
        Config newConfig = ConfigProviderResolver.instance().getBuilder().addDefaultSources().withConverter(Donald.class, 100, s -> Donald.iLikeDonald(s)).build();
        Donald donald = (Donald)newConfig.getValue("tck.config.test.javaconfig.converter.donaldname", Donald.class);
        Assert.assertNotNull((Object)donald);
        Assert.assertEquals((String)donald.getName(), (String)"Duck");
    }

    @Test
    public void testDonaldConversionWithMultipleLambdaConverters() {
        Config config1 = ConfigProviderResolver.instance().getBuilder().addDefaultSources().withConverter(Donald.class, 101, s -> Donald.iLikeDonald(s.toUpperCase())).withConverter(Donald.class, 100, s -> Donald.iLikeDonald(s)).build();
        Config config2 = ConfigProviderResolver.instance().getBuilder().addDefaultSources().withConverter(Donald.class, 100, s -> Donald.iLikeDonald(s)).withConverter(Donald.class, 101, s -> Donald.iLikeDonald(s.toUpperCase())).build();
        Donald donald = (Donald)config1.getValue("tck.config.test.javaconfig.converter.donaldname", Donald.class);
        Assert.assertNotNull((Object)donald);
        Assert.assertEquals((String)donald.getName(), (String)"DUCK", (String)"The converter with the highest priority (using upper case) must be used.");
        donald = (Donald)config2.getValue("tck.config.test.javaconfig.converter.donaldname", Donald.class);
        Assert.assertNotNull((Object)donald);
        Assert.assertEquals((String)donald.getName(), (String)"DUCK", (String)"The converter with the highest priority (using upper case) must be used.");
    }

    @Test
    public void testInteger() {
        Integer value = (Integer)this.config.getValue("tck.config.test.javaconfig.converter.integervalue", Integer.class);
        Assert.assertEquals((Object)value, (Object)1234);
    }

    @Test
    public void testInt() {
        int value = (Integer)this.config.getValue("tck.config.test.javaconfig.converter.integervalue", Integer.TYPE);
        Assert.assertEquals((int)value, (int)1234);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInteger_Broken() {
        Integer value = (Integer)this.config.getValue("tck.config.test.javaconfig.converter.integervalue.broken", Integer.class);
    }

    @Test
    public void testLong() {
        Long value = (Long)this.config.getValue("tck.config.test.javaconfig.converter.longvalue", Long.class);
        Assert.assertEquals((Object)value, (Object)1234567890L);
    }

    @Test
    public void testlong() {
        long primitiveValue = (Long)this.config.getValue("tck.config.test.javaconfig.converter.longvalue", Long.TYPE);
        Assert.assertEquals((long)primitiveValue, (long)1234567890L);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testLong_Broken() {
        this.config.getValue("tck.config.test.javaconfig.converter.longvalue.broken", Long.class);
    }

    @Test
    public void testFloat() {
        Float value = (Float)this.config.getValue("tck.config.test.javaconfig.converter.floatvalue", Float.class);
        Assert.assertEquals((Object)value, (Object)Float.valueOf(12.34f));
    }

    @Test
    public void testfloat() {
        float value = ((Float)this.config.getValue("tck.config.test.javaconfig.converter.floatvalue", Float.TYPE)).floatValue();
        Assert.assertEquals((Object)Float.valueOf(value), (Object)Float.valueOf(12.34f));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testFloat_Broken() {
        this.config.getValue("tck.config.test.javaconfig.converter.floatvalue.broken", Float.class);
    }

    @Test
    public void testDouble() {
        Double value = (Double)this.config.getValue("tck.config.test.javaconfig.converter.doublevalue", Double.class);
        Assert.assertEquals((Object)value, (Object)12.34);
    }

    @Test
    public void testdouble() {
        double value = (Double)this.config.getValue("tck.config.test.javaconfig.converter.doublevalue", Double.TYPE);
        Assert.assertEquals((Object)value, (Object)12.34);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testDouble_Broken() {
        Double value = (Double)this.config.getValue("tck.config.test.javaconfig.converter.doublevalue.broken", Double.class);
    }

    @Test
    public void testDuration() {
        Duration value = (Duration)this.config.getValue("tck.config.test.javaconfig.converter.durationvalue", Duration.class);
        Assert.assertEquals((Object)value, (Object)Duration.parse("PT15M"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testDuration_Broken() {
        Duration value = (Duration)this.config.getValue("tck.config.test.javaconfig.converter.durationvalue.broken", Duration.class);
    }

    @Test
    public void testLocalTime() {
        LocalTime value = (LocalTime)this.config.getValue("tck.config.test.javaconfig.converter.localtimevalue", LocalTime.class);
        Assert.assertEquals((Object)value, (Object)LocalTime.parse("10:37"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testLocalTime_Broken() {
        LocalTime value = (LocalTime)this.config.getValue("tck.config.test.javaconfig.converter.localtimevalue.broken", LocalTime.class);
    }

    @Test
    public void testLocalDate() {
        LocalDate value = (LocalDate)this.config.getValue("tck.config.test.javaconfig.converter.localdatevalue", LocalDate.class);
        Assert.assertEquals((Object)value, (Object)LocalDate.parse("2017-12-24"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testLocalDate_Broken() {
        LocalDate value = (LocalDate)this.config.getValue("tck.config.test.javaconfig.converter.localdatevalue.broken", LocalDate.class);
    }

    @Test
    public void testLocalDateTime() {
        LocalDateTime value = (LocalDateTime)this.config.getValue("tck.config.test.javaconfig.converter.localdatetimevalue", LocalDateTime.class);
        Assert.assertEquals((Object)value, (Object)LocalDateTime.parse("2017-12-24T10:25:30"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testLocalDateTime_Broken() {
        LocalDateTime value = (LocalDateTime)this.config.getValue("tck.config.test.javaconfig.converter.localdatetimevalue.broken", LocalDateTime.class);
    }

    @Test
    public void testOffsetDateTime() {
        OffsetDateTime value = (OffsetDateTime)this.config.getValue("tck.config.test.javaconfig.converter.offsetdatetimevalue", OffsetDateTime.class);
        Assert.assertEquals((Object)value, (Object)OffsetDateTime.parse("2007-12-03T10:15:30+01:00"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testOffsetDateTime_Broken() {
        OffsetDateTime value = (OffsetDateTime)this.config.getValue("tck.config.test.javaconfig.converter.offsetdatetimevalue.broken", OffsetDateTime.class);
    }

    @Test
    public void testOffsetTime() {
        OffsetTime value = (OffsetTime)this.config.getValue("tck.config.test.javaconfig.converter.offsettimevalue", OffsetTime.class);
        OffsetTime parsed = OffsetTime.parse("13:45:30.123456789+02:00");
        Assert.assertEquals((Object)value, (Object)parsed);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testOffsetTime_Broken() {
        OffsetTime value = (OffsetTime)this.config.getValue("tck.config.test.javaconfig.converter.offsettimevalue.broken", OffsetTime.class);
    }

    @Test
    public void testInstant() {
        Instant value = (Instant)this.config.getValue("tck.config.test.javaconfig.converter.instantvalue", Instant.class);
        Assert.assertEquals((Object)value, (Object)Instant.parse("2015-06-02T21:34:33.616Z"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInstant_Broken() {
        Instant value = (Instant)this.config.getValue("tck.config.test.javaconfig.converter.instantvalue.broken", Instant.class);
    }

    @Test
    public void testBoolean() {
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.true", Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.true", Boolean.TYPE)));
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.true_uppercase", Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.true_mixedcase", Boolean.class)));
        Assert.assertFalse((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.false", Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.one", Boolean.class)));
        Assert.assertFalse((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.zero", Boolean.class)));
        Assert.assertFalse((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.seventeen", Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.yes", Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.yes_uppercase", Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.yes_mixedcase", Boolean.class)));
        Assert.assertFalse((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.no", Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.y", Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.y_uppercase", Boolean.class)));
        Assert.assertFalse((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.n", Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.on", Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.on_uppercase", Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.on_mixedcase", Boolean.class)));
        Assert.assertFalse((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.off", Boolean.class)));
        Assert.assertFalse((boolean)((Boolean)this.config.getValue("tck.config.test.javaconfig.configvalue.boolean.off", Boolean.TYPE)));
    }

    @Test
    public void testCustomConverter() {
        Assert.assertEquals((String)this.namedDuck.getName(), (String)"Hannelore");
    }

    @Test
    public void testDuckConversionWithMultipleConverters() {
        Config config1 = ConfigProviderResolver.instance().getBuilder().addDefaultSources().withConverters(new Converter[]{new UpperCaseDuckConverter(), new DuckConverter()}).build();
        Config config2 = ConfigProviderResolver.instance().getBuilder().addDefaultSources().withConverters(new Converter[]{new DuckConverter(), new UpperCaseDuckConverter()}).build();
        Duck duck = (Duck)config1.getValue("tck.config.test.javaconfig.converter.duckname", Duck.class);
        Assert.assertNotNull((Object)duck);
        Assert.assertEquals((String)duck.getName(), (String)"HANNELORE", (String)"The converter with the highest priority (UpperCaseDuckConverter) must be used.");
        duck = (Duck)config2.getValue("tck.config.test.javaconfig.converter.duckname", Duck.class);
        Assert.assertNotNull((Object)duck);
        Assert.assertEquals((String)duck.getName(), (String)"HANNELORE", (String)"The converter with the highest priority (UpperCaseDuckConverter) must be used.");
    }

    @Test
    public void testURLConverter() throws MalformedURLException {
        URL url = (URL)this.config.getValue("tck.config.test.javaconfig.converter.urlvalue", URL.class);
        Assert.assertEquals((Object)url, (Object)new URL("http://microprofile.io"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testURLConverterBroken() throws Exception {
        URL ignored = (URL)this.config.getValue("tck.config.test.javaconfig.converter.urlvalue.broken", URL.class);
    }
}

