/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.config.tck.base.AbstractTest;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ClassConverterTest
extends Arquillian {
    @Inject
    private Config config;
    @Inject
    private ClassConverterBean classConverterBean;

    @Deployment
    public static WebArchive deploy() {
        String archiveName = ClassConverterTest.class.getSimpleName();
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)(archiveName + ".jar"))).addClasses(new Class[]{ClassConverterBean.class, ClassConverterTest.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        AbstractTest.addFile(testJar, "META-INF/microprofile-config.properties");
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(archiveName + ".war"))).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testClassConverterWithLookup() {
        Class testClass = (Class)this.config.getValue("tck.config.test.javaconfig.converter.class", Class.class);
        Assert.assertEquals((Object)testClass, ClassConverterTest.class);
        Object[] testClasses = (Class[])this.config.getValue("tck.config.test.javaconfig.converter.class.array", Class[].class);
        Assert.assertEquals((int)testClasses.length, (int)2);
        Assert.assertEquals((Object[])testClasses, (Object[])new Class[]{ClassConverterTest.class, String.class});
    }

    @Test
    public void testConverterForClassLoadedInBean() {
        Assert.assertEquals((Object)this.classConverterBean.testClass, ClassConverterTest.class);
        Assert.assertEquals((int)this.classConverterBean.testClasses.length, (int)2);
        Assert.assertEquals((Object[])this.classConverterBean.testClasses, (Object[])new Class[]{ClassConverterTest.class, String.class});
        Assert.assertEquals((int)this.classConverterBean.testClassSet.size(), (int)2);
        Assert.assertEquals((Set)this.classConverterBean.testClassSet, new LinkedHashSet<Class>(Arrays.asList(ClassConverterTest.class, String.class)));
        Assert.assertEquals((int)this.classConverterBean.testClassList.size(), (int)2);
        Assert.assertEquals((Collection)this.classConverterBean.testClassList, Arrays.asList(ClassConverterTest.class, String.class));
    }

    @Dependent
    public static class ClassConverterBean {
        @Inject
        @ConfigProperty(name="tck.config.test.javaconfig.converter.class")
        private Class testClass;
        @Inject
        @ConfigProperty(name="tck.config.test.javaconfig.converter.class.array")
        private Class[] testClasses;
        @Inject
        @ConfigProperty(name="tck.config.test.javaconfig.converter.class.array")
        private Set<Class> testClassSet;
        @Inject
        @ConfigProperty(name="tck.config.test.javaconfig.converter.class.array")
        private List<Class> testClassList;
    }
}

