/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck;

import java.time.YearMonth;
import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.tck.ParseConverterInjection;
import org.eclipse.microprofile.config.tck.base.AbstractTest;
import org.eclipse.microprofile.config.tck.converters.implicit.ConvTestTypeWCharSequenceParse;
import org.eclipse.microprofile.config.tck.converters.implicit.ConvTestTypeWStringCt;
import org.eclipse.microprofile.config.tck.converters.implicit.ConvTestTypeWStringValueOf;
import org.eclipse.microprofile.config.tck.converters.implicit.SomeEnumToConvert;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ImplicitConverterTest
extends Arquillian {
    @Inject
    private Config config;
    @Inject
    private ParseConverterInjection parserConverterInjection;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"implicitConverterTest.jar")).addPackage(ConvTestTypeWStringCt.class.getPackage())).addClasses(new Class[]{ParseConverterInjection.class, ImplicitConverterTest.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        AbstractTest.addFile(testJar, "META-INF/microprofile-config.properties");
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"implicitConverterTest.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testImplicitConverterStringCt() {
        ConvTestTypeWStringCt value = (ConvTestTypeWStringCt)this.config.getValue("tck.config.test.javaconfig.converter.implicit.stringCt", ConvTestTypeWStringCt.class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((String)value.getVal(), (String)"stringCt");
    }

    @Test
    public void testImplicitConverterStringValueOf() {
        ConvTestTypeWStringValueOf value = (ConvTestTypeWStringValueOf)this.config.getValue("tck.config.test.javaconfig.converter.implicit.stringValueOf", ConvTestTypeWStringValueOf.class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((String)value.getVal(), (String)"stringValueOf");
    }

    @Test
    public void testImplicitConverterCharSequenceParse() {
        ConvTestTypeWCharSequenceParse value = (ConvTestTypeWCharSequenceParse)this.config.getValue("tck.config.test.javaconfig.converter.implicit.charSequenceParse", ConvTestTypeWCharSequenceParse.class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((String)value.getVal(), (String)"charSequenceParse");
    }

    @Test
    public void testImplicitConverterCharSequenceParseJavaTime() {
        YearMonth value = (YearMonth)this.config.getValue("tck.config.test.javaconfig.converter.implicit.charSequenceParse.yearmonth", YearMonth.class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)value, (Object)YearMonth.parse("2017-12"));
    }

    @Test
    public void testImplicitConverterCharSequenceParseJavaTimeInjection() {
        Assert.assertNotNull((Object)this.parserConverterInjection.getYearMonth());
        Assert.assertEquals((Object)this.parserConverterInjection.getYearMonth(), (Object)YearMonth.parse("2017-12"));
    }

    @Test
    public void testImplicitConverterEnumValueOf() {
        SomeEnumToConvert value = (SomeEnumToConvert)((Object)this.config.getValue("tck.config.test.javaconfig.converter.implicit.enumValueOf", SomeEnumToConvert.class));
        Assert.assertNotNull((Object)((Object)value));
        Assert.assertEquals((Object)((Object)value), (Object)((Object)SomeEnumToConvert.BAZ));
        Assert.assertEquals((String)value.name(), (String)"BAZ");
    }
}

