/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.trs.client.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.jena.rdf.model.Model;
import org.eclipse.lyo.client.OslcClient;
import org.eclipse.lyo.core.trs.Base;
import org.eclipse.lyo.core.trs.ChangeLog;
import org.eclipse.lyo.core.trs.Page;
import org.eclipse.lyo.core.trs.TrackedResourceSet;
import org.eclipse.lyo.oslc4j.core.exception.LyoModelException;
import org.eclipse.lyo.trs.client.exceptions.RepresentationRetrievalException;
import org.eclipse.lyo.trs.client.exceptions.TrsEndpointConfigException;
import org.eclipse.lyo.trs.client.exceptions.TrsEndpointErrorException;
import org.eclipse.lyo.trs.client.util.ClientUtil;
import org.eclipse.lyo.trs.client.util.ITrackedResourceClient;
import org.eclipse.lyo.trs.client.util.ProviderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackedResourceClient
implements ITrackedResourceClient {
    private static final Logger log = LoggerFactory.getLogger(TrackedResourceClient.class);
    private final OslcClient oslcClient;

    public TrackedResourceClient(OslcClient oslcClient) {
        this.oslcClient = oslcClient;
    }

    @Override
    public Model fetchTRSRemoteResource(URI uri) throws RepresentationRetrievalException {
        Response response = this.oslcClient.getResource(uri.toString());
        try {
            Model resource = (Model)ClientUtil.extractResourceFromResponse(response, Model.class);
            response.close();
            if (resource != null) {
                return resource;
            }
            throw new RepresentationRetrievalException("Empty model was retrieved");
        }
        catch (TrsEndpointConfigException e) {
            log.error("Bad request", (Throwable)e);
            throw new RepresentationRetrievalException(e);
        }
        catch (TrsEndpointErrorException e) {
            log.warn("Failed to fetch {}", (Object)uri);
            log.debug("Server error", (Throwable)e);
            throw new RepresentationRetrievalException(e);
        }
        catch (LyoModelException e) {
            log.debug("Error reading Jena Model from the response");
            throw new RepresentationRetrievalException(e);
        }
    }

    @Override
    public List<Base> updateBases(TrackedResourceSet updatedTrs) throws LyoModelException, RepresentationRetrievalException {
        URI currentPageUri;
        ArrayList<Base> bases = new ArrayList<Base>();
        URI firstBasePageUri = updatedTrs.getBase();
        Base currentBase = this.fetchRemoteBase(firstBasePageUri);
        Page nextPage = currentBase.getNextPage();
        bases.add(currentBase);
        while (nextPage != null && !ProviderUtil.isNilUri(currentPageUri = nextPage.getNextPage())) {
            currentBase = this.fetchRemoteBase(currentPageUri);
            bases.add(currentBase);
            nextPage = currentBase.getNextPage();
        }
        return bases;
    }

    @Override
    public TrackedResourceSet extractRemoteTrs(URI trsUri) throws LyoModelException, RepresentationRetrievalException {
        Model rdfModel = this.fetchTRSRemoteResource(trsUri);
        return ClientUtil.extractTrsFromRdfModel(rdfModel);
    }

    @Override
    public ChangeLog fetchRemoteChangeLog(URI changeLogURl) throws IllegalArgumentException, SecurityException, LyoModelException, RepresentationRetrievalException {
        Model rdfModel = this.fetchTRSRemoteResource(changeLogURl);
        return ClientUtil.extractChangeLogFromRdfModel(rdfModel);
    }

    @Override
    public Base fetchRemoteBase(URI baseUrl) throws LyoModelException, RepresentationRetrievalException {
        Model rdFModel = this.fetchTRSRemoteResource(baseUrl);
        return ClientUtil.extractBaseFromRdfModel(rdFModel);
    }
}

