/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.trs.client.handlers;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.vocabulary.RDF;
import org.eclipse.lyo.core.trs.Base;
import org.eclipse.lyo.core.trs.ChangeEvent;
import org.eclipse.lyo.core.trs.ChangeLog;
import org.eclipse.lyo.core.trs.Deletion;
import org.eclipse.lyo.core.trs.TrackedResourceSet;
import org.eclipse.lyo.trs.client.exceptions.ServerRollBackException;
import org.eclipse.lyo.trs.client.handlers.IProviderEventHandler;
import org.eclipse.lyo.trs.client.handlers.IProviderHandler;
import org.eclipse.lyo.trs.client.model.BaseMember;
import org.eclipse.lyo.trs.client.model.ChangeEventMessageTR;
import org.eclipse.lyo.trs.client.util.ITrackedResourceClient;
import org.eclipse.lyo.trs.client.util.ProviderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrsProviderHandler
implements IProviderHandler {
    private static final Logger log = LoggerFactory.getLogger(TrsProviderHandler.class);
    private final ITrackedResourceClient trsClient;
    private final IProviderEventHandler handler;
    private URI lastProcessedChangeEventUri;
    private URI trsUriBase;

    public TrsProviderHandler(URI trsUriBase, ITrackedResourceClient trsClient, IProviderEventHandler handler) {
        this.trsUriBase = trsUriBase;
        this.trsClient = trsClient;
        this.handler = handler;
    }

    public String toString() {
        return "TrsProviderHandler{trsUriBase='" + this.trsUriBase + '\'' + '}';
    }

    @Override
    public void update() {
        try {
            this.pollAndProcessChanges();
        }
        catch (Exception e) {
            log.warn("Force rebase");
            this.lastProcessedChangeEventUri = null;
            this.handler.rebase();
        }
    }

    private void processChangeEvent(ChangeEvent changeEvent) {
        URI changed = changeEvent.getChanged();
        log.info("processing resource " + changed.toString() + " change event ");
        Model trsResourceModel = null;
        if (!(changeEvent instanceof Deletion)) {
            trsResourceModel = this.trsClient.fetchTRSRemoteResource(changed);
        }
        ChangeEventMessageTR eventMessageTR = new ChangeEventMessageTR(changeEvent, trsResourceModel);
        this.handler.handleChangeEvent(eventMessageTR);
        log.info("finished processing resource " + changed.toString() + " change event ");
    }

    private void pollAndProcessChanges() {
        log.info("started dealing with TRS Provider: " + this.trsUriBase);
        TrackedResourceSet updatedTrs = this.trsClient.extractRemoteTrs(this.trsUriBase);
        boolean indexingStage = false;
        List<URI> baseMembers = new ArrayList<URI>();
        if (this.lastProcessedChangeEventUri == null) {
            List<Base> bases = this.trsClient.updateBases(updatedTrs);
            for (Base base : bases) {
                baseMembers.addAll(base.getMembers());
            }
            this.lastProcessedChangeEventUri = bases.get(0).getCutoffEvent();
            indexingStage = true;
        }
        List<ChangeLog> changeLogs = this.fetchUpdatedChangeLogs(updatedTrs);
        List<ChangeEvent> compressedChanges = ProviderUtil.optimizedChangesList(changeLogs, this.lastProcessedChangeEventUri);
        if (indexingStage) {
            baseMembers = ProviderUtil.baseChangeEventsOptimizationSafe(compressedChanges, baseMembers);
            for (URI baseMemberUri : baseMembers) {
                log.debug("Fetching TRS base from {}", (Object)baseMemberUri);
                Model baseResourceModel = this.trsClient.fetchTRSRemoteResource(baseMemberUri);
                log.debug("Processing base member '{}' creation event", (Object)baseMemberUri);
                BaseMember baseMember = new BaseMember(baseMemberUri, baseResourceModel);
                this.handler.handleBaseMember(baseMember);
                log.trace("Finished processing base member '{}' creation event", (Object)baseMemberUri);
            }
        }
        for (ChangeEvent changeEvent : compressedChanges) {
            try {
                this.processChangeEvent(changeEvent);
                this.lastProcessedChangeEventUri = changeEvent.getAbout();
            }
            catch (Exception e) {
                log.error("Error processing {}: ", (Object)changeEvent, (Object)e);
                return;
            }
        }
        this.handler.finishCycle();
        log.info("finished dealing with TRS Provider: " + this.trsUriBase);
    }

    @Deprecated
    protected void baseChangeEventsOptimization(List<ChangeEvent> compressedChangesList, List<URI> baseMembers) {
        for (ChangeEvent changeEvent : compressedChangesList) {
            URI changedResource = changeEvent.getChanged();
            if (!baseMembers.contains(changedResource)) continue;
            log.debug("Removing '{}' from the base because it is already in the changelog", (Object)changeEvent);
            baseMembers.remove(changedResource);
        }
    }

    private List<ChangeLog> fetchUpdatedChangeLogs(TrackedResourceSet updatedTrs) {
        ArrayList<ChangeLog> changeLogs;
        ChangeLog firstChangeLog = updatedTrs.getChangeLog();
        boolean foundSyncEvent = this.fetchRemoteChangeLogs(firstChangeLog, changeLogs = new ArrayList<ChangeLog>());
        if (!foundSyncEvent) {
            this.lastProcessedChangeEventUri = null;
            throw new ServerRollBackException("The sync event can not be found. The sever provinding the trs at: " + this.trsUriBase + " seems to have been rollecd back to a previous state");
        }
        return changeLogs;
    }

    private boolean fetchRemoteChangeLogs(ChangeLog currentChangeLog, List<ChangeLog> changeLogs) {
        boolean foundChangeEvent = false;
        while (currentChangeLog != null) {
            changeLogs.add(currentChangeLog);
            if (ProviderUtil.changeLogContainsEvent(this.lastProcessedChangeEventUri, currentChangeLog)) {
                foundChangeEvent = true;
                break;
            }
            URI previousChangeLog = currentChangeLog.getPrevious();
            currentChangeLog = this.trsClient.fetchRemoteChangeLog(previousChangeLog);
            if (!RDF.nil.getURI().equals(previousChangeLog.toString())) continue;
        }
        return foundChangeEvent;
    }
}

