/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.trs.client.config;

import com.google.common.base.Strings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import org.eclipse.lyo.trs.client.config.TrsProviderConfiguration;

public class TrsConfigurationLoader {
    public static TrsProviderConfiguration from(File f) throws IOException {
        if (f == null) {
            throw new IllegalArgumentException("File is null");
        }
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(f));
        Properties p = new Properties();
        p.load(input);
        String trsUriParam = p.getProperty("trs_uri");
        if (Strings.isNullOrEmpty((String)trsUriParam)) {
            throw new IllegalStateException("The 'trs_uri' field is missing in file " + f.getName());
        }
        String user = p.getProperty("baseAuth_user");
        String pass = p.getProperty("baseAuth_pwd");
        return new TrsProviderConfiguration(URI.create(trsUriParam), user, pass);
    }
}

