/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.server.ui.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.lyo.core.util.StringUtils;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRepresentation;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.Representation;
import org.eclipse.lyo.oslc4j.core.model.ValueType;
import org.eclipse.lyo.server.ui.model.Link;
import org.eclipse.lyo.server.ui.model.Preview;
import org.eclipse.lyo.server.ui.model.Property;
import org.eclipse.lyo.server.ui.model.PropertyDefintion;
import org.eclipse.lyo.server.ui.model.PropertyValue;

public class PreviewFactory {
    public static Preview getPreview(AbstractResource aResource, List<String> getterMethodNames, boolean showPropertyHeadingsAsLinks) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ArrayList<Property> previewItems = new ArrayList<Property>();
        for (String getterMethodName : getterMethodNames) {
            PropertyValue value;
            Method getterMethod = aResource.getClass().getMethod(getterMethodName, new Class[0]);
            boolean multiple = getterMethod.getAnnotation(OslcOccurs.class).value().equals((Object)Occurs.ZeroOrMany) || getterMethod.getAnnotation(OslcOccurs.class).value().equals((Object)Occurs.OneOrMany);
            boolean isResourceValueType = null != getterMethod.getAnnotation(OslcValueType.class) && getterMethod.getAnnotation(OslcValueType.class).value().equals((Object)ValueType.Resource);
            boolean isNotInlinedRepresentation = null == getterMethod.getAnnotation(OslcRepresentation.class) || null != getterMethod.getAnnotation(OslcRepresentation.class) && !getterMethod.getAnnotation(OslcRepresentation.class).value().equals((Object)Representation.Inline);
            boolean showPropertyValueAsLink = isResourceValueType && isNotInlinedRepresentation;
            PropertyDefintion key = showPropertyHeadingsAsLinks ? PreviewFactory.constructPropertyDefintion(getterMethod.getAnnotation(OslcPropertyDefinition.class).value(), getterMethod.getAnnotation(OslcName.class).value()) : PreviewFactory.constructPropertyDefintion(getterMethod.getAnnotation(OslcName.class).value());
            if (showPropertyValueAsLink) {
                if (multiple) {
                    Collection links = (Collection)getterMethod.invoke((Object)aResource, new Object[0]);
                    l = new ArrayList<Link>();
                    for (org.eclipse.lyo.oslc4j.core.model.Link link : links) {
                        l.add(PreviewFactory.constructLink(link));
                    }
                    value = PreviewFactory.constructPropertyValue(PropertyDefintion.RepresentationType.LINK, multiple, l);
                } else {
                    org.eclipse.lyo.oslc4j.core.model.Link link = (org.eclipse.lyo.oslc4j.core.model.Link)getterMethod.invoke((Object)aResource, new Object[0]);
                    value = PreviewFactory.constructPropertyValue(PropertyDefintion.RepresentationType.LINK, multiple, PreviewFactory.constructLink(link));
                }
            } else if (!isNotInlinedRepresentation) {
                if (multiple) {
                    Collection rs = (Collection)getterMethod.invoke((Object)aResource, new Object[0]);
                    l = new ArrayList();
                    for (AbstractResource r : rs) {
                        l.add(null == r ? null : PreviewFactory.constructLink(r.getAbout().toString(), r.toString()));
                    }
                    value = PreviewFactory.constructPropertyValue(PropertyDefintion.RepresentationType.LINK, multiple, l);
                } else {
                    AbstractResource r = (AbstractResource)getterMethod.invoke((Object)aResource, new Object[0]);
                    value = PreviewFactory.constructPropertyValue(PropertyDefintion.RepresentationType.LINK, multiple, null == r ? null : PreviewFactory.constructLink(r.getAbout().toString(), r.toString()));
                }
            } else {
                value = PreviewFactory.constructPropertyValue(PropertyDefintion.RepresentationType.TEXT, multiple, getterMethod.invoke((Object)aResource, new Object[0]));
            }
            previewItems.add(PreviewFactory.constructProperty(key, value));
        }
        Preview oslcPreviewDataSet = new Preview();
        oslcPreviewDataSet.setProperties(previewItems);
        return oslcPreviewDataSet;
    }

    public static String getPreviewAsJsonString(AbstractResource aResource, List<String> getterMethodNames, boolean showPropertyHeadingsAsLinks) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, JsonProcessingException {
        Preview preview = PreviewFactory.getPreview(aResource, getterMethodNames, showPropertyHeadingsAsLinks);
        ObjectMapper mapper = new ObjectMapper();
        String previewAsString = mapper.writeValueAsString((Object)preview);
        return previewAsString;
    }

    private static Property constructProperty(PropertyDefintion propertyDefintion, PropertyValue propertyValue) {
        Property item = new Property();
        item.setPropertyDefintion(propertyDefintion);
        item.setPropertyValue(propertyValue);
        return item;
    }

    private static PropertyValue constructPropertyValue(PropertyDefintion.RepresentationType representationType, Boolean representAsList, Object data) {
        PropertyValue value = new PropertyValue();
        value.setRepresentationType(representationType);
        value.setRepresentAsList(representAsList);
        value.setData(Objects.requireNonNullElse(data, "<not set>"));
        return value;
    }

    private static PropertyDefintion getPropertyDefintion(PropertyDefintion.RepresentationType representationType, Object data) {
        PropertyDefintion key = new PropertyDefintion();
        key.setRepresentationType(representationType);
        key.setData(data);
        return key;
    }

    private static PropertyDefintion constructPropertyDefintion(String dataAsString) {
        return PreviewFactory.getPropertyDefintion(PropertyDefintion.RepresentationType.TEXT, dataAsString);
    }

    private static PropertyDefintion constructPropertyDefintion(String linkUri, String linkTitle) {
        return PreviewFactory.getPropertyDefintion(PropertyDefintion.RepresentationType.LINK, PreviewFactory.constructLink(linkUri, linkTitle));
    }

    private static Link constructLink(org.eclipse.lyo.oslc4j.core.model.Link link) {
        if (null == link) {
            return null;
        }
        if (StringUtils.isNullOrWhitespace((String)link.getLabel())) {
            return PreviewFactory.constructLink(((URI)link.getValue()).toString(), ((URI)link.getValue()).toString());
        }
        return PreviewFactory.constructLink(((URI)link.getValue()).toString(), link.getLabel());
    }

    private static Link constructLink(String link, String title) {
        Link l = new Link();
        l.setLink(link);
        l.setTitle(title);
        return l;
    }
}

