/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethod;
import org.eclipse.lsp4j.jsonrpc.json.MethodProvider;
import org.eclipse.lsp4j.jsonrpc.json.adapters.CollectionTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.json.adapters.EitherTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.json.adapters.EnumTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.json.adapters.MessageTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.messages.CancelParams;
import org.eclipse.lsp4j.jsonrpc.messages.Message;

public class MessageJsonHandler {
    public static final JsonRpcMethod CANCEL_METHOD = JsonRpcMethod.notification("$/cancelRequest", new Type[]{CancelParams.class});
    private final Gson gson;
    private final Map<String, JsonRpcMethod> supportedMethods;
    private MethodProvider methodProvider;
    private static MessageJsonHandler toStringInstance;

    public MessageJsonHandler(Map<String, JsonRpcMethod> supportedMethods) {
        this.supportedMethods = supportedMethods;
        this.gson = this.getDefaultGsonBuilder().create();
    }

    public MessageJsonHandler(Map<String, JsonRpcMethod> supportedMethods, Consumer<GsonBuilder> configureGson) {
        this.supportedMethods = supportedMethods;
        GsonBuilder gsonBuilder = this.getDefaultGsonBuilder();
        configureGson.accept(gsonBuilder);
        this.gson = gsonBuilder.create();
    }

    public GsonBuilder getDefaultGsonBuilder() {
        return new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new CollectionTypeAdapter.Factory()).registerTypeAdapterFactory((TypeAdapterFactory)new EitherTypeAdapter.Factory()).registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapter.Factory()).registerTypeAdapterFactory((TypeAdapterFactory)new MessageTypeAdapter.Factory(this));
    }

    public JsonRpcMethod getJsonRpcMethod(String name) {
        JsonRpcMethod result = this.supportedMethods.get(name);
        if (result != null) {
            return result;
        }
        if (CANCEL_METHOD.getMethodName().equals(name)) {
            return CANCEL_METHOD;
        }
        return null;
    }

    public MethodProvider getMethodProvider() {
        return this.methodProvider;
    }

    public void setMethodProvider(MethodProvider methodProvider) {
        this.methodProvider = methodProvider;
    }

    public Message parseMessage(CharSequence input) {
        return (Message)this.gson.fromJson(input.toString(), Message.class);
    }

    public Message parseMessage(Reader input) {
        return (Message)this.gson.fromJson(input, Message.class);
    }

    public String serialize(Message message) {
        return this.gson.toJson((Object)message, Message.class);
    }

    public void serialize(Message message, Writer output) {
        this.gson.toJson((Object)message, Message.class, (Appendable)output);
    }

    public static String toString(Object object) {
        if (toStringInstance == null) {
            toStringInstance = new MessageJsonHandler(Collections.emptyMap(), gsonBuilder -> gsonBuilder.setPrettyPrinting());
        }
        return MessageJsonHandler.toStringInstance.gson.toJson(object);
    }
}

