/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.develop;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.jkube.kit.common.util.ResourceUtil;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.maven.plugin.mojo.ManifestProvider;
import org.eclipse.jkube.maven.plugin.mojo.build.AbstractJKubeMojo;

@Mojo(name="undeploy", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.INSTALL)
public class UndeployMojo
extends AbstractJKubeMojo
implements ManifestProvider {
    @Parameter(property="jkube.kubernetesManifest", defaultValue="${basedir}/target/classes/META-INF/jkube/kubernetes.yml")
    protected File kubernetesManifest;
    @Parameter(property="jkube.resourceDir", defaultValue="${basedir}/src/main/jkube")
    protected File resourceDir;
    @Parameter(property="jkube.environment")
    private String environment;
    @Parameter(property="jkube.namespace")
    protected String namespace;

    @Override
    public File getKubernetesManifest() {
        return this.kubernetesManifest;
    }

    @Override
    protected void init() throws DependencyResolutionRequiredException {
        super.init();
        this.resources = ResourceConfig.toBuilder((ResourceConfig)this.resources).namespace((String)Optional.ofNullable(this.namespace).map(String::trim).filter(s -> !s.isEmpty()).orElse(null)).build();
    }

    @Override
    public final void executeInternal() throws MojoExecutionException {
        try {
            this.undeploy();
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    protected void undeploy() throws IOException {
        File environmentResourceDir = ResourceUtil.getFinalResourceDir((File)this.resourceDir, (String)this.environment);
        String fallbackNamespace = Optional.ofNullable(this.resources).map(ResourceConfig::getNamespace).orElse(this.clusterAccess.getNamespace());
        this.jkubeServiceHub.getUndeployService().undeploy(fallbackNamespace, environmentResourceDir, this.resources, this.getManifestsToUndeploy().toArray(new File[0]));
    }

    protected List<File> getManifestsToUndeploy() {
        ArrayList<File> ret = new ArrayList<File>();
        ret.add(this.getManifest(this.jkubeServiceHub.getClient()));
        return ret;
    }
}

