/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.internal;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.common.JettyExtensionConfig;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;

public class UpgradeResponseAdapter
implements UpgradeResponse {
    private final ServletUpgradeResponse servletResponse;

    public UpgradeResponseAdapter(ServletUpgradeResponse servletResponse) {
        this.servletResponse = servletResponse;
    }

    public void addHeader(String name, String value) {
        this.servletResponse.addHeader(name, value);
    }

    public String getAcceptedSubProtocol() {
        return this.servletResponse.getAcceptedSubProtocol();
    }

    public List<ExtensionConfig> getExtensions() {
        return this.servletResponse.getExtensions().stream().map(ext -> new JettyExtensionConfig(ext.getName(), ext.getParameters())).collect(Collectors.toList());
    }

    public String getHeader(String name) {
        return this.servletResponse.getHeader(name);
    }

    public Set<String> getHeaderNames() {
        return this.servletResponse.getHeaderNames();
    }

    public Map<String, List<String>> getHeaders() {
        return this.servletResponse.getHeadersMap();
    }

    public List<String> getHeaders(String name) {
        return this.servletResponse.getHeaders(name);
    }

    public int getStatusCode() {
        return this.servletResponse.getStatusCode();
    }

    public void sendForbidden(String message) throws IOException {
        this.servletResponse.sendForbidden(message);
    }

    public void setAcceptedSubProtocol(String protocol) {
        this.servletResponse.setAcceptedSubProtocol(protocol);
    }

    public void setExtensions(List<ExtensionConfig> extensions) {
        List coreExtensionConfigs = extensions.stream().map(ext -> new org.eclipse.jetty.websocket.core.ExtensionConfig(ext.getName(), ext.getParameters())).collect(Collectors.toList());
        this.servletResponse.setExtensions(coreExtensionConfigs);
    }

    public void setHeader(String name, String value) {
        this.servletResponse.setHeader(name, value);
    }

    public void setStatusCode(int statusCode) {
        this.servletResponse.setStatusCode(statusCode);
    }
}

