/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.server.internal;

import java.util.ArrayList;
import java.util.List;
import javax.websocket.DeploymentException;
import javax.websocket.EndpointConfig;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketContainer;
import org.eclipse.jetty.websocket.javax.common.ServerEndpointConfigWrapper;
import org.eclipse.jetty.websocket.javax.server.config.ContainerDefaultConfigurator;

public class AnnotatedServerEndpointConfig
extends ServerEndpointConfigWrapper {
    public AnnotatedServerEndpointConfig(JavaxWebSocketContainer containerScope, Class<?> endpointClass, ServerEndpoint anno) throws DeploymentException {
        this(containerScope, endpointClass, anno, null);
    }

    public AnnotatedServerEndpointConfig(JavaxWebSocketContainer containerScope, Class<?> endpointClass, ServerEndpoint anno, EndpointConfig baseConfig) throws DeploymentException {
        ServerEndpointConfig baseServerConfig = null;
        if (baseConfig instanceof ServerEndpointConfig) {
            baseServerConfig = (ServerEndpointConfig)baseConfig;
        }
        List decoders = baseConfig != null && baseConfig.getDecoders() != null && baseConfig.getDecoders().size() > 0 ? baseConfig.getDecoders() : List.of(anno.decoders());
        List encoders = baseConfig != null && baseConfig.getEncoders() != null && baseConfig.getEncoders().size() > 0 ? baseConfig.getEncoders() : List.of(anno.encoders());
        List subprotocols = baseServerConfig != null && baseServerConfig.getSubprotocols() != null && baseServerConfig.getSubprotocols().size() > 0 ? baseServerConfig.getSubprotocols() : List.of(anno.subprotocols());
        String path = baseServerConfig != null && baseServerConfig.getPath() != null && baseServerConfig.getPath().length() > 0 ? baseServerConfig.getPath() : anno.value();
        ServerEndpointConfig.Configurator rawConfigurator = AnnotatedServerEndpointConfig.getConfigurator(baseServerConfig, anno);
        ServerEndpointConfig.Configurator configurator = (ServerEndpointConfig.Configurator)containerScope.getObjectFactory().decorate((Object)rawConfigurator);
        ServerEndpointConfig endpointConfig = ServerEndpointConfig.Builder.create(endpointClass, (String)path).configurator(configurator).encoders(encoders).decoders(decoders).extensions(new ArrayList()).subprotocols(subprotocols).build();
        if (baseConfig != null && baseConfig.getUserProperties() != null && baseConfig.getUserProperties().size() > 0) {
            endpointConfig.getUserProperties().putAll(baseConfig.getUserProperties());
        }
        this.init(endpointConfig);
    }

    private static ServerEndpointConfig.Configurator getConfigurator(ServerEndpointConfig baseServerConfig, ServerEndpoint anno) throws DeploymentException {
        ServerEndpointConfig.Configurator ret = null;
        if (baseServerConfig != null) {
            ret = baseServerConfig.getConfigurator();
        }
        if (anno != null) {
            if (anno.configurator() == ServerEndpointConfig.Configurator.class) {
                if (ret == null) {
                    return new ContainerDefaultConfigurator();
                }
                return ret;
            }
            try {
                return (ServerEndpointConfig.Configurator)anno.configurator().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                StringBuilder err = new StringBuilder();
                err.append("Unable to instantiate ServerEndpoint.configurator() of ");
                err.append(anno.configurator().getName());
                err.append(" defined as annotation in ");
                err.append(anno.getClass().getName());
                throw new DeploymentException(err.toString(), (Throwable)e);
            }
        }
        return ret;
    }
}

