/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.server.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.WebSocketExtensionRegistry;
import org.eclipse.jetty.websocket.javax.common.ConfiguredEndpoint;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketContainer;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketExtension;
import org.eclipse.jetty.websocket.javax.common.ServerEndpointConfigWrapper;
import org.eclipse.jetty.websocket.javax.server.internal.AnnotatedServerEndpointConfig;
import org.eclipse.jetty.websocket.javax.server.internal.JsrHandshakeRequest;
import org.eclipse.jetty.websocket.javax.server.internal.JsrHandshakeResponse;
import org.eclipse.jetty.websocket.javax.server.internal.PathParamServerEndpointConfig;
import org.eclipse.jetty.websocket.util.server.internal.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.util.server.internal.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.util.server.internal.WebSocketCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaxWebSocketCreator
implements WebSocketCreator {
    public static final String PROP_REMOTE_ADDRESS = "javax.websocket.endpoint.remoteAddress";
    public static final String PROP_LOCAL_ADDRESS = "javax.websocket.endpoint.localAddress";
    public static final String PROP_LOCALES = "javax.websocket.upgrade.locales";
    private static final Logger LOG = LoggerFactory.getLogger(JavaxWebSocketCreator.class);
    private final JavaxWebSocketContainer containerScope;
    private final ServerEndpointConfig baseConfig;
    private final WebSocketExtensionRegistry extensionRegistry;

    public JavaxWebSocketCreator(JavaxWebSocketContainer containerScope, ServerEndpointConfig config, WebSocketExtensionRegistry extensionRegistry) {
        this.containerScope = containerScope;
        this.baseConfig = config;
        this.extensionRegistry = extensionRegistry;
    }

    public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
        List requested;
        JsrHandshakeRequest jsrHandshakeRequest = new JsrHandshakeRequest(req);
        JsrHandshakeResponse jsrHandshakeResponse = new JsrHandshakeResponse(resp);
        ServerEndpointConfigWrapper config = new ServerEndpointConfigWrapper(this.baseConfig){
            Map<String, Object> userProperties;
            {
                this.userProperties = new HashMap<String, Object>(JavaxWebSocketCreator.this.baseConfig.getUserProperties());
            }

            public Map<String, Object> getUserProperties() {
                return this.userProperties;
            }
        };
        Map userProperties = config.getUserProperties();
        userProperties.put(PROP_LOCAL_ADDRESS, req.getLocalSocketAddress());
        userProperties.put(PROP_REMOTE_ADDRESS, req.getRemoteSocketAddress());
        userProperties.put(PROP_LOCALES, Collections.list(req.getLocales()));
        ServerEndpointConfig.Configurator configurator = config.getConfigurator();
        if (!configurator.checkOrigin(req.getOrigin())) {
            block12: {
                try {
                    resp.sendForbidden("Origin mismatch");
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) break block12;
                    LOG.debug("Unable to send error response", (Throwable)e);
                }
            }
            return null;
        }
        List supported = config.getSubprotocols();
        String subprotocol = configurator.getNegotiatedSubprotocol(supported, requested = req.getSubProtocols());
        if (StringUtil.isNotBlank((String)subprotocol)) {
            resp.setAcceptedSubProtocol(subprotocol);
        }
        ArrayList<JavaxWebSocketExtension> installedExtensions = new ArrayList<JavaxWebSocketExtension>();
        for (Object extName : this.extensionRegistry.getAvailableExtensions().keySet()) {
            installedExtensions.add(new JavaxWebSocketExtension((String)extName));
        }
        ArrayList<JavaxWebSocketExtension> requestedExts = new ArrayList<JavaxWebSocketExtension>();
        for (ExtensionConfig reqCfg : req.getExtensions()) {
            requestedExts.add(new JavaxWebSocketExtension(reqCfg));
        }
        List usedExtensions = configurator.getNegotiatedExtensions(installedExtensions, requestedExts);
        ArrayList<ExtensionConfig> configs = new ArrayList<ExtensionConfig>();
        if (usedExtensions != null) {
            for (Extension used : usedExtensions) {
                ExtensionConfig ecfg = new ExtensionConfig(used.getName());
                for (Extension.Parameter param : used.getParameters()) {
                    ecfg.setParameter(param.getName(), param.getValue());
                }
                configs.add(ecfg);
            }
        }
        resp.setExtensions(configs);
        PathSpec pathSpec = jsrHandshakeRequest.getRequestPathSpec();
        if (pathSpec instanceof UriTemplatePathSpec) {
            UriTemplatePathSpec wspathSpec = (UriTemplatePathSpec)pathSpec;
            String requestPath = req.getRequestPath();
            config = new PathParamServerEndpointConfig((ServerEndpointConfig)config, wspathSpec, requestPath);
        }
        configurator.modifyHandshake((ServerEndpointConfig)config, (HandshakeRequest)jsrHandshakeRequest, (HandshakeResponse)jsrHandshakeResponse);
        jsrHandshakeResponse.setHeaders(jsrHandshakeResponse.getHeaders());
        try {
            Class endpointClass = config.getEndpointClass();
            Object endpoint = config.getConfigurator().getEndpointInstance(endpointClass);
            return new ConfiguredEndpoint(endpoint, (EndpointConfig)config);
        }
        catch (InstantiationException e) {
            LOG.warn("Unable to create websocket: " + config.getEndpointClass().getName(), (Throwable)e);
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaxWebSocketCreator that = (JavaxWebSocketCreator)o;
        return this.baseConfig != null ? this.baseConfig.equals(that.baseConfig) : that.baseConfig == null;
    }

    public int hashCode() {
        int result = this.baseConfig != null ? this.baseConfig.hashCode() : 0;
        return result;
    }

    public String toString() {
        return String.format("JsrCreator[%s%s]", this.baseConfig instanceof AnnotatedServerEndpointConfig ? "@" : "", this.baseConfig.getEndpointClass().getName());
    }
}

