/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.common;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.CloseReason;
import javax.websocket.Session;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketSession;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionTracker
extends AbstractLifeCycle
implements JavaxWebSocketSessionListener {
    private static final Logger LOG = LoggerFactory.getLogger(SessionTracker.class);
    private final CopyOnWriteArraySet<JavaxWebSocketSession> sessions = new CopyOnWriteArraySet();

    public Set<Session> getSessions() {
        return Collections.unmodifiableSet(this.sessions);
    }

    @Override
    public void onJavaxWebSocketSessionOpened(JavaxWebSocketSession session) {
        this.sessions.add(session);
    }

    @Override
    public void onJavaxWebSocketSessionClosed(JavaxWebSocketSession session) {
        this.sessions.remove(session);
    }

    protected void doStop() throws Exception {
        for (Session session : this.sessions) {
            try {
                session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, "Container being shut down"));
            }
            catch (IOException e) {
                LOG.trace("IGNORED", (Throwable)e);
            }
        }
        super.doStop();
    }
}

