/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.internal.io;

import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.ProtocolException;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.client.WebSocketClientFactory;
import org.eclipse.jetty.websocket.client.internal.DefaultWebSocketClient;
import org.eclipse.jetty.websocket.client.masks.Masker;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.io.AbstractWebSocketConnection;

public class WebSocketClientConnection
extends AbstractWebSocketConnection {
    private static final Logger LOG = Log.getLogger(WebSocketClientConnection.class);
    private final WebSocketClientFactory factory;
    private final DefaultWebSocketClient client;
    private final Masker masker;
    private boolean connected;

    public WebSocketClientConnection(EndPoint endp, Executor executor, DefaultWebSocketClient client) {
        super(endp, executor, client.getFactory().getScheduler(), client.getPolicy(), client.getFactory().getBufferPool());
        this.client = client;
        this.factory = client.getFactory();
        this.connected = false;
        this.masker = client.getMasker();
        assert (this.masker != null);
    }

    public DefaultWebSocketClient getClient() {
        return this.client;
    }

    public InetSocketAddress getLocalAddress() {
        return this.getEndPoint().getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.getEndPoint().getRemoteAddress();
    }

    public void onClose() {
        super.onClose();
        this.factory.sessionClosed(this.getSession());
    }

    public void onOpen() {
        if (!this.connected) {
            this.factory.sessionOpened(this.getSession());
            this.connected = true;
        }
        super.onOpen();
    }

    public void outgoingFrame(Frame frame, WriteCallback callback) {
        if (frame instanceof WebSocketFrame) {
            if (this.masker == null) {
                ProtocolException ex = new ProtocolException("Must set a Masker");
                LOG.warn((Throwable)ex);
                if (callback != null) {
                    callback.writeFailed((Throwable)ex);
                }
                return;
            }
            this.masker.setMask((WebSocketFrame)frame);
        }
        super.outgoingFrame(frame, callback);
    }

    public void setNextIncomingFrames(IncomingFrames incoming) {
        this.getParser().setIncomingFramesHandler(incoming);
    }
}

