/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.internal.io;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.UpgradeException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Extension;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.ClientUpgradeResponse;
import org.eclipse.jetty.websocket.client.internal.DefaultWebSocketClient;
import org.eclipse.jetty.websocket.client.internal.io.HttpResponseHeaderParser;
import org.eclipse.jetty.websocket.client.internal.io.WebSocketClientConnection;
import org.eclipse.jetty.websocket.common.AcceptHash;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.events.EventDriver;

public class UpgradeConnection
extends AbstractConnection {
    private static final Logger LOG = Log.getLogger(UpgradeConnection.class);
    private final ByteBufferPool bufferPool;
    private final DefaultWebSocketClient client;
    private final HttpResponseHeaderParser parser;
    private ClientUpgradeRequest request;

    public UpgradeConnection(EndPoint endp, Executor executor, DefaultWebSocketClient client) {
        super(endp, executor);
        this.client = client;
        this.bufferPool = client.getFactory().getBufferPool();
        this.parser = new HttpResponseHeaderParser();
        try {
            this.request = client.getUpgradeRequest();
        }
        catch (ClassCastException e) {
            client.failed(new RuntimeException("Invalid Upgrade Request structure", e));
        }
    }

    public void disconnect(boolean onlyOutput) {
        EndPoint endPoint = this.getEndPoint();
        LOG.debug("Shutting down output {}", new Object[]{endPoint});
        endPoint.shutdownOutput();
        if (!onlyOutput) {
            LOG.debug("Closing {}", new Object[]{endPoint});
            endPoint.close();
        }
    }

    private void notifyConnect(ClientUpgradeResponse response) {
        this.client.succeeded(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFillable() {
        ByteBuffer buffer = this.bufferPool.acquire(this.getInputBufferSize(), false);
        BufferUtil.clear((ByteBuffer)buffer);
        boolean readMore = false;
        try {
            readMore = this.read(buffer);
        }
        finally {
            this.bufferPool.release(buffer);
        }
        if (readMore) {
            this.fillInterested();
        }
    }

    public void onOpen() {
        super.onOpen();
        this.getExecutor().execute(new SendUpgradeRequest());
    }

    private boolean read(ByteBuffer buffer) {
        EndPoint endPoint = this.getEndPoint();
        try {
            ClientUpgradeResponse resp;
            do {
                int filled;
                if ((filled = endPoint.fill(buffer)) == 0) {
                    return true;
                }
                if (filled < 0) {
                    LOG.debug("read - EOF Reached", new Object[0]);
                    return false;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Filled {} bytes - {}", new Object[]{filled, BufferUtil.toDetailString((ByteBuffer)buffer)});
            } while ((resp = this.parser.parse(buffer)) == null);
            this.client.setUpgradeResponse(resp);
            this.validateResponse(resp);
            this.notifyConnect(resp);
            this.upgradeConnection(resp);
            return false;
        }
        catch (IOException e) {
            this.client.failed(e);
            this.disconnect(false);
            return false;
        }
        catch (UpgradeException e) {
            this.client.failed(e);
            this.disconnect(false);
            return false;
        }
    }

    private void upgradeConnection(ClientUpgradeResponse response) {
        EndPoint endp = this.getEndPoint();
        Executor executor = this.getExecutor();
        WebSocketClientConnection connection = new WebSocketClientConnection(endp, executor, this.client);
        EventDriver websocket = this.client.getWebSocket();
        WebSocketPolicy policy = this.client.getPolicy();
        String acceptedSubProtocol = response.getAcceptedSubProtocol();
        WebSocketSession session = new WebSocketSession(this.request.getRequestURI(), websocket, (LogicalConnection)connection);
        session.setPolicy(policy);
        session.setNegotiatedSubprotocol(acceptedSubProtocol);
        connection.setSession(session);
        List<Extension> extensions = this.client.getFactory().initExtensions(response.getExtensions());
        WebSocketSession incoming = session;
        if (extensions != null) {
            connection.getParser().configureFromExtensions(extensions);
            connection.getGenerator().configureFromExtensions(extensions);
        }
        connection.getParser().setIncomingFramesHandler((IncomingFrames)incoming);
        endp.setConnection((Connection)connection);
        connection.onOpen();
    }

    private void validateResponse(ClientUpgradeResponse response) {
        String reqKey = this.request.getKey();
        String expectedHash = AcceptHash.hashKey((String)reqKey);
        response.validateWebSocketHash(expectedHash);
        ArrayList<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>();
        List extValues = response.getHeaders("Sec-WebSocket-Extensions");
        if (extValues != null) {
            for (String extVal : extValues) {
                QuotedStringTokenizer tok = new QuotedStringTokenizer(extVal, ",");
                while (tok.hasMoreTokens()) {
                    extensions.add(ExtensionConfig.parse((String)tok.nextToken()));
                }
            }
        }
        response.setExtensions(extensions);
    }

    public class SendUpgradeRequest
    extends FutureCallback
    implements Runnable {
        @Override
        public void run() {
            URI uri = UpgradeConnection.this.client.getWebSocketUri();
            UpgradeConnection.this.request.setRequestURI(uri);
            String rawRequest = UpgradeConnection.this.request.generate();
            ByteBuffer buf = BufferUtil.toBuffer((String)rawRequest, (Charset)StringUtil.__UTF8_CHARSET);
            UpgradeConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{buf});
        }

        public void succeeded() {
            super.succeeded();
            UpgradeConnection.this.fillInterested();
        }
    }
}

