/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.TimerScheduler;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Extension;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.client.internal.ConnectionManager;
import org.eclipse.jetty.websocket.client.internal.DefaultWebSocketClient;
import org.eclipse.jetty.websocket.client.masks.Masker;
import org.eclipse.jetty.websocket.client.masks.RandomMasker;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.events.EventDriverFactory;
import org.eclipse.jetty.websocket.common.extensions.WebSocketExtensionFactory;

public class WebSocketClientFactory
extends ContainerLifeCycle {
    private static final Logger LOG = Log.getLogger(WebSocketClientFactory.class);
    private final ByteBufferPool bufferPool = new MappedByteBufferPool();
    private final Executor executor;
    private final Scheduler scheduler;
    private final EventDriverFactory eventDriverFactory;
    private final WebSocketPolicy policy;
    private final WebSocketExtensionFactory extensionRegistry;
    private SocketAddress bindAddress;
    private Masker masker;
    private final Queue<WebSocketSession> sessions = new ConcurrentLinkedQueue<WebSocketSession>();
    private ConnectionManager connectionManager;

    public WebSocketClientFactory() {
        this((Executor)new QueuedThreadPool());
    }

    public WebSocketClientFactory(Executor threadPool) {
        this(threadPool, (Scheduler)new TimerScheduler());
    }

    public WebSocketClientFactory(Executor threadPool, Scheduler scheduler) {
        this(threadPool, scheduler, null);
    }

    public WebSocketClientFactory(Executor executor, Scheduler scheduler, SslContextFactory sslContextFactory) {
        LOG.debug("new WebSocketClientFactory()", new Object[0]);
        if (executor == null) {
            throw new IllegalArgumentException("Executor is required");
        }
        this.executor = executor;
        this.addBean(executor);
        if (scheduler == null) {
            throw new IllegalArgumentException("Scheduler is required");
        }
        this.scheduler = scheduler;
        this.addBean(scheduler);
        if (sslContextFactory != null) {
            this.addBean(sslContextFactory);
        }
        this.policy = WebSocketPolicy.newClientPolicy();
        this.extensionRegistry = new WebSocketExtensionFactory(this.policy, this.bufferPool);
        this.connectionManager = new ConnectionManager(this.bufferPool, executor, scheduler, sslContextFactory, this.policy);
        this.addBean((Object)this.connectionManager);
        this.eventDriverFactory = new EventDriverFactory(this.policy);
        this.masker = new RandomMasker();
    }

    public WebSocketClientFactory(SslContextFactory sslContextFactory) {
        this((Executor)new QueuedThreadPool(), (Scheduler)new TimerScheduler(), sslContextFactory);
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.debug("doStart()", new Object[0]);
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("doStop()", new Object[0]);
    }

    public SocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public ExtensionFactory getExtensionFactory() {
        return this.extensionRegistry;
    }

    public Masker getMasker() {
        return this.masker;
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public List<Extension> initExtensions(List<ExtensionConfig> requested) {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        for (ExtensionConfig cfg : requested) {
            Extension extension = this.extensionRegistry.newInstance(cfg);
            if (extension == null) continue;
            LOG.debug("added {}", new Object[]{extension});
            extensions.add(extension);
        }
        LOG.debug("extensions={}", new Object[]{extensions});
        return extensions;
    }

    public WebSocketClient newWebSocketClient(Object websocketPojo) {
        LOG.debug("Creating new WebSocket for {}", new Object[]{websocketPojo});
        EventDriver websocket = this.eventDriverFactory.wrap(websocketPojo);
        DefaultWebSocketClient client = new DefaultWebSocketClient(this, websocket);
        client.setMasker(this.masker);
        return client;
    }

    public boolean sessionClosed(WebSocketSession session) {
        return this.isRunning() && this.sessions.remove(session);
    }

    public boolean sessionOpened(WebSocketSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session Opened: {}", new Object[]{session});
        }
        boolean ret = this.sessions.offer(session);
        session.open();
        return ret;
    }

    public void setBindAddress(SocketAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void setMasker(Masker masker) {
        this.masker = masker;
    }
}

