/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.internal;

import java.io.IOException;
import java.net.URI;
import java.util.Locale;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketConnection;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.ClientUpgradeResponse;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.client.WebSocketClientFactory;
import org.eclipse.jetty.websocket.client.internal.ConnectionManager;
import org.eclipse.jetty.websocket.client.masks.Masker;
import org.eclipse.jetty.websocket.client.masks.RandomMasker;
import org.eclipse.jetty.websocket.common.events.EventDriver;

public class DefaultWebSocketClient
extends FutureCallback<UpgradeResponse>
implements WebSocketClient {
    private static final Logger LOG = Log.getLogger(DefaultWebSocketClient.class);
    private final WebSocketClientFactory factory;
    private final WebSocketPolicy policy;
    private final EventDriver websocket;
    private URI websocketUri;
    private WebSocketConnection connection;
    private ClientUpgradeRequest upgradeRequest;
    private ClientUpgradeResponse upgradeResponse;
    private Masker masker;

    public DefaultWebSocketClient(WebSocketClientFactory factory, EventDriver websocket) {
        this.factory = factory;
        LOG.debug("factory.isRunning(): {}", new Object[]{factory.isRunning()});
        LOG.debug("factory.isStarted(): {}", new Object[]{factory.isStarted()});
        this.policy = factory.getPolicy();
        this.websocket = websocket;
        this.upgradeRequest = new ClientUpgradeRequest();
        this.masker = new RandomMasker();
    }

    public void completed(UpgradeResponse context) {
        LOG.debug("completed() - {}", new Object[]{context});
        super.completed((Object)context);
    }

    @Override
    public FutureCallback<UpgradeResponse> connect(URI websocketUri) throws IOException {
        if (!this.factory.isStarted()) {
            throw new IllegalStateException(WebSocketClientFactory.class.getSimpleName() + " is not started");
        }
        if (!websocketUri.isAbsolute()) {
            throw new IllegalArgumentException("WebSocket URI must be absolute");
        }
        if (StringUtil.isBlank((String)websocketUri.getScheme())) {
            throw new IllegalArgumentException("WebSocket URI must include a scheme");
        }
        String scheme = websocketUri.getScheme().toLowerCase(Locale.ENGLISH);
        if (!"ws".equals(scheme) && !"wss".equals(scheme)) {
            throw new IllegalArgumentException("WebSocket URI scheme only supports [ws] and [wss], not [" + scheme + "]");
        }
        this.websocketUri = websocketUri;
        FutureCallback<UpgradeResponse> result = null;
        LOG.debug("connect({})", new Object[]{websocketUri});
        ConnectionManager manager = this.factory.getConnectionManager();
        result = manager.connectVirtual(this);
        if (result == null) {
            result = manager.connectPhysical(this);
        }
        return result;
    }

    public void failed(UpgradeResponse context, Throwable cause) {
        LOG.debug("failed() - {}, {}", new Object[]{context, cause});
        LOG.info(cause);
        super.failed((Object)context, cause);
    }

    protected ClientUpgradeRequest getClientUpgradeRequest() {
        return this.upgradeRequest;
    }

    public WebSocketConnection getConnection() {
        return this.connection;
    }

    @Override
    public WebSocketClientFactory getFactory() {
        return this.factory;
    }

    @Override
    public Masker getMasker() {
        return this.masker;
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public UpgradeRequest getUpgradeRequest() {
        return this.upgradeRequest;
    }

    @Override
    public UpgradeResponse getUpgradeResponse() {
        return this.upgradeResponse;
    }

    @Override
    public EventDriver getWebSocket() {
        return this.websocket;
    }

    @Override
    public URI getWebSocketUri() {
        return this.websocketUri;
    }

    @Override
    public void setMasker(Masker masker) {
        this.masker = masker;
    }

    public void setUpgradeResponse(ClientUpgradeResponse response) {
        this.upgradeResponse = response;
    }
}

