/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.api.UpgradeRequest;
import org.eclipse.jetty.websocket.core.protocol.ExtensionConfig;

public class ClientUpgradeRequest
implements UpgradeRequest {
    private static final Logger LOG = Log.getLogger(ClientUpgradeRequest.class);
    private static final String HEADER_VALUES_DELIM = "\"\\\n\r\t\f\b%+ ;=";
    private static final Set<String> FORBIDDEN_HEADERS = new HashSet<String>();
    private final String key;
    private List<String> subProtocols;
    private List<ExtensionConfig> extensions;
    private Map<String, String> cookies;
    private Map<String, String> headers;
    private String httpEndPointName;
    private String host;

    public ClientUpgradeRequest() {
        byte[] bytes = new byte[16];
        new Random().nextBytes(bytes);
        this.key = new String(B64Code.encode((byte[])bytes));
        this.subProtocols = new ArrayList<String>();
        this.extensions = new ArrayList<ExtensionConfig>();
        this.cookies = new HashMap<String, String>();
        this.headers = new HashMap<String, String>();
    }

    public void addExtensions(String ... extConfigs) {
        for (String extConfig : extConfigs) {
            this.extensions.add(ExtensionConfig.parse((String)extConfig));
        }
    }

    public String generate(URI uri) {
        boolean needDelim;
        this.httpEndPointName = uri.toASCIIString();
        this.host = uri.getHost();
        StringBuilder request = new StringBuilder(512);
        request.append("GET ");
        if (StringUtil.isBlank((String)uri.getPath())) {
            request.append("/");
        } else {
            request.append(uri.getPath());
        }
        if (StringUtil.isNotBlank((String)uri.getRawQuery())) {
            request.append("?").append(uri.getRawQuery());
        }
        request.append(" HTTP/1.1\r\n");
        request.append("Host: ").append(this.host);
        if (uri.getPort() > 0) {
            request.append(':').append(uri.getPort());
        }
        request.append("\r\n");
        request.append("Upgrade: websocket\r\n");
        request.append("Connection: Upgrade\r\n");
        request.append("Sec-WebSocket-Key: ").append(this.key).append("\r\n");
        request.append("Sec-WebSocket-Version: 13\r\n");
        request.append("Pragma: no-cache\r\n");
        request.append("Cache-Control: no-cache\r\n");
        if (!this.getExtensions().isEmpty()) {
            request.append("Sec-WebSocket-Extensions: ");
            needDelim = false;
            for (ExtensionConfig ext : this.getExtensions()) {
                if (needDelim) {
                    request.append(", ");
                }
                request.append(ext.getParameterizedName());
                needDelim = true;
            }
            request.append("\r\n");
        }
        if (!this.getSubProtocols().isEmpty()) {
            request.append("Sec-WebSocket-Protocol: ");
            needDelim = false;
            for (String protocol : this.getSubProtocols()) {
                if (needDelim) {
                    request.append(", ");
                }
                request.append(protocol);
                needDelim = true;
            }
            request.append("\r\n");
        }
        if (!this.getCookieMap().isEmpty()) {
            request.append("Cookie: ");
            needDelim = false;
            for (String cookie : this.getCookieMap().keySet()) {
                if (needDelim) {
                    request.append("; ");
                }
                request.append(QuotedStringTokenizer.quoteIfNeeded((String)cookie, (String)HEADER_VALUES_DELIM));
                request.append("=");
                String val = this.cookies.get(cookie);
                request.append(QuotedStringTokenizer.quoteIfNeeded((String)val, (String)HEADER_VALUES_DELIM));
                needDelim = true;
            }
            request.append("\r\n");
        }
        for (String key : this.headers.keySet()) {
            String value = this.headers.get(key);
            if (FORBIDDEN_HEADERS.contains(key.toLowerCase())) {
                LOG.warn("Skipping forbidden header - {}: {}", new Object[]{key, value});
                continue;
            }
            request.append(key).append(": ");
            request.append(QuotedStringTokenizer.quoteIfNeeded((String)value, (String)HEADER_VALUES_DELIM));
            request.append("\r\n");
        }
        request.append("\r\n");
        return request.toString();
    }

    public Map<String, String> getCookieMap() {
        return this.cookies;
    }

    public List<ExtensionConfig> getExtensions() {
        return this.extensions;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public String getHost() {
        return this.host;
    }

    public String getHttpEndPointName() {
        return this.httpEndPointName;
    }

    public String getKey() {
        return this.key;
    }

    public String getOrigin() {
        return this.getHeader("Origin");
    }

    public List<String> getSubProtocols() {
        return this.subProtocols;
    }

    public boolean hasSubProtocol(String test) {
        for (String protocol : this.subProtocols) {
            if (!protocol.equalsIgnoreCase(test)) continue;
            return true;
        }
        return false;
    }

    public boolean isOrigin(String test) {
        return test.equalsIgnoreCase(this.getOrigin());
    }

    public void setSubProtocols(String protocols) {
        this.subProtocols.clear();
        if (StringUtil.isBlank((String)protocols)) {
            return;
        }
        for (String protocol : protocols.split("\\s*,\\s*")) {
            this.subProtocols.add(protocol);
        }
    }

    static {
        FORBIDDEN_HEADERS.add("cookie");
        FORBIDDEN_HEADERS.add("upgrade");
        FORBIDDEN_HEADERS.add("host");
        FORBIDDEN_HEADERS.add("connection");
        FORBIDDEN_HEADERS.add("sec-websocket-key");
        FORBIDDEN_HEADERS.add("sec-websocket-extensions");
        FORBIDDEN_HEADERS.add("sec-websocket-accept");
        FORBIDDEN_HEADERS.add("sec-websocket-protocol");
        FORBIDDEN_HEADERS.add("sec-websocket-version");
        FORBIDDEN_HEADERS.add("pragma");
        FORBIDDEN_HEADERS.add("cache-control");
    }
}

