/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.message;

import java.lang.invoke.MethodHandle;
import java.util.concurrent.Executor;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.websocket.common.AbstractMessageSink;
import org.eclipse.jetty.websocket.core.Frame;

public class PartialTextMessageSink
extends AbstractMessageSink {
    private final Utf8StringBuilder utf8Partial = new Utf8StringBuilder();

    public PartialTextMessageSink(Executor executor, MethodHandle methodHandle) {
        super(executor, methodHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Frame frame, Callback callback) {
        this.utf8Partial.append(frame.getPayload());
        String partialText = this.utf8Partial.takePartialString();
        try {
            this.methodHandle.invoke(partialText, frame.isFin());
            callback.succeeded();
        }
        catch (Throwable t) {
            callback.failed(t);
        }
        finally {
            if (frame.isFin()) {
                this.utf8Partial.reset();
            }
        }
    }
}

