/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.message;

import java.lang.invoke.MethodHandle;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.common.AbstractMessageSink;
import org.eclipse.jetty.websocket.common.MessageSink;
import org.eclipse.jetty.websocket.core.Frame;

public abstract class DispatchedMessageSink<T, R>
extends AbstractMessageSink {
    private CompletableFuture<Void> dispatchComplete;
    private MessageSink typeSink;

    public DispatchedMessageSink(Executor executor, MethodHandle methodHandle) {
        super(executor, methodHandle);
        Objects.requireNonNull(this.executor, "Executor");
    }

    public abstract MessageSink newSink(Frame var1);

    @Override
    public void accept(Frame frame, Callback callback) {
        Callback frameCallback;
        if (this.typeSink == null) {
            this.typeSink = this.newSink(frame);
            this.dispatchComplete = new CompletableFuture();
            this.executor.execute(() -> {
                MessageSink dispatchedType = this.typeSink;
                try {
                    this.methodHandle.invoke(dispatchedType);
                    this.dispatchComplete.complete(null);
                }
                catch (Throwable throwable) {
                    this.dispatchComplete.completeExceptionally(throwable);
                }
            });
        }
        if (frame.isFin()) {
            final CompletableFuture finComplete = new CompletableFuture();
            frameCallback = new Callback(){

                public void failed(Throwable cause) {
                    finComplete.completeExceptionally(cause);
                }

                public void succeeded() {
                    finComplete.complete(null);
                }
            };
            CompletableFuture.allOf(this.dispatchComplete, finComplete).whenComplete((aVoid, throwable) -> {
                this.typeSink = null;
                this.dispatchComplete = null;
                if (throwable != null) {
                    callback.failed(throwable);
                } else {
                    callback.succeeded();
                }
            });
        } else {
            frameCallback = callback;
        }
        this.typeSink.accept(frame, frameCallback);
    }
}

