/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.message;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.common.AbstractMessageSink;
import org.eclipse.jetty.websocket.common.invoke.InvalidSignatureException;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.MessageTooLargeException;

public class ByteArrayMessageSink
extends AbstractMessageSink {
    private static final byte[] EMPTY_BUFFER = new byte[0];
    private static final int BUFFER_SIZE = 65535;
    private final Session session;
    private ByteArrayOutputStream out;
    private int size;

    public ByteArrayMessageSink(Executor executor, MethodHandle methodHandle, Session session) {
        super(executor, methodHandle);
        this.session = session;
        Objects.requireNonNull(methodHandle, "MethodHandle");
        MethodType onMessageType = MethodType.methodType(Void.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        if (methodHandle.type() != onMessageType) {
            throw InvalidSignatureException.build(onMessageType, methodHandle.type());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Frame frame, Callback callback) {
        try {
            if (frame.hasPayload()) {
                ByteBuffer payload = frame.getPayload();
                this.size += payload.remaining();
                long maxMessageSize = this.session.getMaxBinaryMessageSize();
                if (maxMessageSize > 0L && (long)this.size > maxMessageSize) {
                    throw new MessageTooLargeException("Message size [" + this.size + "] exceeds maximum size [" + maxMessageSize + "]");
                }
                if (this.out == null) {
                    this.out = new ByteArrayOutputStream(65535);
                }
                BufferUtil.writeTo((ByteBuffer)payload, (OutputStream)this.out);
            }
            if (frame.isFin()) {
                if (this.out != null) {
                    byte[] buf = this.out.toByteArray();
                    this.methodHandle.invoke(buf, 0, buf.length);
                } else {
                    this.methodHandle.invoke(EMPTY_BUFFER, 0, 0);
                }
            }
            callback.succeeded();
        }
        catch (Throwable t) {
            callback.failed(t);
        }
        finally {
            if (frame.isFin()) {
                this.out = null;
                this.size = 0;
            }
        }
    }
}

