/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import java.io.IOException;
import java.net.CookieStore;
import java.net.SocketAddress;
import java.net.URI;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ShutdownThread;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.WebSocketSessionListener;
import org.eclipse.jetty.websocket.client.JettyUpgradeListener;
import org.eclipse.jetty.websocket.client.impl.JettyClientUpgradeRequest;
import org.eclipse.jetty.websocket.common.JettyWebSocketFrameHandler;
import org.eclipse.jetty.websocket.common.JettyWebSocketFrameHandlerFactory;
import org.eclipse.jetty.websocket.common.SessionTracker;
import org.eclipse.jetty.websocket.common.WebSocketContainer;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.core.client.UpgradeListener;
import org.eclipse.jetty.websocket.core.client.WebSocketCoreClient;

public class WebSocketClient
extends ContainerLifeCycle
implements WebSocketPolicy,
WebSocketContainer {
    private static final Logger LOG = Log.getLogger(WebSocketClient.class);
    private final WebSocketCoreClient coreClient;
    private final int id = ThreadLocalRandom.current().nextInt();
    private final JettyWebSocketFrameHandlerFactory frameHandlerFactory;
    private final List<WebSocketSessionListener> sessionListeners = new CopyOnWriteArrayList<WebSocketSessionListener>();
    private final SessionTracker sessionTracker = new SessionTracker();
    private final FrameHandler.ConfigurationCustomizer configurationCustomizer = new FrameHandler.ConfigurationCustomizer();
    private final WebSocketComponents components = new WebSocketComponents();
    private boolean stopAtShutdown = false;

    public WebSocketClient() {
        this(null);
    }

    public WebSocketClient(HttpClient httpClient) {
        this.coreClient = new WebSocketCoreClient(httpClient, this.components);
        this.addManaged((LifeCycle)this.coreClient);
        if (httpClient == null) {
            this.coreClient.getHttpClient().setName("Jetty-WebSocketClient@" + ((Object)((Object)this)).hashCode());
        }
        this.frameHandlerFactory = new JettyWebSocketFrameHandlerFactory((WebSocketContainer)this);
        this.sessionListeners.add((WebSocketSessionListener)this.sessionTracker);
        this.addBean(this.sessionTracker);
    }

    public CompletableFuture<Session> connect(Object websocket, URI toUri) throws IOException {
        return this.connect(websocket, toUri, null);
    }

    public CompletableFuture<Session> connect(Object websocket, URI toUri, UpgradeRequest request) throws IOException {
        return this.connect(websocket, toUri, request, null);
    }

    public CompletableFuture<Session> connect(Object websocket, URI toUri, UpgradeRequest request, final JettyUpgradeListener upgradeListener) throws IOException {
        for (Connection.Listener listener : this.getBeans(Connection.Listener.class)) {
            this.coreClient.addBean((Object)listener);
        }
        JettyClientUpgradeRequest upgradeRequest = new JettyClientUpgradeRequest(this, this.coreClient, request, toUri, websocket);
        if (upgradeListener != null) {
            upgradeRequest.addListener(new UpgradeListener(){

                public void onHandshakeRequest(HttpRequest request) {
                    upgradeListener.onHandshakeRequest(request);
                }

                public void onHandshakeResponse(HttpRequest request, HttpResponse response) {
                    upgradeListener.onHandshakeResponse(request, response);
                }
            });
        }
        upgradeRequest.setConfiguration(this.configurationCustomizer);
        CompletableFuture<Session> futureSession = new CompletableFuture<Session>();
        this.coreClient.connect((ClientUpgradeRequest)upgradeRequest).whenComplete((coreSession, error) -> {
            if (error != null) {
                futureSession.completeExceptionally(JettyWebSocketFrameHandler.convertCause((Throwable)error));
                return;
            }
            JettyWebSocketFrameHandler frameHandler = (JettyWebSocketFrameHandler)upgradeRequest.getFrameHandler();
            futureSession.complete((Session)frameHandler.getSession());
        });
        return futureSession;
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new Object[]{this.getOpenSessions()});
    }

    public WebSocketBehavior getBehavior() {
        return WebSocketBehavior.CLIENT;
    }

    public void addSessionListener(WebSocketSessionListener listener) {
        this.sessionListeners.add(listener);
    }

    public boolean removeSessionListener(WebSocketSessionListener listener) {
        return this.sessionListeners.remove(listener);
    }

    public void notifySessionListeners(Consumer<WebSocketSessionListener> consumer) {
        for (WebSocketSessionListener listener : this.sessionListeners) {
            try {
                consumer.accept(listener);
            }
            catch (Throwable x) {
                LOG.info("Exception while invoking listener " + listener, x);
            }
        }
    }

    public Duration getIdleTimeout() {
        return this.configurationCustomizer.getIdleTimeout();
    }

    public int getInputBufferSize() {
        return this.configurationCustomizer.getInputBufferSize();
    }

    public int getOutputBufferSize() {
        return this.configurationCustomizer.getOutputBufferSize();
    }

    public long getMaxBinaryMessageSize() {
        return this.configurationCustomizer.getMaxBinaryMessageSize();
    }

    public long getMaxTextMessageSize() {
        return this.configurationCustomizer.getMaxTextMessageSize();
    }

    public long getMaxFrameSize() {
        return this.configurationCustomizer.getMaxFrameSize();
    }

    public boolean isAutoFragment() {
        return this.configurationCustomizer.isAutoFragment();
    }

    public void setIdleTimeout(Duration duration) {
        this.configurationCustomizer.setIdleTimeout(duration);
        this.getHttpClient().setIdleTimeout(duration.toMillis());
    }

    public void setInputBufferSize(int size) {
        this.configurationCustomizer.setInputBufferSize(size);
    }

    public void setOutputBufferSize(int size) {
        this.configurationCustomizer.setOutputBufferSize(size);
    }

    public void setMaxBinaryMessageSize(long size) {
        this.configurationCustomizer.setMaxBinaryMessageSize(size);
    }

    public void setMaxTextMessageSize(long size) {
        this.configurationCustomizer.setMaxTextMessageSize(size);
    }

    public void setMaxFrameSize(long maxFrameSize) {
        this.configurationCustomizer.setMaxFrameSize(maxFrameSize);
    }

    public void setAutoFragment(boolean autoFragment) {
        this.configurationCustomizer.setAutoFragment(autoFragment);
    }

    public SocketAddress getBindAddress() {
        return this.getHttpClient().getBindAddress();
    }

    public void setBindAddress(SocketAddress bindAddress) {
        this.getHttpClient().setBindAddress(bindAddress);
    }

    public long getConnectTimeout() {
        return this.getHttpClient().getConnectTimeout();
    }

    public void setConnectTimeout(long ms) {
        this.getHttpClient().setConnectTimeout(ms);
    }

    public CookieStore getCookieStore() {
        return this.getHttpClient().getCookieStore();
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.getHttpClient().setCookieStore(cookieStore);
    }

    public ByteBufferPool getBufferPool() {
        return this.getHttpClient().getByteBufferPool();
    }

    public Executor getExecutor() {
        return this.getHttpClient().getExecutor();
    }

    public HttpClient getHttpClient() {
        return this.coreClient.getHttpClient();
    }

    public DecoratedObjectFactory getObjectFactory() {
        return this.components.getObjectFactory();
    }

    public Collection<Session> getOpenSessions() {
        return this.sessionTracker.getSessions();
    }

    public JettyWebSocketFrameHandler newFrameHandler(Object websocketPojo) {
        return this.frameHandlerFactory.newJettyFrameHandler(websocketPojo);
    }

    public SslContextFactory getSslContextFactory() {
        return this.getHttpClient().getSslContextFactory();
    }

    public synchronized void setStopAtShutdown(boolean stop) {
        if (stop) {
            if (!this.stopAtShutdown && !ShutdownThread.isRegistered((LifeCycle)this)) {
                ShutdownThread.register((LifeCycle[])new LifeCycle[]{this});
            }
        } else {
            ShutdownThread.deregister((LifeCycle)this);
        }
        this.stopAtShutdown = stop;
    }

    public boolean isStopAtShutdown() {
        return this.stopAtShutdown;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WebSocketClient@");
        sb.append(Integer.toHexString(this.id));
        sb.append("[coreClient=").append(this.coreClient);
        sb.append(",openSessions.size=");
        sb.append(this.getOpenSessions().size());
        sb.append(']');
        return sb.toString();
    }
}

