/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.xhtml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.xml.catalog.Catalog;
import javax.xml.catalog.CatalogManager;
import javax.xml.catalog.CatalogResolver;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jetty.toolchain.xhtml.CatalogXHTML;
import org.eclipse.jetty.toolchain.xhtml.InvalidXHTMLException;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XHTMLValidator {
    public static void validate(String content) throws InvalidXHTMLException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));){
            Catalog catalog = CatalogXHTML.getCatalogStrict();
            CatalogResolver resolver = CatalogManager.catalogResolver(catalog);
            DocumentBuilderFactory xmlDocumentBuilderFactory = DocumentBuilderFactory.newInstance();
            xmlDocumentBuilderFactory.setValidating(true);
            DocumentBuilder db = xmlDocumentBuilderFactory.newDocumentBuilder();
            db.setEntityResolver(resolver);
            final ArrayList errors = new ArrayList();
            db.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) {
                    exception.printStackTrace();
                }

                @Override
                public void error(SAXParseException exception) {
                    errors.add(exception);
                }

                @Override
                public void fatalError(SAXParseException exception) {
                    errors.add(exception);
                }
            });
            Document doc = db.parse(inputStream);
            doc.getDocumentElement().normalize();
            if (errors.size() > 0) {
                InvalidXHTMLException invalid = new InvalidXHTMLException("Failed to validate XHTML");
                for (SAXException saxException : errors) {
                    invalid.addSuppressed(saxException);
                }
                throw invalid;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new InvalidXHTMLException("Unable to setup parser: " + e.getMessage(), e);
        }
    }
}

