/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version.issues;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import okhttp3.Cache;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHMilestone;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.extras.okhttp3.OkHttpConnector;

public class GitHubIssueResolver {
    private Log log;
    private final String repoName;
    private Path cacheDirectory;
    private GitHub github;

    public GitHubIssueResolver(String repoName) {
        this.repoName = repoName;
    }

    public GitHubIssueResolver init(Log log) throws IOException {
        this.log = log;
        Path userHome = Paths.get(System.getProperty("user.home"), new String[0]);
        this.cacheDirectory = userHome.resolve(".cache/github/jetty");
        if (!Files.exists(this.cacheDirectory, new LinkOption[0])) {
            Files.createDirectories(this.cacheDirectory, new FileAttribute[0]);
        }
        Cache cache = new Cache(this.cacheDirectory.toFile(), 0xA00000L);
        this.github = GitHubBuilder.fromPropertyFile().withConnector((HttpConnector)new OkHttpConnector(new OkHttpClient.Builder().cache(cache).build())).build();
        if (!this.github.isCredentialValid()) {
            this.github = null;
            throw new IOException("Unable to access github, invalid credentials in ~/.github ?");
        }
        log.info((CharSequence)("Github API Rate Limits: " + this.github.getRateLimit().toString()));
        return this;
    }

    public GHIssue getIssue(String issueRef) throws IOException {
        int issueNum = Integer.parseInt(issueRef);
        try {
            return this.github.getRepository(this.repoName).getIssue(issueNum);
        }
        catch (FileNotFoundException fnfe) {
            this.log.warn((CharSequence)("error find issue with ref: " + issueRef), (Throwable)fnfe);
            return null;
        }
    }

    public GHMilestone createMilestone(String milestone) throws IOException {
        GHRepository ghRepository = this.github.getRepository(this.repoName);
        List ghMilestones = ghRepository.listMilestones(GHIssueState.ALL).asList();
        Optional<GHMilestone> ghMilestoneOptional = ghMilestones.stream().filter(ghMilestone -> StringUtils.equalsIgnoreCase((CharSequence)milestone, (CharSequence)ghMilestone.getTitle())).findFirst();
        if (ghMilestoneOptional.isPresent()) {
            return ghMilestoneOptional.get();
        }
        GHMilestone ghMilestone2 = ghRepository.createMilestone(milestone, "Milestone for version " + milestone);
        return ghMilestone2;
    }

    public void assignMilestone(GHMilestone ghMilestone, GHIssue ghIssue) {
    }

    public void destroy() {
        try {
            if (this.github != null) {
                this.log.info((CharSequence)("Github Rate Limit: " + this.github.getRateLimit()));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

