/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.jetty.toolchain.version.AbstractVersionMojo;
import org.eclipse.jetty.toolchain.version.Release;
import org.eclipse.jetty.toolchain.version.VersionPattern;
import org.eclipse.jetty.toolchain.version.VersionText;
import org.eclipse.jetty.toolchain.version.issues.GitHubIssueResolver;
import org.eclipse.jetty.toolchain.version.issues.IssueSyntax;
import org.kohsuke.github.GHMilestone;

@Mojo(name="stage-released", threadSafe=true)
public class StageReleasedMojo
extends AbstractVersionMojo {
    @Parameter(required=true, property="version.jettyVersion", defaultValue="${project.version}")
    private String jettyVersion;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.getLog().debug((CharSequence)("jettyVersion:" + this.jettyVersion));
            VersionPattern verTextPattern = new VersionPattern(this.versionTextKey);
            VersionText versionText = new VersionText(verTextPattern);
            versionText.read(this.versionTextInputFile);
            this.getLog().debug((CharSequence)("versionList:" + versionText.getVersionList()));
            GitHubIssueResolver gitHubIssueResolver = new GitHubIssueResolver(this.repoName).init(this.getLog());
            GHMilestone ghMilestone = gitHubIssueResolver.createMilestone(this.jettyVersion);
            this.getLog().info((CharSequence)("ghMilestone: " + ghMilestone));
            Optional<Release> releaseOptional = versionText.getReleases().stream().filter(release -> StringUtils.equalsIgnoreCase((CharSequence)release.getVersion(), (CharSequence)this.jettyVersion)).findFirst();
            if (!releaseOptional.isPresent()) {
                this.getLog().info((CharSequence)("cannot find any release in VERSION.TXT with version " + this.jettyVersion));
                return;
            }
            releaseOptional.get().getIssues().stream().filter(issue -> issue.getSyntax() == IssueSyntax.GITHUB).forEach(issue -> {});
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

