/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version.issues;

import java.text.CollationKey;
import java.text.Collator;
import java.util.Comparator;
import org.eclipse.jetty.toolchain.version.issues.Issue;

public class IssueComparator
implements Comparator<Issue> {
    private final Collator collator = Collator.getInstance();

    @Override
    public int compare(Issue o1, Issue o2) {
        CollationKey key1 = this.toKey(o1);
        CollationKey key2 = this.toKey(o2);
        return key1.compareTo(key2);
    }

    private CollationKey toKey(Issue issue) {
        if (issue == null || issue.getId() == null) {
            return this.collator.getCollationKey("");
        }
        String id = issue.getId();
        if (issue.getId().startsWith("JETTY-")) {
            id = issue.getId().substring("JETTY-".length());
        }
        try {
            Long numId = Long.parseLong(id);
            return this.collator.getCollationKey(String.format("%010d", numId));
        }
        catch (NumberFormatException e) {
            return this.collator.getCollationKey(issue.getId());
        }
    }
}

