/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jetty.toolchain.version.Release;
import org.eclipse.jetty.toolchain.version.VersionPattern;
import org.eclipse.jetty.toolchain.version.issues.Issue;
import org.eclipse.jetty.toolchain.version.issues.IssueParser;

public class VersionText {
    private boolean sortExisting = false;
    private VersionPattern versionPattern;
    private List<String> headers = new ArrayList<String>();
    private final LinkedList<Release> releases = new LinkedList();

    public VersionText(VersionPattern pat) {
        this.versionPattern = pat;
    }

    public void addRelease(Release rel) {
        this.releases.add(rel);
    }

    public Release findRelease(String version) {
        if (StringUtils.isBlank((String)version)) {
            return null;
        }
        for (Release release : this.releases) {
            if (!release.getVersion().equals(version)) continue;
            return release;
        }
        return null;
    }

    public String getPriorVersion(String currentVersion) {
        if (this.releases.isEmpty()) {
            return null;
        }
        Iterator reliter = this.releases.iterator();
        while (reliter.hasNext()) {
            Release rel = (Release)reliter.next();
            if (!rel.getVersion().equals(currentVersion) || (rel = (Release)reliter.next()) == null) continue;
            return rel.getVersion();
        }
        return null;
    }

    public List<Release> getReleases() {
        return this.releases;
    }

    public List<String> getVersionList() {
        ArrayList<String> versions = new ArrayList<String>();
        for (Release rel : this.releases) {
            versions.add(rel.getVersion());
        }
        return versions;
    }

    public VersionPattern getVersionPattern() {
        return this.versionPattern;
    }

    public boolean isSortExisting() {
        return this.sortExisting;
    }

    public void prepend(Release rel) {
        this.releases.add(0, rel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File versionTextFile) throws IOException {
        FileReader reader = null;
        BufferedReader buf = null;
        try {
            String line;
            reader = new FileReader(versionTextFile);
            buf = new BufferedReader(reader);
            Pattern patBullet = Pattern.compile("^ [\\*\\+-] ");
            this.releases.clear();
            Release release = null;
            Issue issue = null;
            IssueParser issueParser = new IssueParser();
            int linenum = 0;
            while ((line = buf.readLine()) != null) {
                ++linenum;
                if (StringUtils.isBlank((String)line)) continue;
                if (line.charAt(0) == '#') {
                    this.headers.add(line);
                    continue;
                }
                if (this.versionPattern.isMatch(line)) {
                    if (release != null) {
                        release.addIssue(issue);
                    }
                    issue = null;
                    if (release != null) {
                        this.releases.add(release);
                    }
                    String cleanVersion = this.versionPattern.getLastVersion();
                    release = new Release(cleanVersion.toString());
                    release.setExisting(true);
                    String on = this.versionPattern.getRemainingText();
                    release.parseReleasedOn(linenum, on);
                    continue;
                }
                Matcher mat = patBullet.matcher(line);
                if (mat.find()) {
                    release.addIssue(issue);
                    issue = issueParser.parseKnownIssue(line);
                    continue;
                }
                if (issue == null) {
                    issue = issueParser.parseKnownIssue(line);
                    continue;
                }
                issue.appendText(line);
            }
            if (release != null) {
                if (issue != null) {
                    release.addIssue(issue);
                }
                this.releases.add(release);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(buf);
            IOUtil.close((Reader)reader);
            throw throwable;
        }
        IOUtil.close((Reader)buf);
        IOUtil.close((Reader)reader);
    }

    public void replaceOrPrepend(Release rel) {
        int indexExisting = this.releases.indexOf(rel);
        if (indexExisting == -1) {
            this.releases.add(0, rel);
        } else {
            this.releases.set(indexExisting, rel);
        }
    }

    public void setReleases(List<Release> releases) {
        this.releases.addAll(releases);
    }

    public void setSortExisting(boolean allowExistingResort) {
        this.sortExisting = allowExistingResort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File versionTextFile) throws IOException {
        FileWriter writer = null;
        PrintWriter out = null;
        String LN = "\n";
        try {
            writer = new FileWriter(versionTextFile);
            out = new PrintWriter(writer);
            if (!this.headers.isEmpty()) {
                for (String line : this.headers) {
                    out.print(line);
                    out.print(LN);
                }
                out.print(LN);
            }
            for (Release release : this.releases) {
                out.print(release.getVersion());
                if (release.getReleasedOn() != null) {
                    SimpleDateFormat sdf = new SimpleDateFormat(" - dd MMMM yyyy");
                    out.print(sdf.format(release.getReleasedOn()));
                }
                out.print(LN);
                if (this.sortExisting) {
                    for (Issue issue : release.getSortedIssues()) {
                        out.print(issue.toString());
                        out.print(LN);
                    }
                } else if (release.isExisting()) {
                    for (Issue issue : release.getIssues()) {
                        out.print(issue.toString());
                        out.print(LN);
                    }
                } else {
                    for (Issue issue : release.getSortedIssues()) {
                        out.print(issue.toString());
                        out.print(LN);
                    }
                }
                out.print(LN);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(out);
            IOUtil.close((Writer)writer);
            throw throwable;
        }
        IOUtil.close((Writer)out);
        IOUtil.close((Writer)writer);
    }
}

