/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version;

import edu.emory.mathcs.backport.java.util.Collections;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jetty.toolchain.version.issues.Issue;
import org.eclipse.jetty.toolchain.version.issues.IssueComparator;

public class Release {
    private static final List<String> RELEASED_ON_FORMATS = new ArrayList<String>();
    private boolean existing = false;
    private List<Issue> issues = new ArrayList<Issue>();
    private Date releasedOn;
    private String version;

    public Release() {
    }

    public Release(String ver) {
        this.version = ver;
    }

    public void addIssue(Issue issue) {
        if (issue == null) {
            return;
        }
        if (!this.issues.contains(issue)) {
            this.issues.add(issue);
        }
    }

    public void addIssues(List<Issue> moreIssues) {
        for (Issue issue : moreIssues) {
            this.addIssue(issue);
        }
    }

    public void dropIssue(Issue issue) {
        this.issues.remove(issue);
    }

    public void dropIssues(List<Issue> dropIssues) {
        for (Issue issue : dropIssues) {
            this.dropIssue(issue);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Release other = (Release)obj;
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public Date getReleasedOn() {
        return this.releasedOn;
    }

    public List<Issue> getSortedIssues() {
        Collections.sort(this.issues, (Comparator)new IssueComparator());
        return this.issues;
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean isExisting() {
        return this.existing;
    }

    public void parseReleasedOn(int linenum, String rawdateStr) {
        String[] ordinals;
        if (StringUtils.isBlank((String)rawdateStr)) {
            this.releasedOn = null;
            return;
        }
        String rawdate = rawdateStr.trim();
        if (rawdate.startsWith("- ")) {
            rawdate = rawdate.substring(2);
        }
        for (String ordinal : ordinals = new String[]{"st", "nd", "rd", "th"}) {
            String simp;
            Pattern ordPat = Pattern.compile("[0-9]" + ordinal);
            Matcher mat = ordPat.matcher(rawdate);
            if (!mat.find()) continue;
            rawdate = simp = rawdate.substring(0, mat.start()) + rawdate.charAt(mat.start()) + rawdate.substring(mat.end());
        }
        for (String format : RELEASED_ON_FORMATS) {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            try {
                this.releasedOn = sdf.parse(rawdate);
                if (this.releasedOn == null) continue;
                return;
            }
            catch (ParseException parseException) {
            }
        }
        if (this.releasedOn == null) {
            System.err.printf("ERROR: Unable to parse raw date string [%s] on line #%d%n", rawdate, linenum);
        }
    }

    public void setExisting(boolean existing) {
        this.existing = existing;
    }

    public void setIssues(List<Issue> issues) {
        this.issues.clear();
        this.issues.addAll(issues);
    }

    public void setReleasedOn(Date releasedOn) {
        this.releasedOn = releasedOn;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Release[");
        buf.append("version=").append(this.version);
        buf.append(",releasedOn=");
        if (this.releasedOn == null) {
            buf.append("<null>");
        } else {
            buf.append(new SimpleDateFormat("MMM yyyy").format(this.releasedOn));
        }
        buf.append(",issues.size=").append(this.issues.size());
        buf.append("]");
        return buf.toString();
    }

    static {
        RELEASED_ON_FORMATS.add("M/d/yyyy");
        RELEASED_ON_FORMATS.add("EEE d MMMM yyyy");
        RELEASED_ON_FORMATS.add("d MMMM yyyy");
        RELEASED_ON_FORMATS.add("MMMM d yyyy");
        RELEASED_ON_FORMATS.add("MMMM yyyy");
    }
}

