/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;

public final class FS {
    private FS() {
    }

    public static void delete(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            FS.deleteFile(path);
        } else if (Files.isDirectory(path, new LinkOption[0])) {
            FS.deleteDirectory(path);
        } else {
            Assertions.fail((String)("Not able to delete path, not a file or directory? : " + path.toAbsolutePath()));
        }
    }

    public static void delete(File path) {
        FS.delete(path.toPath());
    }

    public static void deleteDirectory(File dir) {
        FS.deleteDirectory(dir.toPath());
    }

    public static void deleteDirectory(Path dir) {
        FS.recursiveDeleteDir(dir);
    }

    public static void deleteFile(File path) {
        Assertions.assertTrue((boolean)path.isFile(), (String)("Path must be a file: " + path.getAbsolutePath()));
        Assertions.assertTrue((boolean)FS.isTestingDir(path.getParentFile()), (String)("Can only delete content within the /target/tests/ directory: " + path.getAbsolutePath()));
        Assertions.assertTrue((boolean)path.delete(), (String)("Failed to delete file: " + path.getAbsolutePath()));
    }

    public static void deleteFile(Path path) {
        String location = path.toAbsolutePath().toString();
        if (Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
            Assertions.assertTrue((Files.isRegularFile(path, new LinkOption[0]) || Files.isSymbolicLink(path) ? 1 : 0) != 0, (String)("Path must be a file or link: " + location));
            Assertions.assertTrue((boolean)FS.isTestingDir(path.getParent()), (String)("Can only delete content within the /target/tests/ directory: " + location));
            try {
                Assertions.assertTrue((boolean)Files.deleteIfExists(path), (String)("Failed to delete file: " + location));
            }
            catch (IOException e) {
                Assertions.fail((String)("Unable to delete file: " + location), (Throwable)e);
            }
        }
    }

    public static void deleteDir(Path path) {
        String location = path.toAbsolutePath().toString();
        if (Files.exists(path, new LinkOption[0])) {
            Assertions.assertTrue((boolean)Files.isDirectory(path, new LinkOption[0]), (String)("Path must be a file: " + location));
            Assertions.assertTrue((boolean)FS.isTestingDir(path.getParent()), (String)("Can only delete content within the /target/tests/ directory: " + location));
            try {
                Assertions.assertTrue((boolean)Files.deleteIfExists(path), (String)("Failed to delete directory: " + location));
            }
            catch (IOException e) {
                Assertions.fail((String)("Unable to delete directory: " + location), (Throwable)e);
            }
        }
    }

    private static void recursiveDeleteDir(Path path) {
        String location = path.toAbsolutePath().toString();
        Assertions.assertTrue((boolean)FS.isTestingDir(path), (String)("Can only delete content within the /target/tests/ directory: " + location));
        try (DirectoryStream<Path> dir = Files.newDirectoryStream(path);){
            for (Path entry : dir) {
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    FS.recursiveDeleteDir(entry);
                    continue;
                }
                FS.deleteFile(entry);
            }
        }
        catch (DirectoryIteratorException e) {
            Assertions.fail((String)("Unable to (recursively) delete path: " + location), (Throwable)e);
        }
        catch (IOException e) {
            Assertions.fail((String)("Unable to (recursively) delete path: " + location), (Throwable)e);
        }
        FS.deleteDir(path);
    }

    public static void cleanDirectory(File dir) {
        FS.cleanDirectory(dir.toPath());
    }

    public static void cleanDirectory(Path dir) {
        FS.deleteDirectory(dir);
        FS.ensureDirExists(dir);
    }

    public static void ensureEmpty(File dir) {
        FS.ensureEmpty(dir.toPath());
    }

    public static void ensureEmpty(Path dir) {
        if (Files.exists(dir, new LinkOption[0])) {
            FS.cleanDirectory(dir);
        } else {
            FS.ensureDirExists(dir);
        }
    }

    public static void ensureDeleted(File dir) {
        FS.ensureDeleted(dir.toPath());
    }

    public static void ensureDeleted(Path dir) {
        if (Files.exists(dir, new LinkOption[0])) {
            FS.deleteDirectory(dir);
        }
    }

    public static void ensureDirExists(File dir) {
        if (dir.exists()) {
            Assertions.assertTrue((boolean)dir.isDirectory(), (String)("Path exists, but should be a Dir : " + dir.getAbsolutePath()));
        } else {
            Assertions.assertTrue((boolean)dir.mkdirs(), (String)("Creating dir: " + dir));
        }
    }

    public static void ensureDirExists(Path dir) {
        if (Files.exists(dir, new LinkOption[0])) {
            Assertions.assertTrue((boolean)Files.isDirectory(dir, new LinkOption[0]), (String)("Path exists, but should be a Dir : " + dir.toAbsolutePath()));
        } else {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
                Assertions.assertTrue((boolean)Files.exists(dir, new LinkOption[0]), (String)("Failed to create dir: " + dir));
            }
            catch (IOException e) {
                Assertions.fail((String)("Failed to create directory: " + dir), (Throwable)e);
            }
        }
    }

    protected static boolean isTestingDir(File dir) {
        return FS.isTestingDir(dir.toPath());
    }

    protected static boolean isTestingDir(Path dir) {
        try {
            return dir.toRealPath(new LinkOption[0]).startsWith(MavenTestingUtils.getTargetTestingPath());
        }
        catch (IOException e) {
            return dir.toAbsolutePath().startsWith(MavenTestingUtils.getTargetTestingPath());
        }
    }

    public static void touch(File file) throws IOException {
        if (file.exists()) {
            Assertions.assertTrue((boolean)file.setLastModified(System.currentTimeMillis()), (String)"Updating last modified timestamp");
        } else {
            Assertions.assertTrue((boolean)file.createNewFile(), (String)("Creating file: " + file));
        }
    }

    public static void touch(Path file) throws IOException {
        if (Files.exists(file, new LinkOption[0])) {
            FileTime timeOrig = Files.getLastModifiedTime(file, new LinkOption[0]);
            Files.setLastModifiedTime(file, FileTime.from(System.currentTimeMillis(), TimeUnit.MILLISECONDS));
            FileTime timeNow = Files.getLastModifiedTime(file, new LinkOption[0]);
            MatcherAssert.assertThat((String)"Timestamp updated", (Object)timeOrig, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)timeNow)));
        } else {
            Files.createFile(file, new FileAttribute[0]);
            Assertions.assertTrue((boolean)Files.exists(file, new LinkOption[0]), (String)("Created new file?: " + file));
        }
    }

    public static String separators(String path) {
        StringBuilder ret = new StringBuilder();
        for (char c : path.toCharArray()) {
            if (c == '/' || c == '\\') {
                ret.append(File.separatorChar);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }
}

