/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.nio.ByteBuffer;
import org.eclipse.jetty.toolchain.test.ByteBufferUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class ByteBufferAssert {
    public static void assertEquals(String message, byte[] expected, byte[] actual) {
        Assert.assertThat((String)(message + " byte[].length"), (Object)actual.length, (Matcher)CoreMatchers.is((Object)expected.length));
        int len = expected.length;
        for (int i = 0; i < len; ++i) {
            Assert.assertThat((String)(message + " byte[" + i + "]"), (Object)actual[i], (Matcher)CoreMatchers.is((Object)expected[i]));
        }
    }

    public static void assertEquals(String message, ByteBuffer expectedBuffer, ByteBuffer actualBuffer) {
        if (expectedBuffer == null) {
            Assert.assertThat((String)message, (Object)actualBuffer, (Matcher)CoreMatchers.nullValue());
        } else {
            byte[] expectedBytes = ByteBufferUtils.toArray(expectedBuffer);
            byte[] actualBytes = ByteBufferUtils.toArray(actualBuffer);
            ByteBufferAssert.assertEquals(message, expectedBytes, actualBytes);
        }
    }

    public static void assertEquals(String message, String expectedString, ByteBuffer actualBuffer) {
        String actualString = ByteBufferUtils.toString(actualBuffer);
        Assert.assertThat((String)message, (Object)actualString, (Matcher)CoreMatchers.is((Object)expectedString));
    }

    public static void assertSize(String message, int expectedSize, ByteBuffer buffer) {
        if (expectedSize == 0 && buffer == null) {
            return;
        }
        Assert.assertThat((String)(message + " buffer.remaining"), (Object)buffer.remaining(), (Matcher)CoreMatchers.is((Object)expectedSize));
    }
}

