/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventQueue<E>
extends LinkedBlockingQueue<E> {
    private final ReentrantLock lock = new ReentrantLock();
    private AtomicReference<CountDownLatch> expectedEventCountLatch = new AtomicReference();

    @Override
    public boolean add(E o) {
        boolean ret = super.add(o);
        this.triggerCountdown();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitEventCount(int expectedEventCount, int timeoutDuration, TimeUnit timeoutUnit) throws TimeoutException, InterruptedException {
        this.lock.lock();
        try {
            CountDownLatch latch = new CountDownLatch(expectedEventCount);
            this.expectedEventCountLatch.set(latch);
            if (!latch.await(timeoutDuration, timeoutUnit)) {
                throw new TimeoutException(String.format("Timeout waiting for %d events", expectedEventCount));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean offer(E o) {
        boolean ret = super.offer(o);
        this.triggerCountdown();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerCountdown() {
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            CountDownLatch countdown = this.expectedEventCountLatch.get();
            if (countdown != null) {
                countdown.countDown();
            }
        }
    }
}

