/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class JmxServiceConnection {
    private String _serviceUrl;
    private MBeanServer _server;
    private JMXConnectorServer _connectorServer;
    private JMXConnector _serverConnector;
    private MBeanServerConnection _serviceConnection;

    public JmxServiceConnection() throws IOException {
        this(null);
    }

    public JmxServiceConnection(String url) throws IOException {
        this._serviceUrl = url;
    }

    public String getServiceUrl() {
        return this._serviceUrl;
    }

    public MBeanServerConnection getConnection() {
        return this._serviceConnection;
    }

    public void connect() throws IOException {
        if (this._serviceConnection == null) {
            if (this._serviceUrl == null) {
                this.openLoopbackConnection();
            } else {
                this.openServerConnection(this._serviceUrl);
            }
        }
    }

    private void openLoopbackConnection() throws IOException {
        this._server = ManagementFactory.getPlatformMBeanServer();
        JMXServiceURL serviceUrl = new JMXServiceURL("service:jmx:rmi://");
        this._connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(serviceUrl, null, this._server);
        this._connectorServer.start();
        this._serviceUrl = this._connectorServer.getAddress().toString();
        this._serverConnector = JMXConnectorFactory.connect(this._connectorServer.getAddress());
        this._serviceConnection = this._serverConnector.getMBeanServerConnection();
    }

    private void openServerConnection(String url) throws IOException {
        this._serviceUrl = url;
        JMXServiceURL serviceUrl = new JMXServiceURL(this._serviceUrl);
        this._serverConnector = JMXConnectorFactory.connect(serviceUrl);
        this._serviceConnection = this._serverConnector.getMBeanServerConnection();
    }

    public void disconnect() {
        try {
            if (this._serverConnector != null) {
                this._serverConnector.close();
                this._serviceConnection = null;
            }
            if (this._connectorServer != null) {
                this._connectorServer.stop();
                this._connectorServer = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }
}

