/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.io.File;
import java.io.IOException;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.toolchain.test.TestingDir;
import org.junit.Assert;

public class FS {
    public static void delete(File path) {
        if (!path.exists()) {
            return;
        }
        if (path.isFile()) {
            FS.deleteFile(path);
        } else if (path.isDirectory()) {
            FS.deleteDirectory(path);
        } else {
            Assert.fail((String)("Not able to delete path, not a file or directory? : " + path.getAbsolutePath()));
        }
    }

    public static void deleteDirectory(File dir) {
        FS.recursiveDelete(dir);
    }

    public static void deleteFile(File path) {
        Assert.assertTrue((String)("Path must be a file: " + path.getAbsolutePath()), (boolean)path.isFile());
        Assert.assertTrue((String)("Can only delete content within the /target/tests/ directory: " + path.getAbsolutePath()), (boolean)FS.isTestingDir(path.getParentFile()));
        Assert.assertTrue((String)("Failed to delete file: " + path.getAbsolutePath()), (boolean)path.delete());
    }

    private static void recursiveDelete(File dir) {
        Assert.assertTrue((String)("Can only delete content within the /target/tests/ directory: " + dir.getAbsolutePath()), (boolean)FS.isTestingDir(dir));
        for (File file : dir.listFiles()) {
            if (file.isFile()) {
                Assert.assertTrue((String)("Failed to delete file: " + file.getAbsolutePath()), (boolean)file.delete());
                continue;
            }
            if (!file.isDirectory()) continue;
            FS.recursiveDelete(file);
        }
        Assert.assertTrue((String)("Failed to delete dir: " + dir.getAbsolutePath()), (boolean)dir.delete());
    }

    public static void cleanDirectory(File dir) {
        FS.deleteDirectory(dir);
        FS.ensureDirExists(dir);
    }

    public static void ensureEmpty(File dir) {
        if (dir.exists()) {
            FS.cleanDirectory(dir);
        } else {
            Assert.assertTrue((String)("Creating dir: " + dir), (boolean)dir.mkdirs());
        }
    }

    public static void ensureEmpty(TestingDir testingdir) {
        FS.ensureEmpty(testingdir.getDir());
    }

    public static void ensureDeleted(File dir) {
        if (dir.exists()) {
            FS.deleteDirectory(dir);
        }
    }

    public static void ensureDirExists(File dir) {
        if (!dir.exists()) {
            Assert.assertTrue((String)("Creating dir: " + dir), (boolean)dir.mkdirs());
        } else {
            Assert.assertTrue((String)("Path exists, but should be a Dir : " + dir.getAbsolutePath()), (boolean)dir.isDirectory());
        }
    }

    protected static boolean isTestingDir(File dir) {
        return dir.getAbsolutePath().startsWith(MavenTestingUtils.getTargetTestingDir().getAbsolutePath());
    }

    public static void touch(File file) throws IOException {
        if (!file.exists()) {
            Assert.assertTrue((String)("Creating file: " + file), (boolean)file.createNewFile());
        } else {
            Assert.assertTrue((String)"Updating last modified timestamp", (boolean)file.setLastModified(System.currentTimeMillis()));
        }
    }
}

