/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.testing;

import java.net.InetAddress;
import java.util.Enumeration;
import java.util.EventListener;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.Attributes;

public class ServletTester {
    Server _server = new Server();
    LocalConnector _connector = new LocalConnector();
    ServletContextHandler _context = new ServletContextHandler(1);

    public ServletTester() {
        try {
            this._server.addBean((Object)new ErrorHandler());
            this._server.setSendServerVersion(false);
            this._server.addConnector((Connector)this._connector);
            this._server.setHandler((Handler)this._context);
        }
        catch (Error e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void dump() {
        this._server.dump();
    }

    public void start() throws Exception {
        this._server.start();
    }

    public void stop() throws Exception {
        this._server.stop();
    }

    public ServletContextHandler getContext() {
        return this._context;
    }

    public String getResponses(String rawRequests) throws Exception {
        return this._connector.getResponses(rawRequests);
    }

    public String getResponses(String rawRequests, LocalConnector connector) throws Exception {
        return connector.getResponses(rawRequests);
    }

    public ByteArrayBuffer getResponses(ByteArrayBuffer rawRequests) throws Exception {
        return this._connector.getResponses(rawRequests, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createSocketConnector(boolean localhost) throws Exception {
        ServletTester servletTester = this;
        synchronized (servletTester) {
            SocketConnector connector = new SocketConnector();
            if (localhost) {
                connector.setHost("127.0.0.1");
            }
            this._server.addConnector((Connector)connector);
            if (this._server.isStarted()) {
                connector.start();
            } else {
                connector.open();
            }
            return "http://127.0.0.1:" + connector.getLocalPort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createChannelConnector(boolean localhost) throws Exception {
        ServletTester servletTester = this;
        synchronized (servletTester) {
            SelectChannelConnector connector = new SelectChannelConnector();
            if (localhost) {
                connector.setHost("127.0.0.1");
            }
            this._server.addConnector((Connector)connector);
            if (this._server.isStarted()) {
                connector.start();
            } else {
                connector.open();
            }
            return "http://" + (localhost ? "127.0.0.1" : InetAddress.getLocalHost().getHostAddress()) + ":" + connector.getLocalPort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalConnector createLocalConnector() throws Exception {
        ServletTester servletTester = this;
        synchronized (servletTester) {
            LocalConnector connector = new LocalConnector();
            this._server.addConnector((Connector)connector);
            if (this._server.isStarted()) {
                connector.start();
            }
            return connector;
        }
    }

    public void addEventListener(EventListener listener) {
        this._context.addEventListener(listener);
    }

    public FilterHolder addFilter(Class filterClass, String pathSpec, int dispatches) {
        return this._context.addFilter(filterClass, pathSpec, dispatches);
    }

    public FilterHolder addFilter(String filterClass, String pathSpec, int dispatches) {
        return this._context.addFilter(filterClass, pathSpec, dispatches);
    }

    public ServletHolder addServlet(Class servlet, String pathSpec) {
        return this._context.addServlet(servlet, pathSpec);
    }

    public ServletHolder addServlet(String className, String pathSpec) {
        return this._context.addServlet(className, pathSpec);
    }

    public Object getAttribute(String name) {
        return this._context.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this._context.getAttributeNames();
    }

    public Attributes getAttributes() {
        return this._context.getAttributes();
    }

    public String getResourceBase() {
        return this._context.getResourceBase();
    }

    public void setAttribute(String name, Object value) {
        this._context.setAttribute(name, value);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._context.setClassLoader(classLoader);
    }

    public void setContextPath(String contextPath) {
        this._context.setContextPath(contextPath);
    }

    public void setEventListeners(EventListener[] eventListeners) {
        this._context.setEventListeners(eventListeners);
    }

    public void setResourceBase(String resourceBase) {
        this._context.setResourceBase(resourceBase);
    }
}

