/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server;

import java.io.IOException;
import java.util.List;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.npn.NextProtoNego;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class NextProtoNegoServerConnection
extends AbstractConnection
implements NextProtoNego.ServerProvider {
    private final Logger logger = Log.getLogger(((Object)((Object)this)).getClass());
    private final Connector connector;
    private final SSLEngine engine;
    private final List<String> protocols;
    private final String defaultProtocol;
    private boolean completed;

    public NextProtoNegoServerConnection(SslConnection.DecryptedEndPoint endPoint, Connector connector, List<String> protocols, String defaultProtocol) {
        super((EndPoint)endPoint, connector.getExecutor());
        this.connector = connector;
        this.protocols = protocols;
        this.defaultProtocol = defaultProtocol;
        this.engine = endPoint.getSslConnection().getSSLEngine();
        NextProtoNego.put((SSLEngine)this.engine, (NextProtoNego.Provider)this);
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    public void onClose() {
        super.onClose();
    }

    public void onFillable() {
        int filled;
        do {
            if ((filled = this.fill()) != 0 || this.completed) continue;
            this.fillInterested();
        } while (filled > 0 && !this.completed);
    }

    private int fill() {
        try {
            return this.getEndPoint().fill(BufferUtil.EMPTY_BUFFER);
        }
        catch (IOException x) {
            this.logger.debug((Throwable)x);
            this.getEndPoint().close();
            return -1;
        }
    }

    public void unsupported() {
        this.protocolSelected(this.defaultProtocol);
    }

    public List<String> protocols() {
        return this.protocols;
    }

    public void protocolSelected(String protocol) {
        NextProtoNego.remove((SSLEngine)this.engine);
        ConnectionFactory connectionFactory = this.connector.getConnectionFactory(protocol);
        EndPoint endPoint = this.getEndPoint();
        endPoint.getConnection().onClose();
        Connection connection = connectionFactory.newConnection(this.connector, endPoint);
        endPoint.setConnection(connection);
        connection.onOpen();
        this.completed = true;
    }
}

